
package org.virtualbox_7_2.jaxws;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for RecordingState.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="RecordingState">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Unknown"/>
 *     &lt;enumeration value="Initializing"/>
 *     &lt;enumeration value="Started"/>
 *     &lt;enumeration value="Paused"/>
 *     &lt;enumeration value="Resumed"/>
 *     &lt;enumeration value="Finalizing"/>
 *     &lt;enumeration value="Stopped"/>
 *     &lt;enumeration value="Canceled"/>
 *     &lt;enumeration value="LimitReached"/>
 *     &lt;enumeration value="Error"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "RecordingState")
@XmlEnum
public enum RecordingState {

    @XmlEnumValue("Unknown")
    UNKNOWN("Unknown"),
    @XmlEnumValue("Initializing")
    INITIALIZING("Initializing"),
    @XmlEnumValue("Started")
    STARTED("Started"),
    @XmlEnumValue("Paused")
    PAUSED("Paused"),
    @XmlEnumValue("Resumed")
    RESUMED("Resumed"),
    @XmlEnumValue("Finalizing")
    FINALIZING("Finalizing"),
    @XmlEnumValue("Stopped")
    STOPPED("Stopped"),
    @XmlEnumValue("Canceled")
    CANCELED("Canceled"),
    @XmlEnumValue("LimitReached")
    LIMIT_REACHED("LimitReached"),
    @XmlEnumValue("Error")
    ERROR("Error");
    private final String value;

    RecordingState(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static RecordingState fromValue(String v) {
        for (RecordingState c: RecordingState.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
