/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.util.List;
import org.virtualbox_7_2.DHCPConfigScope;
import org.virtualbox_7_2.Helper;
import org.virtualbox_7_2.Holder;
import org.virtualbox_7_2.IDHCPConfig;
import org.virtualbox_7_2.IDHCPGlobalConfig;
import org.virtualbox_7_2.IDHCPGroupConfig;
import org.virtualbox_7_2.IDHCPIndividualConfig;
import org.virtualbox_7_2.IEventSource;
import org.virtualbox_7_2.IUnknown;
import org.virtualbox_7_2.ObjectRefManager;
import org.virtualbox_7_2.VBoxException;
import org.virtualbox_7_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDHCPServer
extends IUnknown {
    public IDHCPServer(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public IEventSource getEventSource() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.idhcpServerGetEventSource(this.obj);
            IEventSource iEventSource = string.length() > 0 ? new IEventSource(string, this.getObjMgr(), this.port) : null;
            return iEventSource;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public Boolean getEnabled() {
        try {
            Boolean bl = this.port.idhcpServerGetEnabled(this.obj);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void setEnabled(Boolean bl) {
        try {
            this.port.idhcpServerSetEnabled(this.obj, bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getIPAddress() {
        try {
            String string = this.port.idhcpServerGetIPAddress(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getNetworkMask() {
        try {
            String string = this.port.idhcpServerGetNetworkMask(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getNetworkName() {
        try {
            String string = this.port.idhcpServerGetNetworkName(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getLowerIP() {
        try {
            String string = this.port.idhcpServerGetLowerIP(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getUpperIP() {
        try {
            String string = this.port.idhcpServerGetUpperIP(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IDHCPGlobalConfig getGlobalConfig() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.idhcpServerGetGlobalConfig(this.obj);
            IDHCPGlobalConfig iDHCPGlobalConfig = string.length() > 0 ? new IDHCPGlobalConfig(string, this.getObjMgr(), this.port) : null;
            return iDHCPGlobalConfig;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IDHCPGroupConfig> getGroupConfigs() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.idhcpServerGetGroupConfigs(this.obj);
            List<IDHCPGroupConfig> list2 = Helper.wrap(IDHCPGroupConfig.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IDHCPIndividualConfig> getIndividualConfigs() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.idhcpServerGetIndividualConfigs(this.obj);
            List<IDHCPIndividualConfig> list2 = Helper.wrap(IDHCPIndividualConfig.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static IDHCPServer queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IDHCPServer(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public void setConfiguration(String string, String string2, String string3, String string4) {
        try {
            this.port.idhcpServerSetConfiguration(this.obj, string, string2, string3, string4);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void start(String string, String string2) {
        try {
            this.port.idhcpServerStart(this.obj, string, string2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void stop() {
        try {
            this.port.idhcpServerStop(this.obj);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void restart() {
        try {
            this.port.idhcpServerRestart(this.obj);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void findLeaseByMAC(String string, Integer n, Holder<String> holder, Holder<String> holder2, Holder<Long> holder3, Holder<Long> holder4) {
        try {
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder6 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder7 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder8 = new javax.xml.ws.Holder();
            this.port.idhcpServerFindLeaseByMAC(this.obj, string, n, (javax.xml.ws.Holder<String>)holder5, (javax.xml.ws.Holder<String>)holder6, (javax.xml.ws.Holder<Long>)holder7, (javax.xml.ws.Holder<Long>)holder8);
            holder.value = holder5.value;
            holder2.value = holder6.value;
            holder3.value = holder7.value;
            holder4.value = holder8.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IDHCPConfig getConfig(DHCPConfigScope dHCPConfigScope, String string, Long l, Boolean bl) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.idhcpServerGetConfig(this.obj, org.virtualbox_7_2.jaxws.DHCPConfigScope.fromValue(dHCPConfigScope.name()), string, l, bl);
            IDHCPConfig iDHCPConfig = string2.length() > 0 ? new IDHCPConfig(string2, this.getObjMgr(), this.port) : null;
            return iDHCPConfig;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }
}

