/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;

public final class PoolUtils {
    private static final String MSG_FACTOR_NEGATIVE = "factor must be positive.";
    private static final String MSG_MIN_IDLE = "minIdle must be non-negative.";
    static final String MSG_NULL_KEY = "key must not be null.";
    private static final String MSG_NULL_KEYED_POOL = "keyedPool must not be null.";
    static final String MSG_NULL_KEYS = "keys must not be null.";
    private static final String MSG_NULL_POOL = "pool must not be null.";

    public static <K, V> Map<K, TimerTask> checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n, long l) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        HashMap hashMap = new HashMap(collection.size());
        collection.forEach(object -> hashMap.put(object, PoolUtils.checkMinIdle(keyedObjectPool, object, n, l)));
        return hashMap;
    }

    public static <K, V> TimerTask checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, K k, int n, long l) throws IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (k == null) {
            throw new IllegalArgumentException(MSG_NULL_KEY);
        }
        if (n < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        KeyedObjectPoolMinIdleTimerTask<K, V> keyedObjectPoolMinIdleTimerTask = new KeyedObjectPoolMinIdleTimerTask<K, V>(keyedObjectPool, k, n);
        PoolUtils.getMinIdleTimer().schedule(keyedObjectPoolMinIdleTimerTask, 0L, l);
        return keyedObjectPoolMinIdleTimerTask;
    }

    public static <T> TimerTask checkMinIdle(ObjectPool<T> objectPool, int n, long l) throws IllegalArgumentException {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (n < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        ObjectPoolMinIdleTimerTask<T> objectPoolMinIdleTimerTask = new ObjectPoolMinIdleTimerTask<T>(objectPool, n);
        PoolUtils.getMinIdleTimer().schedule(objectPoolMinIdleTimerTask, 0L, l);
        return objectPoolMinIdleTimerTask;
    }

    public static void checkRethrow(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool) {
        return PoolUtils.erodingPool(keyedObjectPool, 1.0f);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
        return PoolUtils.erodingPool(keyedObjectPool, f, false);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f, boolean bl) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(MSG_FACTOR_NEGATIVE);
        }
        if (bl) {
            return new ErodingPerKeyKeyedObjectPool(keyedObjectPool, f);
        }
        return new ErodingKeyedObjectPool(keyedObjectPool, f);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool) {
        return PoolUtils.erodingPool(objectPool, 1.0f);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool, float f) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(MSG_FACTOR_NEGATIVE);
        }
        return new ErodingObjectPool(objectPool, f);
    }

    private static Timer getMinIdleTimer() {
        return TimerHolder.MIN_IDLE_TIMER;
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n) throws Exception, IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        keyedObjectPool.addObjects(collection, n);
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws Exception, IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        keyedObjectPool.addObjects(k, n);
    }

    @Deprecated
    public static <T> void prefill(ObjectPool<T> objectPool, int n) throws Exception {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        objectPool.addObjects(n);
    }

    public static <K, V> KeyedPooledObjectFactory<K, V> synchronizedKeyedPooledFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) {
        return new SynchronizedKeyedPooledObjectFactory<K, V>(keyedPooledObjectFactory);
    }

    public static <K, V> KeyedObjectPool<K, V> synchronizedPool(KeyedObjectPool<K, V> keyedObjectPool) {
        return new SynchronizedKeyedObjectPool<K, V>(keyedObjectPool);
    }

    public static <T> ObjectPool<T> synchronizedPool(ObjectPool<T> objectPool) {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        return new SynchronizedObjectPool<T>(objectPool);
    }

    public static <T> PooledObjectFactory<T> synchronizedPooledFactory(PooledObjectFactory<T> pooledObjectFactory) {
        return new SynchronizedPooledObjectFactory<T>(pooledObjectFactory);
    }

    private static final class KeyedObjectPoolMinIdleTimerTask<K, V>
    extends TimerTask {
        private final int minIdle;
        private final K key;
        private final KeyedObjectPool<K, V> keyedPool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
            this.key = k;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.keyedPool.getNumIdle(this.key) < this.minIdle) {
                    this.keyedPool.addObject(this.key);
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("KeyedObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", key=").append(this.key);
            stringBuilder.append(", keyedPool=").append(this.keyedPool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class ObjectPoolMinIdleTimerTask<T>
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool<T> pool;

        ObjectPoolMinIdleTimerTask(ObjectPool<T> objectPool, int n) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_POOL);
            }
            this.pool = objectPool;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", pool=").append(this.pool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class ErodingPerKeyKeyedObjectPool<K, V>
    extends ErodingKeyedObjectPool<K, V> {
        private final float factor;
        private final Map<K, ErodingFactor> factors = Collections.synchronizedMap(new HashMap());

        private ErodingPerKeyKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            super(keyedObjectPool, null);
            this.factor = f;
        }

        @Override
        protected ErodingFactor getErodingFactor(K k) {
            return this.factors.computeIfAbsent(k, object -> new ErodingFactor(this.factor));
        }

        @Override
        public String toString() {
            return "ErodingPerKeyKeyedObjectPool{factor=" + this.factor + ", keyedPool=" + this.getKeyedPool() + '}';
        }
    }

    private static class ErodingKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final KeyedObjectPool<K, V> keyedPool;
        private final ErodingFactor erodingFactor;

        private ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, ErodingFactor erodingFactor) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
            this.erodingFactor = erodingFactor;
        }

        private ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            this(keyedObjectPool, new ErodingFactor(f));
        }

        @Override
        public void addObject(K k) throws Exception {
            this.keyedPool.addObject(k);
        }

        @Override
        public V borrowObject(K k) throws Exception {
            return this.keyedPool.borrowObject(k);
        }

        @Override
        public void clear() throws Exception {
            this.keyedPool.clear();
        }

        @Override
        public void clear(K k) throws Exception {
            this.keyedPool.clear(k);
        }

        @Override
        public void close() {
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected ErodingFactor getErodingFactor(K k) {
            return this.erodingFactor;
        }

        protected KeyedObjectPool<K, V> getKeyedPool() {
            return this.keyedPool;
        }

        @Override
        public List<K> getKeys() {
            return this.keyedPool.getKeys();
        }

        @Override
        public int getNumActive() {
            return this.keyedPool.getNumActive();
        }

        @Override
        public int getNumActive(K k) {
            return this.keyedPool.getNumActive(k);
        }

        @Override
        public int getNumIdle() {
            return this.keyedPool.getNumIdle();
        }

        @Override
        public int getNumIdle(K k) {
            return this.keyedPool.getNumIdle(k);
        }

        @Override
        public void invalidateObject(K k, V v) {
            try {
                this.keyedPool.invalidateObject(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k, V v) throws Exception {
            boolean bl = false;
            long l = System.currentTimeMillis();
            ErodingFactor erodingFactor = this.getErodingFactor(k);
            KeyedObjectPool<K, V> keyedObjectPool = this.keyedPool;
            synchronized (keyedObjectPool) {
                if (erodingFactor.getNextShrink() < l) {
                    int n = this.getNumIdle(k);
                    if (n > 0) {
                        bl = true;
                    }
                    erodingFactor.update(l, n);
                }
            }
            try {
                if (bl) {
                    this.keyedPool.invalidateObject(k, v);
                } else {
                    this.keyedPool.returnObject(k, v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "ErodingKeyedObjectPool{factor=" + this.erodingFactor + ", keyedPool=" + this.keyedPool + '}';
        }
    }

    private static final class ErodingObjectPool<T>
    implements ObjectPool<T> {
        private final ObjectPool<T> pool;
        private final ErodingFactor factor;

        private ErodingObjectPool(ObjectPool<T> objectPool, float f) {
            this.pool = objectPool;
            this.factor = new ErodingFactor(f);
        }

        @Override
        public void addObject() throws Exception {
            this.pool.addObject();
        }

        @Override
        public T borrowObject() throws Exception {
            return this.pool.borrowObject();
        }

        @Override
        public void clear() throws Exception {
            this.pool.clear();
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int getNumActive() {
            return this.pool.getNumActive();
        }

        @Override
        public int getNumIdle() {
            return this.pool.getNumIdle();
        }

        @Override
        public void invalidateObject(T t) {
            try {
                this.pool.invalidateObject(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t) {
            boolean bl = false;
            long l = System.currentTimeMillis();
            ObjectPool<T> objectPool = this.pool;
            synchronized (objectPool) {
                if (this.factor.getNextShrink() < l) {
                    int n = this.pool.getNumIdle();
                    if (n > 0) {
                        bl = true;
                    }
                    this.factor.update(l, n);
                }
            }
            try {
                if (bl) {
                    this.pool.invalidateObject(t);
                } else {
                    this.pool.returnObject(t);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "ErodingObjectPool{factor=" + this.factor + ", pool=" + this.pool + '}';
        }
    }

    static class TimerHolder {
        static final Timer MIN_IDLE_TIMER = new Timer(true);

        TimerHolder() {
        }
    }

    private static final class SynchronizedKeyedPooledObjectFactory<K, V>
    implements KeyedPooledObjectFactory<K, V> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final KeyedPooledObjectFactory<K, V> keyedFactory;

        SynchronizedKeyedPooledObjectFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) throws IllegalArgumentException {
            if (keyedPooledObjectFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedPooledObjectFactory;
        }

        @Override
        public void activateObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.activateObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.destroyObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public PooledObject<V> makeObject(K k) throws Exception {
            this.writeLock.lock();
            try {
                PooledObject<V> pooledObject = this.keyedFactory.makeObject(k);
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.passivateObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedKeyedPooledObjectFactory");
            stringBuilder.append("{keyedFactory=").append(this.keyedFactory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(K k, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.keyedFactory.validateObject(k, pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    static final class SynchronizedKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final KeyedObjectPool<K, V> keyedPool;

        SynchronizedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
        }

        @Override
        public void addObject(K k) throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.addObject(k);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V borrowObject(K k) throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                V v = this.keyedPool.borrowObject(k);
                return v;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear() throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.clear();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear(K k) throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.clear(k);
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void close() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public List<K> getKeys() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                List<K> list = this.keyedPool.getKeys();
                return list;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public int getNumActive() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.keyedPool.getNumActive();
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive(K k) {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.keyedPool.getNumActive(k);
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public int getNumIdle() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.keyedPool.getNumIdle();
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle(K k) {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.keyedPool.getNumIdle(k);
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(K k, V v) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.invalidateObject(k, v);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k, V v) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.keyedPool.returnObject(k, v);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedKeyedObjectPool");
            stringBuilder.append("{keyedPool=").append(this.keyedPool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class SynchronizedObjectPool<T>
    implements ObjectPool<T> {
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final ObjectPool<T> pool;

        SynchronizedObjectPool(ObjectPool<T> objectPool) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_POOL);
            }
            this.pool = objectPool;
        }

        @Override
        public void addObject() throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.addObject();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public T borrowObject() throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                T t = this.pool.borrowObject();
                return t;
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void clear() throws Exception {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.clear();
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public void close() {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.close();
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        @Override
        public int getNumActive() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.pool.getNumActive();
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public int getNumIdle() {
            ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
            readLock.lock();
            try {
                int n = this.pool.getNumIdle();
                return n;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(T t) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.invalidateObject(t);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t) {
            ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
            writeLock.lock();
            try {
                this.pool.returnObject(t);
            }
            catch (Exception exception) {
            }
            finally {
                writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedObjectPool");
            stringBuilder.append("{pool=").append(this.pool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class SynchronizedPooledObjectFactory<T>
    implements PooledObjectFactory<T> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final PooledObjectFactory<T> factory;

        SynchronizedPooledObjectFactory(PooledObjectFactory<T> pooledObjectFactory) throws IllegalArgumentException {
            if (pooledObjectFactory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = pooledObjectFactory;
        }

        @Override
        public void activateObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.activateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.destroyObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public PooledObject<T> makeObject() throws Exception {
            this.writeLock.lock();
            try {
                PooledObject<T> pooledObject = this.factory.makeObject();
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.passivateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedPoolableObjectFactory");
            stringBuilder.append("{factory=").append(this.factory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public boolean validateObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.factory.validateObject(pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static final class ErodingFactor {
        private static final float MAX_INTERVAL = 15.0f;
        private final float factor;
        private volatile transient long nextShrinkMillis;
        private volatile transient int idleHighWaterMark = 1;
        private final ReentrantLock lock = new ReentrantLock();

        private ErodingFactor(float f) {
            this.factor = f;
            this.nextShrinkMillis = System.currentTimeMillis() + (long)(900000.0f * f);
        }

        private long getNextShrink() {
            return this.nextShrinkMillis;
        }

        public String toString() {
            return "ErodingFactor{factor=" + this.factor + ", idleHighWaterMark=" + this.idleHighWaterMark + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(long l, int n) {
            int n2 = Math.max(0, n);
            this.lock.lock();
            try {
                this.idleHighWaterMark = Math.max(n2, this.idleHighWaterMark);
                float f = 15.0f + -14.0f / (float)this.idleHighWaterMark * (float)n2;
                this.nextShrinkMillis = l + (long)(f * 60000.0f * this.factor);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

