/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.tcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.ClusterSession;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ReplicationValve
extends ValveBase
implements ClusterValve {
    private static final Log log = LogFactory.getLog(ReplicationValve.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.tcp");
    private CatalinaCluster cluster = null;
    protected Pattern filter = null;
    protected final ThreadLocal<ArrayList<DeltaSession>> crossContextSessions = new ThreadLocal();
    protected boolean doProcessingStats = false;
    protected LongAdder totalRequestTime = new LongAdder();
    protected LongAdder totalSendTime = new LongAdder();
    protected LongAdder nrOfRequests = new LongAdder();
    protected AtomicLong lastSendTime = new AtomicLong();
    protected LongAdder nrOfFilterRequests = new LongAdder();
    protected LongAdder nrOfSendRequests = new LongAdder();
    protected LongAdder nrOfCrossContextSendRequests = new LongAdder();
    protected boolean primaryIndicator = false;
    protected String primaryIndicatorName = "org.apache.catalina.ha.tcp.isPrimarySession";

    public ReplicationValve() {
        super(true);
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster catalinaCluster) {
        this.cluster = catalinaCluster;
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ReplicationValve.filter.loading", new Object[]{string}));
        }
        if (string == null || string.isEmpty()) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                log.error((Object)sm.getString("ReplicationValve.filter.failure", new Object[]{string}), (Throwable)patternSyntaxException);
            }
        }
    }

    public boolean isPrimaryIndicator() {
        return this.primaryIndicator;
    }

    public void setPrimaryIndicator(boolean bl) {
        this.primaryIndicator = bl;
    }

    public String getPrimaryIndicatorName() {
        return this.primaryIndicatorName;
    }

    public void setPrimaryIndicatorName(String string) {
        this.primaryIndicatorName = string;
    }

    public boolean doStatistics() {
        return this.doProcessingStats;
    }

    public void setStatistics(boolean bl) {
        this.doProcessingStats = bl;
    }

    public long getLastSendTime() {
        return this.lastSendTime.longValue();
    }

    public long getNrOfRequests() {
        return this.nrOfRequests.longValue();
    }

    public long getNrOfFilterRequests() {
        return this.nrOfFilterRequests.longValue();
    }

    public long getNrOfCrossContextSendRequests() {
        return this.nrOfCrossContextSendRequests.longValue();
    }

    public long getNrOfSendRequests() {
        return this.nrOfSendRequests.longValue();
    }

    public long getTotalRequestTime() {
        return this.totalRequestTime.longValue();
    }

    public long getTotalSendTime() {
        return this.totalSendTime.longValue();
    }

    public void registerReplicationSession(DeltaSession deltaSession) {
        List list = this.crossContextSessions.get();
        if (list != null && !list.contains(deltaSession)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("ReplicationValve.crossContext.registerSession", new Object[]{deltaSession.getIdInternal(), deltaSession.getManager().getContext().getName()}));
            }
            list.add(deltaSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Context context;
        long l = 0L;
        if (this.doStatistics()) {
            l = System.currentTimeMillis();
        }
        if (this.primaryIndicator) {
            this.createPrimaryIndicator(request);
        }
        boolean bl = (context = request.getContext()) instanceof StandardContext && context.getCrossContext();
        boolean bl2 = request.getAsyncContextInternal() != null;
        try {
            if (bl) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("ReplicationValve.crossContext.add"));
                }
                this.crossContextSessions.set(new ArrayList());
            }
            this.getNext().invoke(request, response);
            if (context != null && this.cluster != null && context.getManager() instanceof ClusterManager) {
                ClusterManager clusterManager = (ClusterManager)context.getManager();
                if (this.cluster.getManager(clusterManager.getName()) == null) {
                    return;
                }
                if (this.cluster.hasMembers()) {
                    this.sendReplicationMessage(request, l, bl, bl2, clusterManager);
                } else {
                    this.resetReplicationRequest(request, bl);
                }
            }
        }
        finally {
            if (bl) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("ReplicationValve.crossContext.remove"));
                }
                this.crossContextSessions.remove();
            }
        }
    }

    public void resetStatistics() {
        this.totalRequestTime.reset();
        this.totalSendTime.reset();
        this.lastSendTime.set(0L);
        this.nrOfFilterRequests.reset();
        this.nrOfRequests.reset();
        this.nrOfSendRequests.reset();
        this.nrOfCrossContextSendRequests.reset();
    }

    protected void startInternal() throws LifecycleException {
        if (this.cluster == null) {
            Cluster cluster = this.getContainer().getCluster();
            if (cluster instanceof CatalinaCluster) {
                this.setCluster((CatalinaCluster)cluster);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("ReplicationValve.nocluster"));
            }
        }
        super.startInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReplicationMessage(Request request, long l, boolean bl, boolean bl2, ClusterManager clusterManager) {
        long l2 = 0L;
        if (this.doStatistics()) {
            l2 = System.currentTimeMillis();
        }
        try {
            this.sendInvalidSessions(clusterManager);
            this.sendSessionReplicationMessage(request, clusterManager);
            if (bl) {
                this.sendCrossContextSession();
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("ReplicationValve.send.failure"), (Throwable)exception);
        }
        finally {
            if (this.doStatistics()) {
                this.updateStats(l, l2, bl2);
            }
        }
    }

    protected void sendCrossContextSession() {
        List list = this.crossContextSessions.get();
        if (list != null && !list.isEmpty()) {
            for (DeltaSession deltaSession : list) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("ReplicationValve.crossContext.sendDelta", new Object[]{deltaSession.getManager().getContext().getName()}));
                }
                this.sendMessage(deltaSession, (ClusterManager)deltaSession.getManager());
                if (!this.doStatistics()) continue;
                this.nrOfCrossContextSendRequests.increment();
            }
        }
    }

    protected void resetReplicationRequest(Request request, boolean bl) {
        List list;
        Session session = request.getSessionInternal(false);
        if (session instanceof DeltaSession) {
            this.resetDeltaRequest(session);
            ((DeltaSession)session).setPrimarySession(true);
        }
        if (bl && (list = (List)this.crossContextSessions.get()) != null) {
            for (DeltaSession deltaSession : list) {
                this.resetDeltaRequest(deltaSession);
                deltaSession.setPrimarySession(true);
            }
        }
    }

    protected void resetDeltaRequest(Session session) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ReplicationValve.resetDeltaRequest", new Object[]{session.getManager().getContext().getName()}));
        }
        ((DeltaSession)session).resetDeltaRequest();
    }

    protected void sendSessionReplicationMessage(Request request, ClusterManager clusterManager) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            String string = request.getDecodedRequestURI();
            if (!this.isRequestWithoutSessionChange(string)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.invoke.uri", new Object[]{string}));
                }
                this.sendMessage(session, clusterManager);
            } else if (this.doStatistics()) {
                this.nrOfFilterRequests.increment();
            }
        }
    }

    protected void sendMessage(Session session, ClusterManager clusterManager) {
        String string = session.getIdInternal();
        if (string != null) {
            this.send(clusterManager, string);
        }
    }

    protected void send(ClusterManager clusterManager, String string) {
        ClusterMessage clusterMessage = clusterManager.requestCompleted(string);
        if (clusterMessage != null && this.cluster != null) {
            this.cluster.send(clusterMessage);
            if (this.doStatistics()) {
                this.nrOfSendRequests.increment();
            }
        }
    }

    protected void sendInvalidSessions(ClusterManager clusterManager) {
        String[] stringArray;
        for (String string : stringArray = clusterManager.getInvalidatedSessions()) {
            try {
                this.send(clusterManager, string);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("ReplicationValve.send.invalid.failure", new Object[]{string}), (Throwable)exception);
            }
        }
    }

    protected boolean isRequestWithoutSessionChange(String string) {
        Pattern pattern = this.filter;
        return pattern != null && pattern.matcher(string).matches();
    }

    protected void updateStats(long l, long l2, boolean bl) {
        long l3 = System.currentTimeMillis();
        this.lastSendTime.set(l3);
        this.totalSendTime.add(l3 - l2);
        this.totalRequestTime.add(l3 - l);
        if (!bl) {
            this.nrOfRequests.increment();
            if (log.isDebugEnabled() && this.nrOfRequests.longValue() % 100L == 0L) {
                log.debug((Object)sm.getString("ReplicationValve.stats", new Object[]{this.totalRequestTime.longValue() / this.nrOfRequests.longValue(), this.totalSendTime.longValue() / this.nrOfRequests.longValue(), this.nrOfRequests.longValue(), this.nrOfSendRequests.longValue(), this.nrOfCrossContextSendRequests.longValue(), this.nrOfFilterRequests.longValue(), this.totalRequestTime.longValue(), this.totalSendTime.longValue()}));
            }
        }
    }

    protected void createPrimaryIndicator(Request request) throws IOException {
        String string = request.getRequestedSessionId();
        if (string != null && !string.isEmpty()) {
            Manager manager = request.getContext().getManager();
            Session session = manager.findSession(string);
            if (session instanceof ClusterSession) {
                ClusterSession clusterSession = (ClusterSession)session;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.session.indicator", new Object[]{request.getContext().getName(), string, this.primaryIndicatorName, clusterSession.isPrimarySession()}));
                }
                request.setAttribute(this.primaryIndicatorName, (Object)(clusterSession.isPrimarySession() ? Boolean.TRUE : Boolean.FALSE));
            } else if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug((Object)sm.getString("ReplicationValve.session.found", new Object[]{request.getContext().getName(), string}));
                } else {
                    log.debug((Object)sm.getString("ReplicationValve.session.invalid", new Object[]{request.getContext().getName(), string}));
                }
            }
        }
    }
}

