/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.RFC2231Utility;
import org.apache.tomcat.util.http.fileupload.util.mime.MimeUtility;

public class ParameterParser {
    private char[] chars;
    private int pos;
    private int len;
    private int i1;
    private int i2;
    private boolean lowerCaseNames;

    private String getToken(boolean bl) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (bl && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        String string = null;
        if (this.i2 > this.i1) {
            string = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return string;
    }

    private boolean hasChar() {
        return this.pos < this.len;
    }

    public boolean isLowerCaseNames() {
        return this.lowerCaseNames;
    }

    private boolean isOneOf(char c, char[] cArray) {
        boolean bl = false;
        for (char c2 : cArray) {
            if (c != c2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Map<String, String> parse(char[] cArray, char c) {
        if (cArray == null) {
            return new HashMap<String, String>();
        }
        return this.parse(cArray, 0, cArray.length, c);
    }

    public Map<String, String> parse(char[] cArray, int n, int n2, char c) {
        if (cArray == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.chars = (char[])cArray.clone();
        this.pos = n;
        this.len = n2;
        while (this.hasChar()) {
            String string = this.parseToken(new char[]{'=', c});
            String string2 = null;
            if (this.hasChar() && cArray[this.pos] == '=') {
                ++this.pos;
                string2 = this.parseQuotedToken(new char[]{c});
                if (string2 != null) {
                    try {
                        string2 = RFC2231Utility.hasEncodedValue(string) ? RFC2231Utility.decodeText(string2) : MimeUtility.decodeText(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (this.hasChar() && cArray[this.pos] == c) {
                ++this.pos;
            }
            if (string == null || string.isEmpty()) continue;
            string = RFC2231Utility.stripDelimiter(string);
            if (this.lowerCaseNames) {
                string = string.toLowerCase(Locale.ROOT);
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Map<String, String> parse(String string, char c) {
        if (string == null) {
            return new HashMap<String, String>();
        }
        return this.parse(string.toCharArray(), c);
    }

    public Map<String, String> parse(String string, char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return new HashMap<String, String>();
        }
        char c = cArray[0];
        if (string != null) {
            int n = string.length();
            for (char c2 : cArray) {
                int n2 = string.indexOf(c2);
                if (n2 == -1 || n2 >= n) continue;
                n = n2;
                c = c2;
            }
        }
        return this.parse(string, c);
    }

    private String parseQuotedToken(char[] cArray) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean bl = false;
        boolean bl2 = false;
        while (this.hasChar()) {
            char c = this.chars[this.pos];
            if (!bl && this.isOneOf(c, cArray)) break;
            if (!bl2 && c == '\"') {
                bl = !bl;
            }
            bl2 = !bl2 && c == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    private String parseToken(char[] cArray) {
        char c;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(c = this.chars[this.pos], cArray)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    public void setLowerCaseNames(boolean bl) {
        this.lowerCaseNames = bl;
    }
}

