%%
%% This is file `mynsfc.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% mynsfc.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2015-2026 by Fei Qi <fred.qi@gmail.com>
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either
%% version 1.3c of this license or (at your option) any later
%% version. The latest version of this license is in:
%% 
%%    http://www.latex-project.org/lppl.txt
%% 
%% and version 1.3c or later is part of all distributions of
%% LaTeX version 2008/05/04 or later.
%% 
%% This work consists of the file mynsfc.dtx and the derived files
%% mynsfc.cls, mynsfc.def, and the example files.
%% 
%% ----------------------------------------------------------------
%% mynsfc --- A CTeX-based template for writing the main text of NSFC
%%     proposals, aligned with the 2026 General Program specification.
%% Author: Fei Qi <fred.qi@gmail.com>
%% ----------------------------------------------------------------
%% 
\NeedsTeXFormat{LaTeX2e}[1999/12/01]
\ProvidesClass{mynsfc}[2026/01/25 2.00 A CTeX-based class for writing NSFC proposals.]
\ExecuteOptions{}
\ProcessOptions*
\RequirePackage{kvoptions}
\RequirePackage{etoolbox}
\DeclareStringOption[0070c0]{toccolor}
\DeclareStringOption[none]{fontset}
\ProcessKeyvalOptions*
%% Load customizable strings
\input{mynsfc.def}
\ifdefstring{\mynsfc@fontset}{none}{%
  \LoadClass[a4paper,UTF8,fontset=none,zihao=-4]{ctexart}
  %% Setup Windows Chinese fonts
  \setCJKmainfont{SimSun}[AutoFakeBold=2.5]
  \setCJKsansfont{SimHei}[AutoFakeBold=2.5]
  % \setCJKmonofont{FangSong}
  \setCJKfamilyfont{zhsong}{SimSun}[AutoFakeBold=2.5]
  \setCJKfamilyfont{zhkai}{KaiTi}[AutoFakeBold=2.5]
  \setCJKfamilyfont{zhhei}{SimHei}[AutoFakeBold=2.5]
  % \setCJKfamilyfont{zhfs}{FangSong}
  %% Map CTeX font commands to families
  \newcommand*{\songti}{\CJKfamily{zhsong}}
  \newcommand*{\heiti}{\CJKfamily{zhhei}}
  \newcommand*{\fangsong}{\CJKfamily{zhfs}}
  \newcommand*{\kaishu}{\CJKfamily{zhkai}}
}{%
  \LoadClass[a4paper,UTF8,fontset=fandol,zihao=-4]{ctexart}
}
\RequirePackage[hmargin=1.18in,vmargin=0.98in]{geometry}
\setlength{\parskip}{0pt \@plus2pt \@minus0pt}
%% Load required packages
\RequirePackage{amsmath,amssymb}
\RequirePackage{graphicx}
\RequirePackage{caption,subcaption}
\RequirePackage{xcolor}
\RequirePackage{hyperref}
\hypersetup{%
  breaklinks=true,
  colorlinks=true,
  allcolors=black,
  pdfpagelabels}
\urlstyle{same}
%% Load and setup package biblatex
\RequirePackage[backend=biber,
                doi=false,
                url=false,
                isbn=false,
                defernumbers=true,
                style=ieee]{biblatex}

\setlength{\bibitemsep}{2pt}
\appto{\bibfont}{\normalfont\zihao{5}\linespread{1}\selectfont}
\defbibheading{reftype}[\mynsfcrefname]{\section*{#1}}
\defbibheading{cvtype}[\mynsfccvname]{\subsection*{#1}}
\defbibfilter{conference}{type=inproceedings or type=incollection}
\NewBibliographyString{patentcn}

\DefineBibliographyStrings{english}{%
  and      = {\&},
  patentcn = {\mynsfcpatentcn\adddot},
}
\def\ps@mynsfc@empty{%
  \let\@oddhead\@empty%
  \let\@evenhead\@empty%
  \let\@oddfoot\@empty%
  \let\@evenfoot\@empty}
\renewcommand*{\mkbibnamegiven}[1]{%
  \ifitemannotation{self}{\textbf{#1}}{#1}}
\renewcommand*{\mkbibnamefamily}[1]{%
  \ifitemannotation{self}{\textbf{#1}}{#1}%
  \ifpartannotation{family}{corr}{\textsuperscript{*}}{}}
\newcommand{\tocformat}{%
  \CJKfamily{zhkai}%
  \color[HTML]{\mynsfc@toccolor}}
\renewcommand{\maketitle}{%
  \begin{center}%
    \kaishu\zihao{3}\bfseries\mynsfc@title%
  \end{center}%
  \vspace{1ex}%
  {\kaishu\zihao{4}\noindent\hspace{2\ccwd}\mynsfc@subtitle}\par%
  \vspace{2ex}}
\ctexset{
  part/name         = {（,）},
  part/aftername    = {},
  part/number       = \chinese{part},
  part/format       = \tocformat\bfseries\zihao{-3},
  part/beforeskip   = 1ex,
  part/afterskip    = 0.5ex,
  part/indent       = 2\ccwd,
}
\let\oldpart\part
\renewcommand{\part}[2]{%
  \oldpart{#1：}%
  \begingroup
    \protected@edef\mynsfc@tempa{#2}%
    \ifx\mynsfc@tempa\@empty
      \endgroup
    \else
      \endgroup
      {\tocformat\zihao{-3}\noindent\hspace{2\ccwd}（#2）}\par%
    \fi}
\newcommand{\nsfcpart}{%
  \edef\mynsfc@nextpart{\number\numexpr\value{part}+1\relax}%
  \edef\mynsfc@romannum{\@Roman\mynsfc@nextpart}%
  \part{\csname mynsfc@part@\mynsfc@romannum @title\endcsname}%
       {\csname mynsfc@part@\mynsfc@romannum @subtitle\endcsname}%
}
\newcommand{\mynsfc@secformat}{%
  \tocformat\ifnum\value{part}<4\relax\bfseries\fi\zihao{4}}
\ctexset{
  section/format       = \mynsfc@secformat,
  section/number       = \arabic{section},
  section/aftername    = {.\hspace{1ex}},
  section/beforeskip   = 1ex,
  section/afterskip    = 0.5ex,
  section/indent       = 2\ccwd,
  section/hang         = false,
}
\@addtoreset{section}{part}
\newcommand{\nsfcsection}{%
  \edef\mynsfc@partroman{\@Roman\c@part}%
  \edef\mynsfc@nextsec{\number\numexpr\value{section}+1\relax}%
  \edef\mynsfc@secroman{\@Roman\mynsfc@nextsec}%
  \section{\csname mynsfc@section@\mynsfc@partroman %
                  @\mynsfc@secroman @title\endcsname}%
}
\ctexset{
  subsection/format       = \tocformat\bfseries\zihao{-4},
  subsection/number       = \thesubsection,
  subsection/aftername    = {.\hspace{0.25em}},
  subsection/beforeskip   = 2ex,
  subsection/afterskip    = 1ex,
  subsection/indent       = 0pt,
}
\ctexset{
  subsubsection/name         = {(,)},
  subsubsection/aftername    = {\hskip1ex},
  subsubsection/number       = \arabic{subsubsection},
  subsubsection/format       = \kaishu\bfseries\zihao{-4},
  subsubsection/beforeskip   = 2ex,
  subsubsection/afterskip    = 1ex,
  subsubsection/indent       = 0pt,
}
\captionsetup{font=small}
\newcommand{\cemph}[1]{\textbf{\color[HTML]{\mynsfc@toccolor}#1}}
\AtBeginDocument{\ps@mynsfc@empty}
%% 
%%
%% End of file `mynsfc.cls'.
