/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;
import org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.apache.pdfbox.pdmodel.graphics.shading.PatchMeshesShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.TensorPatch;
import org.apache.pdfbox.util.Matrix;

class Type7ShadingContext
extends PatchMeshesShadingContext {
    public Type7ShadingContext(PDShadingType7 shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, pageHeight, dBounds);
        xform.scale(1.0, -1.0);
        xform.translate(0.0, -pageHeight);
        this.patchList = this.getTensorPatchList(xform, ctm);
        this.pixelTable = this.calcPixelTable();
    }

    private ArrayList<Patch> getTensorPatchList(AffineTransform xform, Matrix ctm) throws IOException {
        PDShadingType7 tensorShadingType = (PDShadingType7)this.patchMeshesShadingType;
        COSDictionary cosDictionary = tensorShadingType.getCOSDictionary();
        PDRange rangeX = tensorShadingType.getDecodeForParameter(0);
        PDRange rangeY = tensorShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = tensorShadingType.getDecodeForParameter(2 + i);
        }
        return this.getPatchList(xform, ctm, cosDictionary, rangeX, rangeY, colRange, 16);
    }

    @Override
    protected Patch generatePatch(Point2D[] points, float[][] color) {
        return new TensorPatch(points, color);
    }
}

