/* Generated By:JavaCC: Do not edit this line. Latex.java */
package com.latex2nemeth.parser;
import java.io.*;
import java.util.regex.*;
import java.util.Vector;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

import com.latex2nemeth.ast.*;
import com.latex2nemeth.utils.*;
import com.latex2nemeth.symbols.*;
import com.latex2nemeth.parser.aux.*;
import com.latex2nemeth.io.*;

public class Latex implements LatexConstants {


        class Command {
                String name;
                int numOfParams;
                String body;
                String[] params;
                Command(String name,String body){
                        this.name = name;
                        this.body = body;
                }
                Command(String name, int numOfParams, String body){
                        this(name,body);
                        this.numOfParams=numOfParams;
                        if (numOfParams > 0)
                                params = new String[numOfParams];
                }
        }

        class MathCommand {
                String name;
                int numOfParams;
                String body;
                Expression[] params;
                MathCommand(String name, String body){
                        this.name = name;
                        this.body = body;
                }
                MathCommand(String name, int numOfParams, String body){
                        this(name,body);
                        this.numOfParams=numOfParams;
                        if (numOfParams > 0)
                                params = new Expression[numOfParams];
                }
        }

        Command currentMacro;
        MathCommand currentMathMacro;

        static final int MAX_WIDTH = 28;
        static int COLUMN = 0;
        static StringBuffer WORD = new StringBuffer();
        NemethTable table;
        HashMap<String, Command > commandTable = new HashMap<String, Command >();
        HashMap<String, MathCommand > commandMathTable = new HashMap<String, MathCommand >();
        static HashMap<String, Theorem> theorems = new HashMap<String,Theorem >();
        static HashMap<String, String> operatorsTable = new HashMap<String, String>();


    static Writer output;
        static String outputFileName;
        int enumeratedepth = 0;
        private static LabelTable labeltable;
        int lineNumber=0;
        static ParsedChapters parsedChapters;

        static int chapter = 0;
        static int section = 0;
        static int subsection = 0;
        private int picture = 0;
        private boolean inFigure = false;
        private Preamble preamble;

        private int tabularcolumn = 0;
        private boolean verbose;



        private void printMessage(String msg) {
          if (verbose) {
            System.out.println(msg);
          }
        }


    private String getLetterCode(String symbol) {
        String code = table.getLetterCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN TEXT SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    private String getTheoremCode(String symbol) {
        String code = table.getTheoremCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN THEOREM SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    private String getMathCode(String symbol) {
        String code = table.getMathCode(symbol);
        if (code == null) {
            printMessage("UNKNOWN MATH SYMBOL: " + symbol + " at line: " + jj_input_stream.getEndLine());
            return "";
        }
        return code;
    }

    String string2Braille(String str) {
        StringBuffer buffer = new StringBuffer();

        for (int pos = 0; pos < str.length(); pos++) {
            String c = Character.toString(str.charAt(pos));
            buffer.append(getLetterCode(c));
        }

        return buffer.toString();
    }

    String string2BrailleTheorem(String str) {
        StringBuffer buffer = new StringBuffer();

        for (int pos = 0; pos < str.length(); pos++) {
            String c = Character.toString(str.charAt(pos));
            buffer.append(getTheoremCode(c));
        }

        return buffer.toString();
    }

    static String italic(String s) {
        return "\u2820\u2804\u2838" + s + "\u2838\u2820\u2804";
    }

    String bold(String s) {
        return getLetterCode("\u005c\u005ctextbf-open") + s + getLetterCode("\u005c\u005ctextbf-close");
    }

    static String sansserif(String s) {
        return s;
    }

    static String scriptenglish(String s) {
        return s;
    }

    static boolean checkforPreviousSpace(Token t) {
        boolean space = t.specialToken != null;
        return space;
    }

//    boolean isOperator(Expression exp){
//        if (exp instanceof SimpleExpression){
//            return operatorsTable.
//                containsKey(((SimpleExpression) exp).getTokenString());
//        }
//        return false;
//    }

    void initOperatorsTable(){
        operatorsTable.put("\u005c\u005csum","\u005c\u005csum@");
        operatorsTable.put("\u005c\u005cprod","\u005c\u005cprod@");
        operatorsTable.put("\u005c\u005cprojlim","\u005c\u005ctextrm{projlim}");
        operatorsTable.put("\u005c\u005cinjlim","\u005c\u005ctextrm{injlim}");
        operatorsTable.put("\u005c\u005cvarinjlim","\u005c\u005cvarinjlim@");
        operatorsTable.put("\u005c\u005cvarprojlim","\u005c\u005cvarprojlim@");
        operatorsTable.put("\u005c\u005cbigotimes","\u005c\u005cbigotimes@");
        operatorsTable.put("\u005c\u005cbigoplus","\u005c\u005cbigoplus@");
        operatorsTable.put("\u005c\u005ccoprod","\u005c\u005ccoprod@");
        operatorsTable.put("\u005c\u005cbigcup","\u005c\u005cbigcup@");
        operatorsTable.put("\u005c\u005cbigcap","\u005c\u005cbigcap@");
        operatorsTable.put("\u005c\u005cbigsqcap","\u005c\u005cbigsqcap@");
                operatorsTable.put("\u005c\u005cbigvee","\u005c\u005cbigvee@");
        operatorsTable.put("\u005c\u005cbigwedge","\u005c\u005cbigwedge@");
        operatorsTable.put("\u005c\u005cbigodot","\u005c\u005cbigodot@");
        operatorsTable.put("\u005c\u005cbiguplus","\u005c\u005cbiguplus@");

        //... Add more commands. All operators 
    }

    MathExpression createOverExp(Expression base, Expression over) {

        MathExpression newexp = new MathExpression(table);
        // We should put the beginning of symbol (Braille-5 symbol here...). Ask Antonis.
        newexp.addChild(base);
                newexp.addChild(new SimpleExpression("\u005c\u005coverset", table));
                newexp.addChild(over);
        newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));

        return newexp;
    }

     MathExpression createUnderExp(Expression base, Expression under){

        MathExpression newexp = new MathExpression(table);
                newexp.addChild(base);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderset", table));
                newexp.addChild(under);
        newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));

        return newexp;
     }

    MathExpression createOverUnderExp(Expression base,
        Expression under, Expression over){

        MathExpression newexp = new MathExpression(table);
        newexp.addChild(base);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderset", table));
                newexp.addChild(under);
        newexp.addChild(new SimpleExpression("\u005c\u005coverset", table));
                newexp.addChild(over);
        newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));

        return newexp;
     }


    public Latex(NemethTable table, InputStreamReader inputStreamReader, Preamble preamble, boolean verbose) {
        this(inputStreamReader);
        this.table = table;
        this.preamble = preamble;
        this.verbose = verbose;
        initOperatorsTable(); //Duplicating. Fix
    }

    public Latex(NemethTable table, InputStreamReader inputStreamReader,
        Command cmd, HashMap<String, Command> commandTable, boolean verbose)
    {
        this(inputStreamReader);
        this.table = table;
        this.currentMacro = cmd;
        this.commandTable = commandTable;
        this.verbose = verbose;
        initOperatorsTable(); //Duplicating. Fix
   }


  public Latex(NemethTable table, InputStreamReader inputStreamReader, MathCommand cmd, HashMap<String, MathCommand> mathCommandTable, boolean verbose)
    {
        this(inputStreamReader);
        this.table = table;
        this.currentMathMacro = cmd;
        this.commandMathTable = mathCommandTable;
        this.verbose = verbose;
        initOperatorsTable(); //Duplicating. Fix
   }


    public static ParsedChapters parse(String texFile, String auxFile, NemethTable table, Preamble preamble, boolean verbose) throws ParseException, TokenMgrError, IOException {

        parsedChapters = new ParsedChapters();

        FileInputStream fileInputStream = new FileInputStream(texFile);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, "UTF-8");
        System.out.println("Parsing file: " + texFile);

        labeltable = new LabelTable();
        labeltable.createlabels(auxFile);

        output = new StringWriter();

        WORD = new StringBuffer();
        Latex parser = new Latex(table, inputStreamReader, preamble, verbose);

        parser.latex();

        inputStreamReader.close();
        fileInputStream.close();

        output.flush(); //??
        output.close();
        parsedChapters.put(chapter, output.toString());
        return parsedChapters;
    }

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////// SYNTACTICAL //////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
  final public Token mathDelimiter() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case MATHSEPARATOR:
      t = jj_consume_token(MATHSEPARATOR);
      break;
    case LBRA:
      t = jj_consume_token(LBRA);
      break;
    case RBRA:
      t = jj_consume_token(RBRA);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                                                {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// It sucks but it works...
  final public Token mathDelimiter_no_brackets() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case MATHSEPARATOR:
      t = jj_consume_token(MATHSEPARATOR);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token myDigit() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
      t = jj_consume_token(DIGIT0);
      break;
    case DIGIT1:
      t = jj_consume_token(DIGIT1);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token latincharacter() throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
      t = jj_consume_token(MATHTEXTSEPARATOR);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public String brackets() throws ParseException {
    Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      t = jj_consume_token(LBRA);
      break;
    case RBRA:
      t = jj_consume_token(RBRA);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                {if (true) return getLetterCode(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public String character() throws ParseException {
        Token t = null;
        String s;
        boolean space;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
      t = jj_consume_token(ANY);
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case MATHTEXTSEPARATOR:
      t = latincharacter();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        String key = t.image;
        String code = getLetterCode(key);
        space = checkforPreviousSpace(t);
        // System.out.print(key);
        if (t.kind == DIGIT0) {
            code = getMathCode("NUMBER-SYMBOL") + code;
        }
        if (space) {
            {if (true) return " " + code;}
        }
        {if (true) return code;}
    throw new Error("Missing return statement in function");
  }

  final public String character_no_braille() throws ParseException {
        Token t = null;
        String s;
        boolean space;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case MATHTEXTSEPARATOR:
      t = latincharacter();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case SUB:
      t = jj_consume_token(SUB);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        String key = t.image;
        space = checkforPreviousSpace(t);
        // System.out.print(key);
            if (space) {
                {if (true) return " " + key;}
        }
            {if (true) return key;}
    throw new Error("Missing return statement in function");
  }

  final public String bracketcontent() throws ParseException {
    Token t;
    String s = "", result;
    boolean space = false;
    t = jj_consume_token(LCB);
                space = checkforPreviousSpace(t);
    /*[LOOKAHEAD(1) <COMMAND>]*/
        // s = basic()
            s = content();
    jj_consume_token(RCB);
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String textlatin() throws ParseException {
        Token t;
        String s = "", result;
        boolean space = false;
    t = jj_consume_token(TEXTLATIN);
                          space = checkforPreviousSpace(t);
    s = command_parameter();
            String en = getLetterCode("EN");
            s = s.replaceAll("^", en);
            s = s.replaceAll(" ", " " + en);
        // insert an english text symbol in the beginning and after every space...
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String param() throws ParseException {
        Token t;
        int nParam;
    t = jj_consume_token(PARAM);
                nParam = Integer.parseInt(t.image.substring(1));
                String parameter = this.currentMacro.params[nParam-1];
                {if (true) return parameter;}
    throw new Error("Missing return statement in function");
  }

// This sucks! Every command actually MUST know its number of parameters.
  final public String textcommand() throws ParseException {
        Token t;
        String s = "", result;
        boolean space = false;
        Command cmd;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMAND:
      t = jj_consume_token(COMMAND);
                            space = checkforPreviousSpace(t);
                        cmd = commandTable.get(t.image); // TODO: Is this right;	
                        if (cmd != null) {
                                InputStream targetStream=null;
                                try{
                                        targetStream = new ByteArrayInputStream(cmd.body.getBytes("ISO-8859-7"));
                                }catch(Exception e){e.printStackTrace();}


                                for (int i=0; i< cmd.numOfParams;i++){
                                        cmd.params[i] = command_parameter();// This is the real	
                                }
                                Latex lparser = new Latex(table, new InputStreamReader(targetStream), cmd, commandTable, verbose);

                                s = lparser.content();

                //		String body = cmd.body;

                        }
                else {// Not a defined command. Check if it is just in the list of symbols. 
                                s = getLetterCode(t.image);
                        }
      break;
    case TEXTLATIN:
      s = textlatin();
      break;
    case INDEX:
      s = index();
      break;
    case LABEL:
      s = label();
      break;
    case REF:
      s = ref();
      break;
    case ACCENT:
      s = accent();
      break;
    case GRAVEACCENT:
      s = grave();
      break;
    case CHAPTER:
      s = chapter();
      break;
    case SECTION:
      s = section();
      break;
    case SUBSECTION:
      s = subsection();
      break;
    case TEXTBF:
      s = textbf();
      break;
    case TEXTIT:
    case EMPH:
      s = textit();
      break;
    case LTNALLCAPS:
      s = latextonemethallcaps();
      break;
    case VERB:
      s = verb();
      break;
    case INPUT:
    case INCLUDE:
      input();
      break;
    case NEWCOMMAND:
      newcommand();
      break;
    case TEXTCIRCLED:
      textcircled();
      break;
    case PARAM:
      s = param();
      break;
    case DECLAREMATHOPERATOR:
    case DECLAREMATHOPERATORSTAR:
      declaremathoperator();
      break;
    case HUGE:
    case TEXTSC:
      ignore();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            result = " " + s;
        } else {
            result = s;
        }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void newcommand() throws ParseException {
    String newcommand, definition;
    Token commandToken;
        Token nParamToken=null;
        StringBuffer def = new StringBuffer();
        char c;
        int n=1;
        int nParams=0;
        Command cmd;
        MathCommand mcmd;
        String strNum;
    jj_consume_token(NEWCOMMAND);
    jj_consume_token(LCB);
    commandToken = jj_consume_token(COMMAND);
    jj_consume_token(RCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      nParamToken = myDigit();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    jj_consume_token(LCB);
                                                                                                                   // SOS: (Optional) parameters
                char pc = ' ';
                while(true){
                        try {
                c = jj_input_stream.readChar();
            } catch(java.io.IOException ioe) {
                System.out.println("End of file while reading command definition..");
                {if (true) return;}
            }
                        if (n == 1 && c == '}') break;
                        else if (c=='}' && pc != '\u005c\u005c') n--;
                        else if (c=='{' && pc != '\u005c\u005c') n++;
                        def.append(c);
                        pc = c;
                }

                if (!commandToken.toString().equals("\u005c\u005clatextonemethnewline")) {
                        if (nParamToken!=null){
                                strNum = nParamToken.image;
                                nParams= Integer.parseInt(strNum);
                        }
                        definition=def.toString();
                        if (nParams==0){
                                cmd = new Command(commandToken.image,definition);
                                mcmd = new MathCommand(commandToken.image,definition);
                        }
                        else {
                                cmd = new Command(commandToken.image, nParams, definition);
                        mcmd = new MathCommand(commandToken.image,nParams,definition);
                        }
                        commandTable.put(commandToken.image, cmd);
                        commandMathTable.put(commandToken.image, mcmd); //SOS: This is wrong... We put the commands in both tables
                }
  }

  final public void newtheorem() throws ParseException {
        StringBuffer name = new StringBuffer(),
                    label = new StringBuffer(),
                    opts = new StringBuffer(),
                    counterLabel = new StringBuffer();
        Token t;
        Theorem theorem = null, counterTheorem = null;
    jj_consume_token(NEWTHEOREM);
    jj_consume_token(LCB);
    label_1:
    while (true) {
      t = latincharacter();
                                                name.append(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(RCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCB:
      jj_consume_token(LCB);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case GREEKLETTER:
        case DIPHTHONG:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case GREEKLETTER:
          t = jj_consume_token(GREEKLETTER);
          break;
        case DIPHTHONG:
          t = jj_consume_token(DIPHTHONG);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                     label.append(t.image);
      }
      jj_consume_token(RCB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ENGLISHLETTER:
            jj_consume_token(ENGLISHLETTER);
            break;
          case DIGIT0:
          case DIGIT1:
            myDigit();
            break;
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
            ;
            break;
          default:
            jj_la1[13] = jj_gen;
            break label_3;
          }
        }
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
                theorem = new Theorem(name.toString(), label.toString());
      break;
    case LBRA:
      jj_consume_token(LBRA);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                        counterLabel.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_4;
        }
      }
      jj_consume_token(RBRA);
      jj_consume_token(LCB);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          t = jj_consume_token(ENGLISHLETTER);
          break;
        case GREEKLETTER:
          t = jj_consume_token(GREEKLETTER);
          break;
        case DIPHTHONG:
          t = jj_consume_token(DIPHTHONG);
          break;
        case DIGIT0:
        case DIGIT1:
          t = myDigit();
          break;
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                      label.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case GREEKLETTER:
        case DIPHTHONG:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_5;
        }
      }
      jj_consume_token(RCB);
              counterTheorem = theorems.get(counterLabel.toString());
              theorem = new Theorem(name.toString(), label.toString(), counterTheorem);
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.println("Registering theorem '" + name.toString() +"' " + label.toString());
                theorems.put(name.toString(),theorem);
  }

  final public String theoremenvironment(String theoremName) throws ParseException {
        String content = "";
        Token nameToken;
        Theorem theorem = null;
        String option = "", label = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
                theorem = theorems.get(theoremName);
            if (theorem == null) {
                System.out.println("Error in line " + jj_input_stream.getEndLine());
                System.out.println("Environment '" + theoremName + "' " + " not defined");
                // throw new ParseException();
            }
    content = content();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
            String lpar = getLetterCode("(");
            String rpar = getLetterCode(")");
                String optionallabel = "";
                if (!option.equals("")) {
                        optionallabel = lpar  + option + rpar;
            }
        String theoremlabel = "";
        if (theorem != null) {
            theoremlabel = string2Braille(theorem.getLabel());

            if (label.equals("")) {
                StringBuffer theoremNumber = new StringBuffer();
                theoremNumber.append(getLetterCode("NUMBER-SYMBOL"));

                if (chapter !=0) {
                    theoremNumber.append(string2Braille(Integer.toString(chapter)));
                    theoremNumber.append(getTheoremCode("."));
                }

                theoremNumber.append(string2BrailleTheorem(Integer.toString(section)));
                theoremNumber.append(getTheoremCode("."));
                theoremNumber.append(string2BrailleTheorem(Integer.toString(theorem.getNextCounter())));
                label = theoremNumber.toString();
            }
        }
        {if (true) return /*"   " + */ theoremlabel  + optionallabel + " " + label + " " + content;}
    throw new Error("Missing return statement in function");
  }

  final public String command_parameter() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String optioncontent() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case INLINEMATH:
    case INLINEMATHBEG:
      s = inlinemath();
      break;
    case PARAM:
    case ACCENT:
    case GRAVEACCENT:
    case LABEL:
    case REF:
    case INDEX:
    case TEXTBF:
    case TEXTIT:
    case EMPH:
    case TEXTCIRCLED:
    case INPUT:
    case INCLUDE:
    case NEWCOMMAND:
    case DECLAREMATHOPERATOR:
    case DECLAREMATHOPERATORSTAR:
    case HUGE:
    case TEXTLATIN:
    case CHAPTER:
    case SECTION:
    case SUBSECTION:
    case VERB:
    case LTNALLCAPS:
    case TEXTSC:
    case COMMAND:
      s = textcommand();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String option() throws ParseException {
        StringBuffer result = new StringBuffer();
        String s;
    s = optioncontent();
                              result.append(s);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case COMMAND:
      case ANY:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_6;
      }
      s = optioncontent();
                                            result.append(s);
    }
          {if (true) return result.toString();}
    throw new Error("Missing return statement in function");
  }

//Here, content means character or other basic staff.
  final public String basiccontent() throws ParseException {
        String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case ACCENT:
    case GRAVEACCENT:
    case INLINEMATH:
    case INLINEMATHBEG:
    case LABEL:
    case REF:
    case INDEX:
    case TEXTBF:
    case TEXTIT:
    case EMPH:
    case TEXTCIRCLED:
    case INPUT:
    case INCLUDE:
    case NEWCOMMAND:
    case DECLAREMATHOPERATOR:
    case DECLAREMATHOPERATORSTAR:
    case HUGE:
    case TEXTLATIN:
    case CHAPTER:
    case SECTION:
    case SUBSECTION:
    case VERB:
    case LTNALLCAPS:
    case TEXTSC:
    case MATHTEXTSEPARATOR:
    case LCB:
    case COMMAND:
    case ANY:
      s = optioncontent();
      break;
    case LBRA:
    case RBRA:
      s = brackets();
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String basic() throws ParseException {
        StringBuffer result = new StringBuffer();
        String s;
    s = basiccontent();
                             result.append(s);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_7;
      }
      s = basiccontent();
                                           result.append(s);
    }
          {if (true) return result.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String content() throws ParseException {
    String s = null;
    StringBuffer buffer = new StringBuffer();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case MATHBEGIN:
      case MATHBEND:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
      case ANY:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        s = basic();
                     buffer.append(s);
        break;
      case BEG:
      case MATHBEGIN:
      case MATHBEND:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
        s = environment();
                              buffer.append(s);
        break;
      case TWONEWLINES:
      case NEWLINE:
        s = newline();
                          buffer.append(s);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

//Same as the above but with output.
  final public void topcontent() throws ParseException {
        String content = "";
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case MATHBEGIN:
      case MATHBEND:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
      case ANY:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        content = basic();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      case BEG:
      case MATHBEGIN:
      case MATHBEND:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
        content = environment();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      case TWONEWLINES:
      case NEWLINE:
        content = newline();
                try {
                    output.append(content);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public String newline() throws ParseException {
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TWONEWLINES:
      jj_consume_token(TWONEWLINES);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TWONEWLINES:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_10;
        }
        jj_consume_token(TWONEWLINES);
      }
      break;
    case NEWLINE:
      jj_consume_token(NEWLINE);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.print("\\n");
            {if (true) return "   ";} // Instead of return "\\n   ";

    throw new Error("Missing return statement in function");
  }

  final public void preamble() throws ParseException {
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_11;
      }
      jj_consume_token(TWONEWLINES);
    }
    jj_consume_token(DOCUMENTCLASS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_12;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENGLISHLETTER:
          jj_consume_token(ENGLISHLETTER);
          break;
        case TEXTSYMBOL:
          jj_consume_token(TEXTSYMBOL);
          break;
        case DIGIT0:
        case DIGIT1:
          myDigit();
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    jj_consume_token(LCB);
    label_13:
    while (true) {
      latincharacter();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_13;
      }
    }
    jj_consume_token(RCB);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case PARAM:
      case ACCENT:
      case GRAVEACCENT:
      case USEPACKAGE:
      case NEWTHEOREM:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case COMMAND:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USEPACKAGE:
        jj_consume_token(USEPACKAGE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRA:
          jj_consume_token(LBRA);
          label_15:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case DIGIT0:
            case DIGIT1:
            case ENGLISHLETTER:
            case TEXTSYMBOL:
              ;
              break;
            default:
              jj_la1[39] = jj_gen;
              break label_15;
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ENGLISHLETTER:
              jj_consume_token(ENGLISHLETTER);
              break;
            case TEXTSYMBOL:
              jj_consume_token(TEXTSYMBOL);
              break;
            case DIGIT0:
            case DIGIT1:
              myDigit();
              break;
            default:
              jj_la1[40] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(RBRA);
          break;
        default:
          jj_la1[41] = jj_gen;
          ;
        }
        jj_consume_token(LCB);
        label_16:
        while (true) {
          latincharacter();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case MATHTEXTSEPARATOR:
            ;
            break;
          default:
            jj_la1[42] = jj_gen;
            break label_16;
          }
        }
        jj_consume_token(RCB);
        break;
      case NEWTHEOREM:
        newtheorem();
        break;
      case TWONEWLINES:
        jj_consume_token(TWONEWLINES);
        break;
      case PARAM:
      case ACCENT:
      case GRAVEACCENT:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case COMMAND:
        textcommand();
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// I don't think it is useful. Just consume this.
  final public void latex() throws ParseException {
    preamble();
    jj_consume_token(BEGINDOCUMENT);
    topcontent();
    jj_consume_token(ENDDOCUMENT);
  }

  final public String environment() throws ParseException {
    String result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
      result = textenvironment();
      break;
    case MATHBEGIN:
    case MATHBEND:
    case 184:
    case 185:
    case 186:
    case 187:
    case 188:
    case 189:
    case 190:
    case 191:
    case 192:
    case 193:
    case 194:
    case 195:
      result = mathenvironment();
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String textenvironment() throws ParseException {
        String result = "";
        Token nameToken = null;
        String tokenName;
    jj_consume_token(BEG);
    nameToken = jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
                tokenName = nameToken.image;

                switch(tokenName) {
                        case "enumerate" :
                                result = enumerate();
                                break;
                        case "itemize" :
                                result = itemize();
                                break;
                        case "description" :
                                result = description();
                                break;
                        case "figure" :
                                result = figure();
                                break;
                        case "center" :
                                result = center();
                                break;
                        case "quote" :
                                result = quote();
                                break;
                        case "proof" :
                                result = proof();
                                break;
                        case "pspicture" :
                                result = pspicture();
                                break;
                        case "verbatim" :
                                result = verbatim();
                                break;
                        case "tabular" :
                                result = tabular();
                                break;
                        case "tabbing" :
                                result = tabbing();
                                break;
                        default:
                                result = theoremenvironment(tokenName);
                                break;

                }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String proof() throws ParseException {
    String content = "", optional = "", theorem = "";
    // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
        String q = getLetterCode("\u005c\u005ctextit-open") + string2Braille("\u0391\u03c0\u03bf\u03b4\u03b5\u03b9\u03be\u03b7") + getLetterCode("\u005c\u005ctextit-close");
            {if (true) return q + content + getMathCode("\u005c\u005cBox") + " ";}
    throw new Error("Missing return statement in function");
  }

  final public String pspicture() throws ParseException {
    Token t;
    String s = "";
    StringBuilder buf = new StringBuilder("");
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case SUP:
      case SUB:
      case LCB:
      case RCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case GREEKLETTER:
          case DIPHTHONG:
          case MATHSYMBOL:
          case MATHTEXTSEPARATOR:
          case MATHSEPARATOR:
          case LBRA:
          case RBRA:
            t = mathcharacter();
                                  buf.append(t.image);
            break;
          case COMMAND:
            t = jj_consume_token(COMMAND);
                                  buf.append(t.image);
            break;
          case LCB:
            t = jj_consume_token(LCB);
                                  buf.append(t.image);
            break;
          case RCB:
            t = jj_consume_token(RCB);
                                  buf.append(t.image);
            break;
          case SUP:
            t = jj_consume_token(SUP);
                                  buf.append(t.image);
            break;
          case SUB:
            t = jj_consume_token(SUB);
                                  buf.append(t.image);
            break;
          case NEWLINE:
            t = jj_consume_token(NEWLINE);
                                  buf.append("\u005c\u005cn");
            break;
          case TWONEWLINES:
            t = jj_consume_token(TWONEWLINES);
                                  buf.append("\u005c\u005cn\u005c\u005cn");
            break;
          default:
            jj_la1[45] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TWONEWLINES:
          case DIGIT0:
          case DIGIT1:
          case ENGLISHLETTER:
          case TEXTSYMBOL:
          case GREEKLETTER:
          case DIPHTHONG:
          case MATHSYMBOL:
          case MATHTEXTSEPARATOR:
          case MATHSEPARATOR:
          case SUP:
          case SUB:
          case LCB:
          case RCB:
          case LBRA:
          case RBRA:
          case NEWLINE:
          case COMMAND:
            ;
            break;
          default:
            jj_la1[46] = jj_gen;
            break label_18;
          }
        }
        break;
      case INLINEMATH:
      case INLINEMATHBEG:
        s = inlinemath();
                             buf.append(s);
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TWONEWLINES:
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case INLINEMATH:
      case INLINEMATHBEG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case SUP:
      case SUB:
      case LCB:
      case RCB:
      case LBRA:
      case RBRA:
      case NEWLINE:
      case COMMAND:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_17;
      }
    }
         s = buf.toString();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
            String result = "\u005c\u005cbegin{pspicture}" + s + "\u005c\u005cend{pspicture}";

            String pictstring = preamble.getStart() + result + preamble.getEnd();
                if (!inFigure) {
                picture++;
                DataDumper.writePicture(picture, pictstring);
                {if (true) return "";}
                }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String quote() throws ParseException {
    String content = "", optional = "", theorem = "";
    /*[LOOKAHEAD(1) <LBRA>  optional = option() <RBRA>] */
        // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
        String q = getLetterCode("'");
        {if (true) return q + content + q;}
    throw new Error("Missing return statement in function");
  }

  final public String figure() throws ParseException {
    String label = null, caption = null, s="";
    String content = "";
          inFigure = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    content = textenvironment();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAPTION:
      caption = caption();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LABEL:
        label = label();
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
        picture++;
                if (caption != null) {
                        if (null == label) {
                                System.out.println("Put label after caption on line " + jj_input_stream.getEndLine());
                                s = caption;
                        }
                        else {
                        s = string2Braille("\u03a3\u03c7\u03ae\u03bc\u03b1 ") + label + string2Braille(":") + " " + caption +"\u005cn";
                        }
                }

                String result = content + s;

            String pictstring = preamble.getStart() + result + preamble.getEnd();
                DataDumper.writePicture(picture, pictstring);
                inFigure = false;
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
          {if (true) return  s;}
    throw new Error("Missing return statement in function");
  }

  final public String caption() throws ParseException {
        String caption, label="";
    jj_consume_token(CAPTION);
    caption = command_parameter();
          {if (true) return caption;}
    throw new Error("Missing return statement in function");
  }

  final public String center() throws ParseException {
    String content = "", theorem = "";
    // By convention, label is the first command!! It should be optional!!
        content = content();
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
      {if (true) return content;}
    throw new Error("Missing return statement in function");
  }

  final public String item() throws ParseException {
    String option = "";
    StringBuffer buffer = new StringBuffer();
    jj_consume_token(ITEM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
                                                    buffer.append(option);
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
      {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String enumerate() throws ParseException {
    int counter = 1;
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
      enumeratedepth++;
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_19;
      }
      itemString = item();
                    buffer.append("\u005cn");
                if (itemString.equals("")) {
                        if (enumeratedepth == 2) {
                                buffer.append(string2Braille(IntegerConversion.integerToGreek(counter++)));
                    buffer.append(getLetterCode("."));
                } else if (enumeratedepth == 3) {
                            buffer.append(string2Braille(IntegerConversion.integerToRomanNumeral(counter++)));
                                buffer.append(getLetterCode("."));
                        } else { // enumeratedepth = 1 or 4, 5, 6, ...
                                buffer.append(getLetterCode("NUMBER-SYMBOL"));
                                buffer.append(string2Braille(Integer.toString(counter++)));
                                buffer.append(getLetterCode("."));
                        }
                } else {
                        buffer.append(itemString );
                }
                    buffer.append(getLetterCode(" "));
      contentString = content();
                    buffer.append(contentString);
                // System.out.print("\\n");

    }
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
                                    enumeratedepth--;
          {if (true) return buffer.toString()+ "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String itemize() throws ParseException {
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_20;
      }
      itemString = item();
            buffer.append("\u005cn");
            if (itemString.equals("")) {
                buffer.append(getMathCode("\u005c\u005cbullet"));
            }
                buffer.append(itemString );
      contentString = content();
            buffer.append(contentString);
            // System.out.print("\\n");

    }
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
      {if (true) return buffer.toString() + "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String verb() throws ParseException {
        StringBuffer buf = new StringBuffer();
        char ch, beg;
        boolean isNumber = false;
    jj_consume_token(VERB);
                try {beg = jj_input_stream.readChar();}
                catch(java.io.IOException ioe)
                    {System.out.println("End of file while reading verb..."); {if (true) return "";}}

                if (beg!='|' && beg!='+') {
                        System.out.println("Parse Error in verb:");

                        {if (true) return "";}
                }

                try {ch = jj_input_stream.readChar();}
                                catch(java.io.IOException ioe)
                                {System.out.println("End of file while reading verb..."); {if (true) return "";}}
                buf.append(" ");
                while (ch !=beg) {

                        String op = null;

                        if (Character.isDigit(ch) && !isNumber){
                                buf.append("\u283c");
                              isNumber = true;
                        }
                        else if (isNumber && !Character.isDigit(ch) && ch !=',' && ch !='.'){
                             isNumber = false;
                        }

                        if (ch == '+')
                           op = "\u282c";
                        else if (ch == '@')
                           op = "\u2808\u2801\u281e";
                        else op = getLetterCode(Character.toString(ch));
                        buf.append(op);

// Tests for end of line not included...
                        try {ch = jj_input_stream.readChar();}
                                catch(java.io.IOException ioe)
                                {System.out.println("End of file while reading verb..."); {if (true) return "";}}
                }

                buf.append(" ");

         //   jj_input_stream.backup(1);
                {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String verbatim() throws ParseException {
    char ch;
    int pos;
    char[] beg1 = {'\u005c\u005c','e','n','d','{','v','e','r','b','a','t','i','m','}'};
    StringBuffer buf = new StringBuffer();
    boolean isNumber=false;
        pos = 0;


        /*
   int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
	*/
        pos = 0;
        ch = 'a';//
        buf.append("\u005cn");
        outer: while(true) {
                try {ch = jj_input_stream.readChar();}
                catch(java.io.IOException ioe)
                    {System.out.println("End of file while reading verbatim..."); {if (true) return "";}}
                if (beg1.length == pos){ //    we found it
                        break outer;
                }
                else if (ch == beg1[pos]){
                        pos++;
                }
                else {
                        //jj_input_stream.backup(pos); //
                        for (int i=0; i < pos; i++) {
                                // translate character

                                buf.append(getLetterCode(Character.toString(beg1[i])));
//				System.out.print(Character.toString(beg1[i]));
                        }
//			System.out.print(ch);

                        String op = null;

                        if (Character.isDigit(ch) && !isNumber){
                                buf.append("\u283c");
                              isNumber = true;
                        }
                        else if (isNumber && !Character.isDigit(ch) && ch !=',' && ch !='.'){
                             isNumber = false;
                        }

                        if (ch == '+')
                           op = "\u282c";
                        else if (ch == '@')
                           op = "\u2808\u2801\u281e";
                        else op = getLetterCode(Character.toString(ch));
                        buf.append(op);
                        pos = 0; // There is a more efficient algorithm, KMP but ... whatever...
                }

        }
        buf.append("\u005cn");
    jj_input_stream.backup(1);
    {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabular() throws ParseException {
    StringBuffer buf = new StringBuffer();
    String row;
        tabularcolumn = 1;
    jj_consume_token(LCB);
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
      case MATHTEXTSEPARATOR:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
        jj_consume_token(ENGLISHLETTER);
        break;
      case MATHTEXTSEPARATOR:
        jj_consume_token(MATHTEXTSEPARATOR);
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RCB);
       buf.append("\u005cn\u005cn");
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HLINE:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_22;
      }
      jj_consume_token(HLINE);
    }
    row = tabularrow();
                           buf.append(row);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[58] = jj_gen;
        break label_23;
      }
      jj_consume_token(NEWLINE);
                 buf.append("\u005cn\u005cn");
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HLINE:
          ;
          break;
        default:
          jj_la1[59] = jj_gen;
          break label_24;
        }
        jj_consume_token(HLINE);
      }
      row = tabularrow();
                                                                       buf.append(row);
    }
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
      {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabularrow() throws ParseException {
        StringBuffer buf = new StringBuffer();
        tabularcolumn = 1;
        String cell="";
    if (jj_2_1(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case ACCENT:
      case GRAVEACCENT:
      case INLINEMATH:
      case INLINEMATHBEG:
      case LABEL:
      case REF:
      case INDEX:
      case TEXTBF:
      case TEXTIT:
      case EMPH:
      case TEXTCIRCLED:
      case INPUT:
      case INCLUDE:
      case NEWCOMMAND:
      case DECLAREMATHOPERATOR:
      case DECLAREMATHOPERATORSTAR:
      case HUGE:
      case TEXTLATIN:
      case CHAPTER:
      case SECTION:
      case SUBSECTION:
      case VERB:
      case LTNALLCAPS:
      case TEXTSC:
      case MATHTEXTSEPARATOR:
      case LCB:
      case LBRA:
      case RBRA:
      case COMMAND:
      case ANY:
        cell = basic();
        buf.append("\u283f\u283c" + string2Braille(Integer.toString(tabularcolumn))+"\u283b");buf.append(cell);
        break;
      case MULTICOLUMN:
        cell = multicol();
                                    buf.append(cell);
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTICOLUMN:
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_25;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        jj_consume_token(AMPERSAND);
                     tabularcolumn++;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case PARAM:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case ACCENT:
        case GRAVEACCENT:
        case INLINEMATH:
        case INLINEMATHBEG:
        case LABEL:
        case REF:
        case INDEX:
        case TEXTBF:
        case TEXTIT:
        case EMPH:
        case TEXTCIRCLED:
        case INPUT:
        case INCLUDE:
        case NEWCOMMAND:
        case DECLAREMATHOPERATOR:
        case DECLAREMATHOPERATORSTAR:
        case HUGE:
        case TEXTLATIN:
        case CHAPTER:
        case SECTION:
        case SUBSECTION:
        case VERB:
        case LTNALLCAPS:
        case TEXTSC:
        case MATHTEXTSEPARATOR:
        case LCB:
        case LBRA:
        case RBRA:
        case COMMAND:
        case ANY:
          cell = basic();
                                 buf.append("\u283f\u283c" + string2Braille(Integer.toString(tabularcolumn))+"\u283b");buf.append(cell);
          break;
        default:
          jj_la1[62] = jj_gen;
          ;
        }
        break;
      case MULTICOLUMN:
        cell = multicol();
                             buf.append(cell);
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
          {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String multicol() throws ParseException {
        StringBuffer buf = new StringBuffer();
        int cols = 0;
        String cell;
        String num;
    jj_consume_token(MULTICOLUMN);
    jj_consume_token(LCB);
    num = character_no_braille();
                                                        cols = Integer.parseInt(num);
    jj_consume_token(RCB);
    command_parameter();
    cell = command_parameter();
                buf.append("\u283f\u283c" +
                        string2Braille(Integer.toString(tabularcolumn) +
                                "-"+
                                Integer.toString(tabularcolumn+cols-1)));
                buf.append("\u283b");
                tabularcolumn += cols-1;
                buf.append(cell);
                {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tabbing() throws ParseException {
    StringBuffer buf = new StringBuffer();
    String line;
      buf.append("\u005cn\u005cn");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      jj_consume_token(NEWLINE);
                    buf.append("\u005cn");
      break;
    default:
      jj_la1[64] = jj_gen;
      ;
    }
    line = basic();
                        buf.append(line);
    label_26:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_26;
      }
      jj_consume_token(NEWLINE);
                       buf.append("\u005cn");
      line = basic();
                                                          buf.append(line);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      jj_consume_token(NEWLINE);
                       buf.append("\u005cn");
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
                                    buf.append("\u005cn\u005cn");
      {if (true) return buf.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String description() throws ParseException {
    StringBuffer buffer = new StringBuffer();
    String itemString, contentString;
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ITEM:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_27;
      }
      itemString = item();
                    buffer.append("\u005cn");
            buffer.append(itemString );
            buffer.append(getLetterCode("."));
            buffer.append(" ");
      contentString = content();
            buffer.append(contentString);
    }
    jj_consume_token(END);
    jj_consume_token(ENVNAME);
    jj_consume_token(ENVEND);
      {if (true) return buffer.toString()+ "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String mathenvironment() throws ParseException {
    String result = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATHBEGIN:
    case MATHBEND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATHBEGIN:
        jj_consume_token(MATHBEGIN);
        break;
      case MATHBEND:
        jj_consume_token(MATHBEND);
        break;
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      result = math();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATHEND:
        jj_consume_token(MATHEND);
        break;
      case MATHBEND:
        jj_consume_token(MATHBEND);
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case 184:
    case 185:
    case 186:
    case 187:
    case 188:
    case 189:
    case 190:
    case 191:
    case 192:
    case 193:
    case 194:
    case 195:
      result = eqnarray_align();
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return "\u005cn" + result + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

  final public String inlinemath() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INLINEMATH:
      t = jj_consume_token(INLINEMATH);
      break;
    case INLINEMATHBEG:
      t = jj_consume_token(INLINEMATHBEG);
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                 space = checkforPreviousSpace(t);
    s = math();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INLINEMATH:
      jj_consume_token(INLINEMATH);
      break;
    case INLINEMATHEND:
      jj_consume_token(INLINEMATHEND);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String index() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    t = jj_consume_token(INDEX);
                  space = checkforPreviousSpace(t);
    command_parameter();
    command_parameter();
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathlabel() throws ParseException {
        String txtLabel;
        Expression lbl = null;
    txtLabel = label();
                SimpleExpression sp = new SimpleExpression(" ", table);
                SimpleExpression left = new SimpleExpression("(", table);
                SimpleExpression right = new SimpleExpression(")", table);
                lbl = new MathLabelExpression(txtLabel, table);
                MathExpression me = new MathExpression(table);
                me.addChild(sp);
                me.addChild(left);
                me.addChild(lbl);
                me.addChild(right);
                {if (true) return me;}
    throw new Error("Missing return statement in function");
  }

 // Are you sure that label does this??
  final public String label() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    StringBuffer buffer = new StringBuffer();
    t = jj_consume_token(LABEL);
                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      s = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      label_28:
      while (true) {
        s = character_no_braille();
                                            buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_28;
        }
      }
                                                                    s = buffer.toString();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // System.out.println("\nLABEL: " + s);
        String label = labeltable.get(s);
        // System.out.print( " " + label + " ");
        if (label != null) {
                    label = getMathCode("NUMBER-SYMBOL")+string2BrailleTheorem(label);
        } else {
                label = getLetterCode("?");
                } // In case code is not found...
            if (space) {
            {if (true) return " " + label;}
        }
        {if (true) return label;}
    throw new Error("Missing return statement in function");
  }

  final public String ref() throws ParseException {
    Token t;
    String s = "";
    boolean space;
    StringBuffer buffer = new StringBuffer();
    t = jj_consume_token(REF);
                space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      s = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      label_29:
      while (true) {
        s = character_no_braille();
                                                buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[74] = jj_gen;
          break label_29;
        }
      }
                                                                        s = buffer.toString();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            // System.out.println("\nLABEL: " + s);
            String label = labeltable.get(s);
            if (label != null) {
                    label = string2BrailleTheorem(label);
        } else {
                    label = getLetterCode("?");
        }
            if (space) {
            {if (true) return " " + getMathCode("NUMBER-SYMBOL") + label;}
        }

            if (t.image.equals("\u005c\u005ceqref")) {
                    label = getLetterCode("(") + label + getLetterCode(")");
        }
            {if (true) return label;}
    throw new Error("Missing return statement in function");
  }

  final public String textbf() throws ParseException {
    Token t;
    boolean space;
    String s = null;
    t = jj_consume_token(TEXTBF);
                   space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
                          s = getLetterCode("\u005c\u005ctextbf") + s;
      break;
    case LCB:
      s = bracketcontent();
                                   s = bold(s);
      break;
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String ignore() throws ParseException {
    Token t;
    boolean space;
    String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTSC:
      t = jj_consume_token(TEXTSC);
      break;
    case HUGE:
      t = jj_consume_token(HUGE);
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();

      break;
    case LCB:
      s = bracketcontent();

      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String textit() throws ParseException {
  Token t;
  boolean space;
  String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTIT:
      t = jj_consume_token(TEXTIT);
      break;
    case EMPH:
      t = jj_consume_token(EMPH);
      break;
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                  space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
                          s = getLetterCode("\u005c\u005ctextit") + s;
      break;
    case LCB:
      s = bracketcontent();
                // TODO: Fix the following...
                s = getLetterCode("\u005c\u005ctextit-open")+ s + getLetterCode("\u005c\u005ctextit-close");
      break;
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String textcircled() throws ParseException {
  Token t;
  boolean space;
  String s = null;
    t = jj_consume_token(TEXTCIRCLED);
                        space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                // TODO: Fix the following...
                s = getLetterCode("\u005c\u005ctextcircled-open")+ s + getLetterCode("\u005c\u005ctextcircled-close");
            if (space) {
            {if (true) return " " + s;}
        }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String latextonemethallcaps() throws ParseException {
        Token t;
        String s = null;
        boolean space;
    t = jj_consume_token(LTNALLCAPS);
                           space = checkforPreviousSpace(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case ANY:
      s = character();
      break;
    case LCB:
      s = bracketcontent();
      break;
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                s = getLetterCode("b-allcaps") + s + getLetterCode("e-allcaps");
        if (space) {
            {if (true) return " " + s;}
        }
                {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public void input() throws ParseException {
    String s, filepath = "";
    StringBuffer buffer = new StringBuffer();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INPUT:
      jj_consume_token(INPUT);
      jj_consume_token(LCB);
      label_30:
      while (true) {
        s = character_no_braille();
                                                        buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[83] = jj_gen;
          break label_30;
        }
      }
      jj_consume_token(RCB);
              filepath = buffer.toString();
      break;
    case INCLUDE:
      jj_consume_token(INCLUDE);
      jj_consume_token(LCB);
      label_31:
      while (true) {
        s = character_no_braille();
                                                              buffer.append(s);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_31;
        }
      }
      jj_consume_token(RCB);
                  filepath = buffer.toString() + ".tex";
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        try {
                System.out.println("PARSING FILE: " + filepath);
                FileInputStream is = new FileInputStream(filepath);
            InputStreamReader fis = new InputStreamReader(is, "ISO-8859-7");
                Latex parser = new Latex (fis);
            parser.topcontent();
            System.out.println("EXITING PARSING: " + filepath);
            fis.close();
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
  }

  final public String accent() throws ParseException {
    String s = "", c = "";
    jj_consume_token(ACCENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      c = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      c = character();
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[86] = jj_gen;
          break label_32;
        }
        character_no_braille();
      }
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (c.equals("e")) {
            s = getLetterCode("e-grave");
        }
                // ...
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String grave() throws ParseException {
    String s = "", c = "";
    jj_consume_token(GRAVEACCENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHTEXTSEPARATOR:
    case SUB:
      c = character_no_braille();
      break;
    case LCB:
      jj_consume_token(LCB);
      c = character();
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIGIT0:
        case DIGIT1:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case MATHTEXTSEPARATOR:
        case SUB:
          ;
          break;
        default:
          jj_la1[88] = jj_gen;
          break label_33;
        }
        character_no_braille();
      }
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (c.equals("e")) {
                         s = getLetterCode("e-accent");
         }
                // ...
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String chapter() throws ParseException {
    String s = "", label = "";
    jj_consume_token(CHAPTER);
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[90] = jj_gen;
      ;
    }
        try {
            output.flush(); // We are always sure that the existing output stream is not closed...
            output.close();
            parsedChapters.put(chapter, output.toString());
            output = new StringWriter();
            } catch(IOException ioe) {
                    ioe.printStackTrace();
        }
        chapter++;
        section = 0;
        subsection = 0;
        if (label.equals("")) {
                    label = getLetterCode("NUMBER-SYMBOL") + string2Braille(Integer.toString(chapter));
        }
            {if (true) return "\u005cn" + string2Braille("\u039a\u03b5\u03c6\u03ac\u03bb") + getLetterCode("\u03b1\u03b9") + string2Braille("\u03bf ") + label + s + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

  final public String section() throws ParseException {
    String s = "", label = "", option = "";
    jj_consume_token(SECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[92] = jj_gen;
      ;
    }
        section++;
        subsection = 0;
        for (Theorem theorem: theorems.values()) {
            theorem.resetCounter();
        }
        if (label.equals("")) {
                    label = getLetterCode("NUMBER-SYMBOL") +    string2Braille(Integer.toString(section));
        }
        {if (true) return option + " " + label + s + "\u005cn   ";}
    throw new Error("Missing return statement in function");
  }

  final public String subsection() throws ParseException {
    String s = "", label = "", option = "";
    jj_consume_token(SUBSECTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      option = option();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    s = command_parameter();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
        subsection++;
        {if (true) return option + " " + label + s + "\u005cn";}
    throw new Error("Missing return statement in function");
  }

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////// MATHEMATICS /////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////


// put the stuff here...
  final public String math() throws ParseException {
    Expression e;
    String s = "", label = "";
    //consider that a label can be only placed in the beginning or in the end of a math expression:
    //    [label = label()]
        e = mathexpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
      label = label();
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
        e.assignFractionLevel();
        e.assignOtherLevels();

        e.getBraille();

        s = e.createBox().toString(); // TODO: Possibly does not work with arrays

                if (!e.getLabel().equals("")) {
                        s = s + getMathCode("(") + label + getMathCode(")");
        }
        {if (true) return  s ;}
    throw new Error("Missing return statement in function");
  }

  final public Token mathcharacter() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case MATHSYMBOL:
      t = jj_consume_token(MATHSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
      t = mathDelimiter();
      break;
    default:
      jj_la1[96] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public Token mathcharacter_no_brackets() throws ParseException {
        Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENGLISHLETTER:
      t = jj_consume_token(ENGLISHLETTER);
      break;
    case TEXTSYMBOL:
      t = jj_consume_token(TEXTSYMBOL);
      break;
    case DIGIT0:
    case DIGIT1:
      t = myDigit();
      break;
    case GREEKLETTER:
      t = jj_consume_token(GREEKLETTER);
      break;
    case DIPHTHONG:
      t = jj_consume_token(DIPHTHONG);
      break;
    case MATHSYMBOL:
      t = jj_consume_token(MATHSYMBOL);
      break;
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
      t = mathDelimiter_no_brackets();
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// A math expression should not be empty...
  final public Expression mathexpression() throws ParseException {
    Expression exp;
    MathExpression mex = new MathExpression(table);
        Expression exp1, exp2;
    label_34:
    while (true) {
      exp = simpleexpression();
                                                                    mex.addChild(exp);
      if (jj_2_3(2147483647)) {
        ;
      } else {
        break label_34;
      }
    }
          {if (true) return mex;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathexpression_no_brackets() throws ParseException {
    Expression exp;
    MathExpression mex = new MathExpression(table);
    label_35:
    while (true) {
      exp = simpleexpression_no_brackets();
                                                                                           mex.addChild(exp);
      if (jj_2_4(2147483647)) {
        ;
      } else {
        break label_35;
      }
    }
          {if (true) return mex;}
    throw new Error("Missing return statement in function");
  }

  final public Expression atomicmath() throws ParseException {
    Token t;
    Expression exp = new EmptyExpression();
    MathCommand cmd;
    String oper;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case LBRA:
      case RBRA:
        t = mathcharacter();
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                String s = t.image.toString();

                    cmd = commandMathTable.get(t.image);
            if (cmd != null) { // User defined command

                            InputStream targetStream = null;

                try{
                                targetStream = new ByteArrayInputStream(cmd.body.getBytes("ISO-8859-7"));
                        } catch(Exception e){e.printStackTrace();}

                for (int i = 0; i < cmd.numOfParams;i++){
                            cmd.params[i] = parameterexpression(); // This is the real	
                        }

                Latex lparser = new Latex(table, new InputStreamReader(targetStream), cmd, commandMathTable, verbose);
                        exp = lparser.mathexpression();
            }
            else {
              oper = operatorsTable.get(t.image);

              if (oper != null) {
                         InputStream targetStream = null;

                try{
                                targetStream = new ByteArrayInputStream(oper.getBytes("ISO-8859-7"));
                        } catch(Exception e){e.printStackTrace();}

                Latex lparser = new Latex(table,
                        new InputStreamReader(targetStream), preamble, verbose);
                        exp = lparser.mathexpression();
                        exp.setOperator(true);
              }
                           else { // Simple command or symbol

                        if (t.kind == DIGIT0) {
                                    s =  "NUMBER-SYMBOL" + s; // see NemethTable (hack...)
                         }
                     exp = new SimpleExpression(s, table);
                        }
                }
      break;
    case LCB:
      jj_consume_token(LCB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        exp = mathexpression();
        break;
      default:
        jj_la1[99] = jj_gen;
        ;
      }
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathparam() throws ParseException {
        Token t;
        int nParam;
    t = jj_consume_token(PARAM);
                nParam = Integer.parseInt(t.image.substring(1));
                Expression parameter = this.currentMathMacro.params[nParam-1];
                {if (true) return parameter;}
    throw new Error("Missing return statement in function");
  }

  final public Expression parameterexpression() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case LBRA:
      case RBRA:
        t = mathcharacter();
        break;
      default:
        jj_la1[101] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
                if (t.kind == DIGIT0) {
                        s = "NUMBER-SYMBOL" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);

// Doing a lexical state transition syntactically. 
// See http://www.engr.mun.ca/~theo/JavaCC-FAQ/SetState.txt
// This is for reading each numerical digit as a different parameter 
// (do not parse whole numerical expressions when reading parameters) .
            if (DEFAULT != token_source.curLexState) {
                Token root = new Token(), last = root;
                root.next = null;

                // First, we build a list of tokens to push back, in backwards order
                while (token.next != null) {
                    Token to = token;
                    // Find the token whose token.next is the last in the chain
                    while (to.next != null && to.next.next != null) {
                        to = to.next;
                    }

                    // put it at the end of the new chain
                    last.next = to.next;
                    last = to.next;

                    // If there are special tokens, these go before the regular tokens,
                    // so we want to push them back onto the input stream in the order
                    // we find them along the specialToken chain.
                    if (to.next.specialToken != null) {
                        Token tt = to.next.specialToken;
                        while (tt != null) {
                            last.next = tt;
                            last = tt;
                            tt.next = null;
                            tt = tt.specialToken;
                        }
                    }
                    to.next = null;
                };

                while (root.next != null) {
                    jj_input_stream.backup(root.next.image.length());
                    root.next = root.next.next;
                }
                jj_ntk = -1;
                token_source.SwitchTo(DEFAULT);
            }
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression atomicmath_no_brackets() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
        t = mathcharacter_no_brackets();
        break;
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
            if (t.kind == DIGIT0) {
                s = "NUMBER-SYMBOL" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression_no_brackets();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression parameterexpression_no_brackets() throws ParseException {
    Token t;
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMAND:
        t = jj_consume_token(COMMAND);
        break;
      case DIGIT0:
      case DIGIT1:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
        t = mathcharacter_no_brackets();
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            String s = t.image.toString();
                if (t.kind == DIGIT0) {
                        s = "NUMBER-SYMBOL" + s; // see NemethTable (hack...)
            }
            exp = new SimpleExpression(s, table);

            if (DEFAULT != token_source.curLexState) {
                Token root = new Token(), last = root;
                root.next = null;

                // First, we build a list of tokens to push back, in backwards order
                while (token.next != null) {
                    Token to = token;
                    // Find the token whose token.next is the last in the chain
                    while (to.next != null && to.next.next != null) {
                        to = to.next;
                    }

                    // put it at the end of the new chain
                    last.next = to.next;
                    last = to.next;

                    // If there are special tokens, these go before the regular tokens,
                    // so we want to push them back onto the input stream in the order
                    // we find them along the specialToken chain.

                    if (to.next.specialToken != null) {
                        Token tt = to.next.specialToken;
                        while (tt != null) {
                            last.next = tt;
                            last = tt;
                            tt.next = null;
                            tt = tt.specialToken;
                        }
                    }
                    to.next = null;
                };

                while (root.next != null) {
                    jj_input_stream.backup(root.next.image.length());
                    root.next = root.next.next;
                }
                jj_ntk = -1;
                token_source.SwitchTo(DEFAULT);
            }
      break;
    case LCB:
      jj_consume_token(LCB);
      exp = mathexpression_no_brackets();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression envsmathmode() throws ParseException {
        Expression exp = null;

        Token nameToken = null;
        String tokenName;
        Theorem theorem = null;
        String option = "", label = "";
    jj_consume_token(BEG);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
    case SUBARRAY:
      exp = array();
      break;
    case MATRIX:
    case SMALLMATRIX:
    case ALIGNED:
    case GATHERED:
    case ALIGNEDAT:
      exp = matrix();
      break;
    case BMATRIX:
      exp = bmatrix();
      break;
    case PMATRIX:
      exp = pmatrix();
      break;
    case BBMATRIX:
      exp = Bmatrix();
      break;
    case VMATRIX:
      exp = vmatrix();
      break;
    case VVMATRIX:
      exp = Vmatrix();
      break;
    case CASESENV:
      exp = cases();
      break;
    case SPLIT:
      exp = split();
      break;
    case SUBEQUATIONS:
      exp = ignoreenvironment();
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression basicexpression() throws ParseException {
    Expression exp=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
      exp = envsmathmode();
      break;
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case SIDESET:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
      // Environments in math mode
              exp = mathcommand();
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LCB:
    case LBRA:
    case RBRA:
    case COMMAND:
      exp = atomicmath();
      break;
    case CASES:
      exp = cases_command();
      break;
    case LEFT:
      exp = leftright();
      break;
    case DELIMITERSIZEMODIFIER:
      /* This could possibly be in atomic math non-terminal. Check. */
              exp = modifiedMathDelimiter();
      break;
    case PARAM:
      /* This could possibly be in atomic math non-terminal. Check. */
                      exp = mathparam();
      break;
    default:
      jj_la1[108] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression basicexpression_no_brackets() throws ParseException {
    Expression exp=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case SIDESET:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
      exp = mathcommand();
      break;
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case LCB:
    case COMMAND:
      exp = atomicmath_no_brackets();
      break;
    case LEFT:
      //        exp = array() |
              exp = leftright();
      break;
    case DELIMITERSIZEMODIFIER:
      exp = modifiedMathDelimiter();
      break;
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression supsub(Expression exp) throws ParseException {
    Expression exp1 = null, exp2, exp3;
    boolean limits=false, nolimits=false;
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMITS:
      case NOLIMITS:
        ;
        break;
      default:
        jj_la1[110] = jj_gen;
        break label_36;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOLIMITS:
        jj_consume_token(NOLIMITS);
                      limits=false; nolimits = true;
        break;
      case LIMITS:
        jj_consume_token(LIMITS);
                    limits=true; nolimits = false;
        break;
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUP:
      jj_consume_token(SUP);
      exp2 = basicexpression();
                exp1 = exp;
                if (exp1.isOperator() && !nolimits || limits) {
                    exp =  createOverExp(exp1,exp2);
                    //exp = new Over(exp1,exp2,table);
                }
                else if (!exp1.isOperator() && !limits || nolimits)
                    exp = new Sup(exp1, exp2, table);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUB:
        jj_consume_token(SUB);
        exp3 = basicexpression();
                 if (exp1.isOperator() && !nolimits || limits) {
                   //exp =  createOverUnderExp(exp1, exp3, exp2);
                   exp = new OverUnder(exp1, exp2,exp3,table);
                }
                else if (!exp1.isOperator() && !limits || nolimits) {
                    exp = new SubSup(exp1, exp3, exp2, table);
                  }
        break;
      default:
        jj_la1[112] = jj_gen;
        ;
      }
      break;
    case SUB:
      jj_consume_token(SUB);
      exp2 = basicexpression();
                exp1 = exp;
                if (exp1.isOperator() && !nolimits || limits) {
                    //exp =  createUnderExp(exp1,exp2);
                    exp = new Under(exp1,exp2,table);
                }
                else  if  (!exp1.isOperator() && !limits || nolimits)
                    exp = new Sub(exp1, exp2, table);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUP:
        jj_consume_token(SUP);
        exp3 = basicexpression();
                if (exp1.isOperator() && !nolimits || limits) {
                   // exp =  createOverUnderExp(exp1, exp2, exp3);
                    exp = new OverUnder(exp1,exp2,exp3,table); // Here is the error!
                }
                else if (!exp1.isOperator() && !limits || nolimits) {
                    exp = new SubSup(exp1, exp2, exp3, table);

                  }
        break;
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression simpleexpression() throws ParseException {
    Token t;
    Expression exp = null, exp1 = null, exp2, exp3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case LBRA:
    case RBRA:
    case COMMAND:
      exp = basicexpression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMITS:
      case NOLIMITS:
      case SUP:
      case SUB:
        exp = supsub(exp);
        break;
      default:
        jj_la1[115] = jj_gen;
        ;
      }
      break;
    case LIMITS:
    case NOLIMITS:
    case SUP:
    case SUB:
              exp = new EmptyExpression();
      exp = supsub(exp);
      break;
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression simpleexpression_no_brackets() throws ParseException {
    Token t;
    Expression exp = null, exp1 = null, exp2, exp3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIGIT0:
    case DIGIT1:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case COMMAND:
      exp = basicexpression_no_brackets();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMITS:
      case NOLIMITS:
      case SUP:
      case SUB:
        exp = supsub(exp);
        break;
      default:
        jj_la1[117] = jj_gen;
        ;
      }
      break;
    case LIMITS:
    case NOLIMITS:
    case SUP:
    case SUB:
              exp = new EmptyExpression();
      exp = supsub(exp);
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression mathcommand() throws ParseException {
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SQRT:
      exp = sqrt();
      break;
    case CUBEROOT:
      exp = cuberoot();
      break;
    case FORTHROOT:
      exp = forthroot();
      break;
    case FRAC:
      exp = frac();
      break;
    case CFRAC:
      exp = cfrac();
      break;
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
      exp = textinmath();
      break;
    case TEXTLATIN:
      exp = latinmath();
      break;
    case MATHBB:
      exp = mathbb();
      break;
    case MATHCAL:
      exp = mathcal();
      break;
    case UNDERBRACE:
      exp = underbrace();
      break;
    case OVERBRACE:
      exp = overbrace();
      break;
    case DOT:
      exp = dot();
      break;
    case OVERLINE:
      exp = overline();
      break;
    case UNDERLINE:
      exp = underline();
      break;
    case TILDE:
      exp = tilde();
      break;
    case VEC:
      exp = vec();
      break;
    case LENQNO:
      exp = lenqno();
      break;
    case BINOM:
      exp = binom();
      break;
    case HAT:
    case WIDEHAT:
      exp = hat();
      break;
    case BAR:
      exp = bar();
      break;
    case STACKREL:
      exp = stackrel();
      break;
    case CHECK:
      exp = check();
      break;
    case ACUTE:
      exp = acute();
      break;
    case GRAVE:
      exp = gravemath();
      break;
    case BREVE:
      exp = breve();
      break;
    case DDOT:
      exp = ddot();
      break;
    case MATHRING:
      exp = mathring();
      break;
    case OVERSET:
      exp = overset();
      break;
    case UNDERSET:
      exp = underset();
      break;
    case OVERUNDERSET:
      exp = overunderset();
      break;
    case SIDESET:
      exp = sideset();
      break;
    case OPERATORNAME:
    case OPERATORNAMESTAR:
      exp = operatorname();
      break;
    case MOD:
    case BMOD:
      exp = mod();
      break;
    case PMOD:
      exp = pmod();
      break;
    case POD:
      exp = pod();
      break;
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
      exp = variousCommandsAfter();
      break;
    case VERTOVERLAY:
    case NOTACCENT:
    case LONGDIVISION:
      exp = variousCommandsBefore();
      break;
    case LABEL:
      exp = mathlabel();
      break;
    case SUBSTACK:
      exp = substack();
      break;
    case TEXTSC:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
      exp = ignorecommand();
      break;
    case XLEFTARROW:
      exp = xleftarrow();
      break;
    case XRIGHTARROW:
      exp = xrightarrow();
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

//TODO: Fix.
  final public Expression [] row() throws ParseException {
    Expression exp = null;
    Vector<Expression> expressions =  new Vector<Expression>();
    Expression[] exparray;
    int hdots;
    boolean empty = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case HDOTSFOR:
    case LIMITS:
    case NOLIMITS:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        exp = mathexpression();
                                expressions.add(exp); empty = false;
        break;
      case HDOTSFOR:
        hdots = hdotsfor();
           empty = false;
           expressions.add(new HdotsforExpression(hdots));
                        for (int k = 1; k < hdots; k++) {
                        expressions.add(new EmptyExpression());
                }
        break;
      default:
        jj_la1[120] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[121] = jj_gen;
      ;
    }
                  if (empty) expressions.add(new EmptyExpression()); empty = true;
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_37;
      }
      jj_consume_token(AMPERSAND);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case HDOTSFOR:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BEG:
        case DIGIT0:
        case DIGIT1:
        case PARAM:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case LABEL:
        case OPERATORNAME:
        case OPERATORNAMESTAR:
        case MOD:
        case PMOD:
        case BMOD:
        case POD:
        case TEXTLATIN:
        case FRAC:
        case SQRT:
        case LEFT:
        case TEXTRM:
        case INTERTEXT:
        case SHORTINTERTEXT:
        case HBOX:
        case MBOX:
        case TILDE:
        case TEXTSC:
        case OVERLINE:
        case UNDERLINE:
        case DOT:
        case LENQNO:
        case HAT:
        case WIDEHAT:
        case VEC:
        case BAR:
        case STACKREL:
        case CHECK:
        case ACUTE:
        case GRAVE:
        case CASES:
        case BREVE:
        case DDOT:
        case MATHRING:
        case BINOM:
        case MATHBB:
        case MATHCAL:
        case UNDERBRACE:
        case OVERBRACE:
        case LIMITS:
        case NOLIMITS:
        case SIDESET:
        case MATHSYMBOL:
        case MATHTEXTSEPARATOR:
        case MATHSEPARATOR:
        case DELIMITERSIZEMODIFIER:
        case SUP:
        case SUB:
        case LCB:
        case OVERSET:
        case UNDERSET:
        case OVERUNDERSET:
        case OVERBAR:
        case OVHOOK:
        case OCIRC:
        case CANDRA:
        case OTURNEDCOMMA:
        case OCOMMATOPRIGHT:
        case DROANG:
        case LEFTHARPOONACCENT:
        case RIGHTHARPOONACCENT:
        case VERTOVERLAY:
        case DDDOT:
        case DDDDOT:
        case ANNUITY:
        case WIDEBRIDGEABOVE:
        case ASTERACCENT:
        case NOTACCENT:
        case WIDETILDE:
        case WIDEOVERBAR:
        case WIDEBREVE:
        case WIDECHECK:
        case OVERLEFTHARPOON:
        case OVERRIGHTHARPOON:
        case OVERLEFTARROW:
        case OVERRIGHTARROW:
        case OVERLEFTRIGHTARROW:
        case THREEUNDERDOT:
        case MATHUNDERBAR:
        case WIDEUTILDE:
        case UNDERLEFTRIGHTARROW:
        case UNDERRIGHTHARPOONDOWN:
        case UNDERLEFTHARPOONDOWN:
        case UNDERLEFTARROW:
        case UNDERRIGHTARROW:
        case LONGDIVISION:
        case OVERBRACKET:
        case OVERPAREN:
        case UNDERBRACKET:
        case UNDERPAREN:
        case XLEFTARROW:
        case XRIGHTARROW:
        case BOXED:
        case SMASH:
        case UPROOT:
        case LEFTROOT:
        case DISPLAYBREAK:
        case NUMBERWITHIN:
        case ALLOWDISPLAYBREAKS:
        case RAISETAG:
        case CUBEROOT:
        case FORTHROOT:
        case SUBSTACK:
        case CFRAC:
        case LBRA:
        case RBRA:
        case COMMAND:
          exp = mathexpression();
                                            expressions.add(exp); empty = false;
          break;
        case HDOTSFOR:
          hdots = hdotsfor();
                empty = false;
                        expressions.add(new HdotsforExpression(hdots));
                        for (int k = 1; k < hdots; k++) {
                        expressions.add(new  EmptyExpression());
                }
          break;
        default:
          jj_la1[123] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[124] = jj_gen;
        ;
      }
                 if (empty) expressions.add(new EmptyExpression()); empty = true;
    }
          if (expressions.size()==1 &&
        expressions.elementAt(0) instanceof EmptyExpression)
                expressions.remove(0);
                {if (true) return expressions.toArray(new Expression[expressions.size()]);}
    throw new Error("Missing return statement in function");
  }

  final public Expression[] arrayrow(int cols) throws ParseException {
        Expression exp;
        Expression [] expressions =  new Expression[cols];
        int col = 0, hdots;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case HDOTSFOR:
    case LIMITS:
    case NOLIMITS:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case LBRA:
    case RBRA:
    case COMMAND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        exp = mathexpression();
                               expressions[col] = exp;
        break;
      case HDOTSFOR:
        hdots = hdotsfor();
          expressions[++col] = new HdotsforExpression(hdots);
                        for (int k = 1; k < hdots; k++) {
                         expressions[++col] = new EmptyExpression();
                }
        break;
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[126] = jj_gen;
      ;
    }
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
        ;
        break;
      default:
        jj_la1[127] = jj_gen;
        break label_38;
      }
      jj_consume_token(AMPERSAND);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case HDOTSFOR:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BEG:
        case DIGIT0:
        case DIGIT1:
        case PARAM:
        case ENGLISHLETTER:
        case TEXTSYMBOL:
        case GREEKLETTER:
        case DIPHTHONG:
        case LABEL:
        case OPERATORNAME:
        case OPERATORNAMESTAR:
        case MOD:
        case PMOD:
        case BMOD:
        case POD:
        case TEXTLATIN:
        case FRAC:
        case SQRT:
        case LEFT:
        case TEXTRM:
        case INTERTEXT:
        case SHORTINTERTEXT:
        case HBOX:
        case MBOX:
        case TILDE:
        case TEXTSC:
        case OVERLINE:
        case UNDERLINE:
        case DOT:
        case LENQNO:
        case HAT:
        case WIDEHAT:
        case VEC:
        case BAR:
        case STACKREL:
        case CHECK:
        case ACUTE:
        case GRAVE:
        case CASES:
        case BREVE:
        case DDOT:
        case MATHRING:
        case BINOM:
        case MATHBB:
        case MATHCAL:
        case UNDERBRACE:
        case OVERBRACE:
        case LIMITS:
        case NOLIMITS:
        case SIDESET:
        case MATHSYMBOL:
        case MATHTEXTSEPARATOR:
        case MATHSEPARATOR:
        case DELIMITERSIZEMODIFIER:
        case SUP:
        case SUB:
        case LCB:
        case OVERSET:
        case UNDERSET:
        case OVERUNDERSET:
        case OVERBAR:
        case OVHOOK:
        case OCIRC:
        case CANDRA:
        case OTURNEDCOMMA:
        case OCOMMATOPRIGHT:
        case DROANG:
        case LEFTHARPOONACCENT:
        case RIGHTHARPOONACCENT:
        case VERTOVERLAY:
        case DDDOT:
        case DDDDOT:
        case ANNUITY:
        case WIDEBRIDGEABOVE:
        case ASTERACCENT:
        case NOTACCENT:
        case WIDETILDE:
        case WIDEOVERBAR:
        case WIDEBREVE:
        case WIDECHECK:
        case OVERLEFTHARPOON:
        case OVERRIGHTHARPOON:
        case OVERLEFTARROW:
        case OVERRIGHTARROW:
        case OVERLEFTRIGHTARROW:
        case THREEUNDERDOT:
        case MATHUNDERBAR:
        case WIDEUTILDE:
        case UNDERLEFTRIGHTARROW:
        case UNDERRIGHTHARPOONDOWN:
        case UNDERLEFTHARPOONDOWN:
        case UNDERLEFTARROW:
        case UNDERRIGHTARROW:
        case LONGDIVISION:
        case OVERBRACKET:
        case OVERPAREN:
        case UNDERBRACKET:
        case UNDERPAREN:
        case XLEFTARROW:
        case XRIGHTARROW:
        case BOXED:
        case SMASH:
        case UPROOT:
        case LEFTROOT:
        case DISPLAYBREAK:
        case NUMBERWITHIN:
        case ALLOWDISPLAYBREAKS:
        case RAISETAG:
        case CUBEROOT:
        case FORTHROOT:
        case SUBSTACK:
        case CFRAC:
        case LBRA:
        case RBRA:
        case COMMAND:
          exp = mathexpression();
                                           expressions[++col]=exp;
          break;
        case HDOTSFOR:
          hdots = hdotsfor();
                expressions[++col] = new HdotsforExpression(hdots);
                        for (int k = 1; k < hdots; k++) {
                         expressions[++col] = new EmptyExpression();
                }
          break;
        default:
          jj_la1[128] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[129] = jj_gen;
        ;
      }
    }
          {if (true) return expressions;}
    throw new Error("Missing return statement in function");
  }

  final public Expression cases() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(CASESENV);
    jj_consume_token(ENVEND);
    row = arrayrow(2);
                        rows.add(row);
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[130] = jj_gen;
        break label_39;
      }
      jj_consume_token(NEWLINE);
      row = arrayrow(2);
                                   rows.add(row);
    }
    jj_consume_token(END);
    jj_consume_token(CASESENV);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c{",".", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

//TODO: Fix empty row!
  final public Vector<Expression [] > parseArray() throws ParseException {
        Expression[] row;
        Vector<Expression [] > rows =new Vector<Expression[] >();
    row = row();
                       if (row.length > 0) rows.add(row);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_40;
      }
      jj_consume_token(NEWLINE);
      row = row();
                               if (row.length > 0)   rows.add(row);
    }
        {if (true) return rows;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ignoreenvironment() throws ParseException {
        Expression exp = null;
    jj_consume_token(SUBEQUATIONS);
    jj_consume_token(ENVEND);
    exp = mathexpression();
    jj_consume_token(END);
    jj_consume_token(SUBEQUATIONS);
    jj_consume_token(ENVEND);
        {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression matrix() throws ParseException {
    Vector<Expression[]> rows  = null;
    int cols = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATRIX:
      jj_consume_token(MATRIX);
      break;
    case SMALLMATRIX:
      jj_consume_token(SMALLMATRIX);
      break;
    case ALIGNED:
      jj_consume_token(ALIGNED);
      break;
    case GATHERED:
      jj_consume_token(GATHERED);
      break;
    case ALIGNEDAT:
      jj_consume_token(ALIGNEDAT);
      break;
    default:
      jj_la1[132] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MATRIX:
      jj_consume_token(MATRIX);
      break;
    case SMALLMATRIX:
      jj_consume_token(SMALLMATRIX);
      break;
    case ALIGNED:
      jj_consume_token(ALIGNED);
      break;
    case GATHERED:
      jj_consume_token(GATHERED);
      break;
    case ALIGNEDAT:
      jj_consume_token(ALIGNEDAT);
      break;
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        {if (true) return array;}
    throw new Error("Missing return statement in function");
  }

  final public Expression pmatrix() throws ParseException {
    Vector<Expression[]> rows = null;
    int cols = 0;
    jj_consume_token(PMATRIX);
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    jj_consume_token(PMATRIX);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("(",")", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression bmatrix() throws ParseException {
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(BMATRIX);
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    jj_consume_token(BMATRIX);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("[","]", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression Bmatrix() throws ParseException {
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(BBMATRIX);
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    jj_consume_token(BBMATRIX);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c{ ","\u005c\u005c}", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression vmatrix() throws ParseException {
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(VMATRIX);
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    jj_consume_token(VMATRIX);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("| ","|", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression Vmatrix() throws ParseException {
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(VVMATRIX);
    jj_consume_token(ENVEND);
    rows = parseArray();
    jj_consume_token(END);
    jj_consume_token(VVMATRIX);
    jj_consume_token(ENVEND);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c| ","\u005c\u005c|", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression cases_command() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    jj_consume_token(CASES);
    jj_consume_token(LCB);
    row = cases_row();
                                     rows.add(row);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CR:
        ;
        break;
      default:
        jj_la1[134] = jj_gen;
        break label_41;
      }
      jj_consume_token(CR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEG:
      case DIGIT0:
      case DIGIT1:
      case PARAM:
      case ENGLISHLETTER:
      case TEXTSYMBOL:
      case GREEKLETTER:
      case DIPHTHONG:
      case LABEL:
      case OPERATORNAME:
      case OPERATORNAMESTAR:
      case MOD:
      case PMOD:
      case BMOD:
      case POD:
      case TEXTLATIN:
      case FRAC:
      case SQRT:
      case LEFT:
      case TEXTRM:
      case INTERTEXT:
      case SHORTINTERTEXT:
      case HBOX:
      case MBOX:
      case TILDE:
      case TEXTSC:
      case OVERLINE:
      case UNDERLINE:
      case DOT:
      case LENQNO:
      case HAT:
      case WIDEHAT:
      case VEC:
      case BAR:
      case STACKREL:
      case CHECK:
      case ACUTE:
      case GRAVE:
      case CASES:
      case BREVE:
      case DDOT:
      case MATHRING:
      case BINOM:
      case MATHBB:
      case MATHCAL:
      case UNDERBRACE:
      case OVERBRACE:
      case LIMITS:
      case NOLIMITS:
      case SIDESET:
      case MATHSYMBOL:
      case MATHTEXTSEPARATOR:
      case MATHSEPARATOR:
      case DELIMITERSIZEMODIFIER:
      case SUP:
      case SUB:
      case LCB:
      case OVERSET:
      case UNDERSET:
      case OVERUNDERSET:
      case OVERBAR:
      case OVHOOK:
      case OCIRC:
      case CANDRA:
      case OTURNEDCOMMA:
      case OCOMMATOPRIGHT:
      case DROANG:
      case LEFTHARPOONACCENT:
      case RIGHTHARPOONACCENT:
      case VERTOVERLAY:
      case DDDOT:
      case DDDDOT:
      case ANNUITY:
      case WIDEBRIDGEABOVE:
      case ASTERACCENT:
      case NOTACCENT:
      case WIDETILDE:
      case WIDEOVERBAR:
      case WIDEBREVE:
      case WIDECHECK:
      case OVERLEFTHARPOON:
      case OVERRIGHTHARPOON:
      case OVERLEFTARROW:
      case OVERRIGHTARROW:
      case OVERLEFTRIGHTARROW:
      case THREEUNDERDOT:
      case MATHUNDERBAR:
      case WIDEUTILDE:
      case UNDERLEFTRIGHTARROW:
      case UNDERRIGHTHARPOONDOWN:
      case UNDERLEFTHARPOONDOWN:
      case UNDERLEFTARROW:
      case UNDERRIGHTARROW:
      case LONGDIVISION:
      case OVERBRACKET:
      case OVERPAREN:
      case UNDERBRACKET:
      case UNDERPAREN:
      case XLEFTARROW:
      case XRIGHTARROW:
      case BOXED:
      case SMASH:
      case UPROOT:
      case LEFTROOT:
      case DISPLAYBREAK:
      case NUMBERWITHIN:
      case ALLOWDISPLAYBREAKS:
      case RAISETAG:
      case CUBEROOT:
      case FORTHROOT:
      case SUBSTACK:
      case CFRAC:
      case LBRA:
      case RBRA:
      case COMMAND:
        row = cases_row();
                               rows.add(row);
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
    }
    jj_consume_token(RCB);
        Array array  = new Array(rows, table);
        DelimiterExpression dexp = new DelimiterExpression("\u005c\u005c{",".", array, table);
        {if (true) return dexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression[] cases_row() throws ParseException {
        Expression exp;
        String s;
        Expression [] expressions =  new Expression[2];
    exp = mathexpression();
                           expressions[0] = exp;
    jj_consume_token(AMPERSAND);
    s = content();
                                expressions[1] = new TextMathExpression(s,table);
          {if (true) return expressions;}
    throw new Error("Missing return statement in function");
  }

  final public Expression array() throws ParseException {
    Expression[] row = null;
    Vector<Expression[]> rows = new Vector<Expression[]>();
    int cols = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
      jj_consume_token(ARRAY);
      break;
    case SUBARRAY:
      jj_consume_token(SUBARRAY);
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ENVEND);
    jj_consume_token(LCB);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENGLISHLETTER:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_42;
      }
      jj_consume_token(ENGLISHLETTER);
                                                                     cols++;
    }
    jj_consume_token(RCB);
    rows = parseArray();
    jj_consume_token(END);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
      jj_consume_token(ARRAY);
      break;
    case SUBARRAY:
      jj_consume_token(SUBARRAY);
      break;
    default:
      jj_la1[138] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ENVEND);
      {if (true) return new Array(rows, table);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression split() throws ParseException {
    Expression[] r;
    MathExpression math = new MathExpression(table);
    jj_consume_token(SPLIT);
    jj_consume_token(ENVEND);
    r = row();
        for (Expression exp : r) {
                    math.addChild(exp);
        }
        math.addChild(new SimpleExpression(" ", table));
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NEWLINE:
        ;
        break;
      default:
        jj_la1[139] = jj_gen;
        break label_43;
      }
      jj_consume_token(NEWLINE);

      r = row();
            for (Expression exp : r) {
                        // buffer.append(exp.getBraille());
                        math.addChild(exp);
            }
            math.addChild(new SimpleExpression(" ", table));
    }
    jj_consume_token(END);
    jj_consume_token(SPLIT);
    jj_consume_token(ENVEND);
        {if (true) return math;}
        // buffer.toString();

    throw new Error("Missing return statement in function");
  }

//TODO: fix.
  final public String eqnarray_align() throws ParseException {
        Vector<Expression[]> rows  = null;
    Expression[] r;
    StringBuffer buffer = new StringBuffer();
    String label;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 184:
      jj_consume_token(184);
      break;
    case 185:
      jj_consume_token(185);
      break;
    case 186:
      jj_consume_token(186);
      break;
    case 187:
      jj_consume_token(187);
      break;
    case 188:
      jj_consume_token(188);
      break;
    case 189:
      jj_consume_token(189);
      break;
    case 190:
      jj_consume_token(190);
      break;
    case 191:
      jj_consume_token(191);
      break;
    case 192:
      jj_consume_token(192);
      break;
    case 193:
      jj_consume_token(193);
      break;
    case 194:
      jj_consume_token(194);
      jj_consume_token(LCB);
      parameterexpression();
      jj_consume_token(RCB);
      break;
    case 195:
      jj_consume_token(195);
      jj_consume_token(LCB);
      parameterexpression();
      jj_consume_token(RCB);
      break;
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    rows = parseArray();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 196:
      jj_consume_token(196);
      break;
    case 197:
      jj_consume_token(197);
      break;
    case 198:
      jj_consume_token(198);
      break;
    case 199:
      jj_consume_token(199);
      break;
    case 200:
      jj_consume_token(200);
      break;
    case 201:
      jj_consume_token(201);
      break;
    case 202:
      jj_consume_token(202);
      break;
    case 203:
      jj_consume_token(203);
      break;
    case 204:
      jj_consume_token(204);
      break;
    case 205:
      jj_consume_token(205);
      break;
    case 206:
      jj_consume_token(206);
      break;
    case 207:
      jj_consume_token(207);
      break;
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      Array array = new Array(rows,table);
      array.assignFractionLevel();
      array.assignOtherLevels();
      String str = array.getBraille();
      {if (true) return str;}
    throw new Error("Missing return statement in function");
  }

/*
//This is a top level expression...
String eqnarray_align() :
{
    Expression[] r;
    StringBuffer buffer = new StringBuffer();
    String label;
}
{
    ("\\begin{eqnarray}" | "\\begin{eqnarray*}" | "\\begin{align}" | "\\begin{align*}")
 	[LOOKAHEAD(1) label = label()] 
    r = row()
    {
        for (Expression exp : r) { //??
            exp.assignFractionLevel();
            exp.assignOtherLevels();
    		buffer.append(exp.getBraille());
        }
    }
    [label = label() { buffer.append(" " + getMathCode("(") + label+ getMathCode(")")); }]
    (
        <NEWLINE> //[LOOKAHEAD(1) <LBRA> mathexpression_no_brackets() <RBRA>]
        { buffer.append(" "); }
        r = row()
        {
            for (Expression exp : r) {
                exp.assignFractionLevel();
                exp.assignOtherLevels();
		        buffer.append(exp.getBraille());
            }
            //TODO: Make an Array expression properly aligned
        }
        [label = label() { buffer.append(" " + getMathCode("(") + label+ getMathCode(")")); }]
    )* 
    ("\\end{eqnarray}" | "\\end{eqnarray*}" | "\\end{align}" | "\\end{align*}")
    { return buffer.toString(); }
}
*/
  final public Expression operatorname() throws ParseException {
  Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPERATORNAME:
      jj_consume_token(OPERATORNAME);
      break;
    case OPERATORNAMESTAR:
      jj_consume_token(OPERATORNAMESTAR);
      break;
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
      exp.setOperator(true);
      {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression substack() throws ParseException {
        Expression exp = null;
        Expression exp1 = null, exp2 = null;
    jj_consume_token(SUBSTACK);
    jj_consume_token(LCB);
    exp1 = mathexpression();
    jj_consume_token(NEWLINE);
    exp2 = mathexpression();
    jj_consume_token(RCB);
           {if (true) return new Over(exp2,exp1,table);}
    throw new Error("Missing return statement in function");
  }

  final public void declaremathoperator() throws ParseException {
  String newcommand, definition;
  Token commandToken;
  Token nParamToken=null;
  StringBuffer def = new StringBuffer();
  char c;
  int n = 1;
  int nParams = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECLAREMATHOPERATOR:
      jj_consume_token(DECLAREMATHOPERATOR);
      break;
    case DECLAREMATHOPERATORSTAR:
      jj_consume_token(DECLAREMATHOPERATORSTAR);
      break;
    default:
      jj_la1[143] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LCB);
    commandToken = jj_consume_token(COMMAND);
    jj_consume_token(RCB);
    jj_consume_token(LCB);
                //TODO: Complete.
                // from newcommand...
                char pc = ' ';
                while(true){
                        try {
                c = jj_input_stream.readChar();
            } catch(java.io.IOException ioe) {
                System.out.println("End of file while reading operator definition..");
                {if (true) return;}
            }
                        if (n == 1 && c == '}') break;
                        else if (c=='}' && pc !='\u005c\u005c') n--;
                        else if (c=='{'&& pc !='\u005c\u005c') n++;
                        def.append(c);
                        pc = c;
                }

                definition = def.toString();
                operatorsTable.put(commandToken.image,definition);
  }

  final public Fraction frac() throws ParseException {
    Expression nom, denom;
    jj_consume_token(FRAC);
    nom = parameterexpression();
    denom = parameterexpression();
      {if (true) return new Fraction(nom, denom, table);}
    throw new Error("Missing return statement in function");
  }

  final public Fraction cfrac() throws ParseException {
    Expression nom, denom;
    jj_consume_token(CFRAC);
    nom = parameterexpression();
    denom = parameterexpression();
      {if (true) return new Cfrac(nom, denom, table);}
    throw new Error("Missing return statement in function");
  }

  final public Sqrt sqrt() throws ParseException {
    Expression root;
    Expression rank = null;
    Token t;
    jj_consume_token(SQRT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      rank = mathexpression_no_brackets();
      jj_consume_token(RBRA);

      break;
    default:
      jj_la1[144] = jj_gen;
      ;
    }
    root = parameterexpression();
            if (rank != null) {
                {if (true) return new Sqrt(root, rank, table);}
        }
            {if (true) return new Sqrt(root, table);}
    throw new Error("Missing return statement in function");
  }

// This is a special kind of array...
  final public Expression leftright() throws ParseException {
  Token t1, t2;
  Expression exp;
    jj_consume_token(LEFT);
    t1 = mathDelimiter();
    exp = mathexpression();
    jj_consume_token(RIGHT);
    t2 = mathDelimiter();
          {if (true) return new DelimiterExpression(t1.image, t2.image, exp, table);}
    throw new Error("Missing return statement in function");
  }

  final public Expression latinmath() throws ParseException {
    Expression exp;
    String s;
    jj_consume_token(TEXTLATIN);
    s = command_parameter();
        String en = getLetterCode("EN");
        s = en + s;
        {if (true) return new TextMathExpression(s, table);}
    throw new Error("Missing return statement in function");
  }

  final public int hdotsfor() throws ParseException {
        Expression numberexp;
        int num;
    jj_consume_token(HDOTSFOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      mathexpression_no_brackets();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    jj_consume_token(LCB);
    numberexp = mathexpression();
    jj_consume_token(RCB);
                num = ((MathExpression) numberexp).getIntegerValue();

                {if (true) return num;}
    throw new Error("Missing return statement in function");
  }

  final public Expression textinmath() throws ParseException {
    Expression exp;
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTRM:
      jj_consume_token(TEXTRM);
      break;
    case INTERTEXT:
      jj_consume_token(INTERTEXT);
      break;
    case SHORTINTERTEXT:
      jj_consume_token(SHORTINTERTEXT);
      break;
    case HBOX:
      jj_consume_token(HBOX);
      break;
    case MBOX:
      jj_consume_token(MBOX);
      break;
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    s = command_parameter();
          {if (true) return new TextMathExpression(s, table);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathbb() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHBB);
    exp = parameterexpression();
        newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathbb", table));
                newexp.addChild(exp);
                {if (true) return newexp;}
                //TODO: It should be an end symbol here, probably a space...

    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathcal() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHCAL);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathcal", table));
                newexp.addChild(exp);
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression breve() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(BREVE);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cbreve", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression ddot() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(DDOT);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cddot", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mathring() throws ParseException {
    Expression exp;
    MathExpression newexp;
    jj_consume_token(MATHRING);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cmathring", table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression mod() throws ParseException {
  Expression exp; MathExpression newexp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MOD:
      jj_consume_token(MOD);
      break;
    case BMOD:
      jj_consume_token(BMOD);
      break;
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);

                newexp.addChild(new SimpleExpression("\u005c\u005cmod",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression(" ",table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression pmod() throws ParseException {
  Expression exp; MathExpression newexp;
    jj_consume_token(PMOD);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("(",table));
                newexp.addChild(new SimpleExpression("\u005c\u005cmod",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression(")",table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression pod() throws ParseException {
  Expression exp; MathExpression newexp;
    jj_consume_token(POD);
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression(" ",table));
                newexp.addChild(new SimpleExpression("(",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression(")",table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression xleftarrow() throws ParseException {
  Expression optexp = null, exp = null;
  MathExpression newexp;
    jj_consume_token(XLEFTARROW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      optexp = mathexpression_no_brackets();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[148] = jj_gen;
      ;
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cxleftarrow",table));
                if (optexp != null) {
                        newexp.addChild(new SimpleExpression("\u005c\u005cunderset",table));
                        newexp.addChild(optexp);
                }

                newexp.addChild(new SimpleExpression("\u005c\u005coverset",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-end",table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression xrightarrow() throws ParseException {
  Expression optexp = null, exp = null; MathExpression newexp;
    jj_consume_token(XRIGHTARROW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRA:
      jj_consume_token(LBRA);
      optexp = mathexpression_no_brackets();
      jj_consume_token(RBRA);
      break;
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cxrightarrow",table));
                if (optexp != null) {
                        newexp.addChild(new SimpleExpression("\u005c\u005cunderset", table));
                        newexp.addChild(optexp);
                }

                newexp.addChild(new SimpleExpression("\u005c\u005coverset", table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-end",table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

//MathExpression overleftarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< OVERLEFTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createOverExp(exp,new SimpleExpression("\\leftarrow",table));
//		return newexp;
//	}
//}
//
//MathExpression overrightarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< OVERRIGHTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createOverExp(exp,new SimpleExpression("\\rightarrow",table));
//		return newexp;
//	}
//}
//
//MathExpression overleftrightarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< OVERLEFTRIGHTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createOverExp(exp,new SimpleExpression("\\leftrightarrow",table));
//		return newexp;
//	}
//}
//
//MathExpression underleftarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< UNDERLEFTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createUnderExp(exp,new SimpleExpression("\\leftarrow",table));
//		return newexp;
//	}
//}
//
//MathExpression underrightarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< UNDERRIGHTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createUnderExp(exp,new SimpleExpression("\\rightarrow",table));
//		return newexp;
//	}
//}
//
//MathExpression underleftrightarrow() :
//{
//  Expression exp; MathExpression newexp;
//}
//{
//	< UNDERLEFTRIGHTARROW >  exp = parameterexpression()
//	{
//	  	
//	  	newexp = createUnderExp(exp,new SimpleExpression("\\leftrightarrow",table));
//		return newexp;
//	}
//}
  final public MathExpression vec() throws ParseException {
  Expression exp; MathExpression newexp;
    jj_consume_token(VEC);
    exp = parameterexpression();
                newexp = new MathExpression(table);

                newexp.addChild(new SimpleExpression("\u005c\u005cvec-begin",table));
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005cvec-end",table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression hat() throws ParseException {
    Expression exp;
    MathExpression newexp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HAT:
      jj_consume_token(HAT);
      break;
    case WIDEHAT:
      jj_consume_token(WIDEHAT);
      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression("\u005c\u005chat", table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overline() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(OVERLINE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005coverline-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005coverline-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression underline() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(UNDERLINE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderline-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderline-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression dot() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(DOT);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression binom() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(BINOM);
    under = parameterexpression();
    sub = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("(", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cbinom", table));
                newexp.addChild(sub);
                newexp.addChild(new SimpleExpression(")", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

// TODO: Ignore command should totally ignore the command,
// not just put the argument in the output.
  final public Expression ignorecommand() throws ParseException {
    Expression exp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXTSC:
    case BOXED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEXTSC:
        jj_consume_token(TEXTSC);
        break;
      case BOXED:
        jj_consume_token(BOXED);
        break;
      default:
        jj_la1[151] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      exp = parameterexpression();
      break;
    case DISPLAYBREAK:
    case ALLOWDISPLAYBREAKS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISPLAYBREAK:
        jj_consume_token(DISPLAYBREAK);
        break;
      case ALLOWDISPLAYBREAKS:
        jj_consume_token(ALLOWDISPLAYBREAKS);
        break;
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        mathexpression_no_brackets();
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[153] = jj_gen;
        ;
      }
                                                                               exp = new EmptyExpression();
      break;
    case NUMBERWITHIN:
      jj_consume_token(NUMBERWITHIN);
      parameterexpression();
      parameterexpression();
                                                                           exp = new EmptyExpression();
      break;
    case UPROOT:
    case LEFTROOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFTROOT:
        jj_consume_token(LEFTROOT);
        break;
      case UPROOT:
        jj_consume_token(UPROOT);
        break;
      default:
        jj_la1[154] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      parameterexpression();
                                     exp = new EmptyExpression();
      break;
    case SMASH:
      jj_consume_token(SMASH);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRA:
        jj_consume_token(LBRA);
        mathexpression_no_brackets();
        jj_consume_token(RBRA);
        break;
      default:
        jj_la1[155] = jj_gen;
        ;
      }
      exp = parameterexpression();
      break;
    case RAISETAG:
      jj_consume_token(RAISETAG);
      parameterexpression();
                                                    exp = new EmptyExpression();
      break;
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression underbrace() throws ParseException {
    Expression under, sub = null;
    MathExpression newexp;
    jj_consume_token(UNDERBRACE);
    under = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-begin", table));
                newexp.addChild(under);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-middle", table));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUB:
      jj_consume_token(SUB);
      sub = parameterexpression();
                newexp.addChild(sub);
                newexp.addChild(new SimpleExpression("\u005c\u005cunderbrace-end", table));
                newexp.addChild(new SimpleExpression(" ", table));
      break;
    default:
      jj_la1[157] = jj_gen;
      ;
    }
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overbrace() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(OVERBRACE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-begin", table));
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-middle", table));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUP:
      jj_consume_token(SUP);
      sup = parameterexpression();
                newexp.addChild(sup);
                newexp.addChild(new SimpleExpression("\u005c\u005coverbrace-end", table));
                newexp.addChild(new SimpleExpression(" ", table));
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression tilde() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(TILDE);
    over = parameterexpression();
        newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005ctilde", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression lenqno() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(LENQNO);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005clenqno", table));
                newexp.addChild(over);
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression bar() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(BAR);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cbar", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression check() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(CHECK);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005ccheck", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression acute() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(ACUTE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cacute", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression gravemath() throws ParseException {
    Expression over, sup = null;
    MathExpression newexp;
    jj_consume_token(GRAVE);
    over = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(over);
                newexp.addChild(new SimpleExpression("\u005c\u005cgrave", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression stackrel() throws ParseException {
    Expression exp1, exp2;
    MathExpression newexp;
    jj_consume_token(STACKREL);
    exp1 = parameterexpression();
    exp2 = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-begin", table));
                newexp.addChild(exp1);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-middle", table));
                newexp.addChild(exp2);
                newexp.addChild(new SimpleExpression("\u005c\u005cstackrel-end", table));
                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overset() throws ParseException {
    Expression over, base = null;
    jj_consume_token(OVERSET);
    over = parameterexpression();
    base = parameterexpression();
        {if (true) return createOverExp(base,over);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression underset() throws ParseException {
    Expression under, base = null;
    jj_consume_token(UNDERSET);
    under = parameterexpression();
    base = parameterexpression();
                {if (true) return createUnderExp(base,under);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression overunderset() throws ParseException {
    Expression under, over,base = null;
    jj_consume_token(OVERUNDERSET);
    over = parameterexpression();
    under = parameterexpression();
    base = parameterexpression();
        {if (true) return createOverUnderExp(base,under,over);}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression sidesetparam() throws ParseException {
   Expression ex = null;
   MathExpression exp = null;
   Expression insideExp = null;
    ex = mathexpression();
                exp = (MathExpression) ex;
        // replace prime...
                for (int i=0; i < exp.getNumberOfChildren(); i++) {
                  Expression e = exp.getChild(i);
                  if (e instanceof SimpleExpression) {
                                SimpleExpression se = (SimpleExpression) e;
                                if (se.getTokenString().equals("'")) {
                                  Sup supexp = new Sup(new EmptyExpression(),se,table);
                                  exp.replace(i,supexp);
                                }
                   }
                }
          {if (true) return exp;}
    throw new Error("Missing return statement in function");
  }

  final public MathExpression sideset() throws ParseException {
    Expression oper=null;
    Expression supsub = new EmptyExpression();
    Expression first = new EmptyExpression();
    Expression second = new EmptyExpression();
    MathExpression newexp;
    jj_consume_token(SIDESET);
    jj_consume_token(LCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case LIMITS:
    case NOLIMITS:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case LBRA:
    case RBRA:
    case COMMAND:
      first = sidesetparam();
      break;
    default:
      jj_la1[159] = jj_gen;
      ;
    }
    jj_consume_token(RCB);
    jj_consume_token(LCB);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEG:
    case DIGIT0:
    case DIGIT1:
    case PARAM:
    case ENGLISHLETTER:
    case TEXTSYMBOL:
    case GREEKLETTER:
    case DIPHTHONG:
    case LABEL:
    case OPERATORNAME:
    case OPERATORNAMESTAR:
    case MOD:
    case PMOD:
    case BMOD:
    case POD:
    case TEXTLATIN:
    case FRAC:
    case SQRT:
    case LEFT:
    case TEXTRM:
    case INTERTEXT:
    case SHORTINTERTEXT:
    case HBOX:
    case MBOX:
    case TILDE:
    case TEXTSC:
    case OVERLINE:
    case UNDERLINE:
    case DOT:
    case LENQNO:
    case HAT:
    case WIDEHAT:
    case VEC:
    case BAR:
    case STACKREL:
    case CHECK:
    case ACUTE:
    case GRAVE:
    case CASES:
    case BREVE:
    case DDOT:
    case MATHRING:
    case BINOM:
    case MATHBB:
    case MATHCAL:
    case UNDERBRACE:
    case OVERBRACE:
    case LIMITS:
    case NOLIMITS:
    case SIDESET:
    case MATHSYMBOL:
    case MATHTEXTSEPARATOR:
    case MATHSEPARATOR:
    case DELIMITERSIZEMODIFIER:
    case SUP:
    case SUB:
    case LCB:
    case OVERSET:
    case UNDERSET:
    case OVERUNDERSET:
    case OVERBAR:
    case OVHOOK:
    case OCIRC:
    case CANDRA:
    case OTURNEDCOMMA:
    case OCOMMATOPRIGHT:
    case DROANG:
    case LEFTHARPOONACCENT:
    case RIGHTHARPOONACCENT:
    case VERTOVERLAY:
    case DDDOT:
    case DDDDOT:
    case ANNUITY:
    case WIDEBRIDGEABOVE:
    case ASTERACCENT:
    case NOTACCENT:
    case WIDETILDE:
    case WIDEOVERBAR:
    case WIDEBREVE:
    case WIDECHECK:
    case OVERLEFTHARPOON:
    case OVERRIGHTHARPOON:
    case OVERLEFTARROW:
    case OVERRIGHTARROW:
    case OVERLEFTRIGHTARROW:
    case THREEUNDERDOT:
    case MATHUNDERBAR:
    case WIDEUTILDE:
    case UNDERLEFTRIGHTARROW:
    case UNDERRIGHTHARPOONDOWN:
    case UNDERLEFTHARPOONDOWN:
    case UNDERLEFTARROW:
    case UNDERRIGHTARROW:
    case LONGDIVISION:
    case OVERBRACKET:
    case OVERPAREN:
    case UNDERBRACKET:
    case UNDERPAREN:
    case XLEFTARROW:
    case XRIGHTARROW:
    case BOXED:
    case SMASH:
    case UPROOT:
    case LEFTROOT:
    case DISPLAYBREAK:
    case NUMBERWITHIN:
    case ALLOWDISPLAYBREAKS:
    case RAISETAG:
    case CUBEROOT:
    case FORTHROOT:
    case SUBSTACK:
    case CFRAC:
    case LBRA:
    case RBRA:
    case COMMAND:
      second = sidesetparam();
      break;
    default:
      jj_la1[160] = jj_gen;
      ;
    }
    jj_consume_token(RCB);
    //[second = supsub(new EmptyExpression())] <RCB>
                     oper = atomicmath();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMITS:
    case NOLIMITS:
    case SUP:
    case SUB:
      oper = supsub(oper);
      break;
    default:
      jj_la1[161] = jj_gen;
      ;
    }
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-begin", table));
                newexp.addChild(first);
                newexp.addChild(oper);
                newexp.addChild(second);
                newexp.addChild(new SimpleExpression("\u005c\u005cdot-end", table));
          {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public SimpleExpression modifiedMathDelimiter() throws ParseException {
    Token mod, del;
    SimpleExpression se;
    mod = jj_consume_token(DELIMITERSIZEMODIFIER);
    del = mathDelimiter();
        String str = mod.image + del.image;
        {if (true) return new SimpleExpression(str, table);}
    throw new Error("Missing return statement in function");
  }

  final public Expression variousCommandsAfter() throws ParseException {
   Token t = null; Expression exp = null;
   MathExpression newexp=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVERBAR:
      t = jj_consume_token(OVERBAR);
      break;
    case OVHOOK:
      t = jj_consume_token(OVHOOK);
      break;
    case OCIRC:
      t = jj_consume_token(OCIRC);
      break;
    case CANDRA:
      t = jj_consume_token(CANDRA);
      break;
    case OTURNEDCOMMA:
      t = jj_consume_token(OTURNEDCOMMA);
      break;
    case OCOMMATOPRIGHT:
      t = jj_consume_token(OCOMMATOPRIGHT);
      break;
    case DROANG:
      t = jj_consume_token(DROANG);
      break;
    case LEFTHARPOONACCENT:
      t = jj_consume_token(LEFTHARPOONACCENT);
      break;
    case RIGHTHARPOONACCENT:
      t = jj_consume_token(RIGHTHARPOONACCENT);
      break;
    case DDDOT:
      t = jj_consume_token(DDDOT);
      break;
    case DDDDOT:
      t = jj_consume_token(DDDDOT);
      break;
    case ANNUITY:
      jj_consume_token(ANNUITY);
      break;
    case WIDEBRIDGEABOVE:
      t = jj_consume_token(WIDEBRIDGEABOVE);
      break;
    case ASTERACCENT:
      t = jj_consume_token(ASTERACCENT);
      break;
    case WIDETILDE:
      t = jj_consume_token(WIDETILDE);
      break;
    case WIDEOVERBAR:
      t = jj_consume_token(WIDEOVERBAR);
      break;
    case WIDEBREVE:
      t = jj_consume_token(WIDEBREVE);
      break;
    case WIDECHECK:
      t = jj_consume_token(WIDECHECK);
      break;
    case OVERLEFTHARPOON:
      t = jj_consume_token(OVERLEFTHARPOON);
      break;
    case OVERRIGHTHARPOON:
      t = jj_consume_token(OVERRIGHTHARPOON);
      break;
    case OVERLEFTARROW:
      t = jj_consume_token(OVERLEFTARROW);
      break;
    case OVERRIGHTARROW:
      t = jj_consume_token(OVERRIGHTARROW);
      break;
    case OVERLEFTRIGHTARROW:
      t = jj_consume_token(OVERLEFTRIGHTARROW);
      break;
    case THREEUNDERDOT:
      t = jj_consume_token(THREEUNDERDOT);
      break;
    case MATHUNDERBAR:
      t = jj_consume_token(MATHUNDERBAR);
      break;
    case WIDEUTILDE:
      t = jj_consume_token(WIDEUTILDE);
      break;
    case UNDERLEFTRIGHTARROW:
      t = jj_consume_token(UNDERLEFTRIGHTARROW);
      break;
    case UNDERRIGHTHARPOONDOWN:
      t = jj_consume_token(UNDERRIGHTHARPOONDOWN);
      break;
    case UNDERLEFTHARPOONDOWN:
      t = jj_consume_token(UNDERLEFTHARPOONDOWN);
      break;
    case UNDERLEFTARROW:
      t = jj_consume_token(UNDERLEFTARROW);
      break;
    case UNDERRIGHTARROW:
      t = jj_consume_token(UNDERRIGHTARROW);
      break;
    case OVERBRACKET:
      t = jj_consume_token(OVERBRACKET);
      break;
    case OVERPAREN:
      t = jj_consume_token(OVERPAREN);
      break;
    case UNDERBRACKET:
      t = jj_consume_token(UNDERBRACKET);
      break;
    case UNDERPAREN:
      jj_consume_token(UNDERPAREN);
      break;
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(exp);
                newexp.addChild(new SimpleExpression(t.image,table));

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public Expression variousCommandsBefore() throws ParseException {
   Token t = null; Expression exp = null; MathExpression newexp = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VERTOVERLAY:
      t = jj_consume_token(VERTOVERLAY);
      break;
    case NOTACCENT:
      t = jj_consume_token(NOTACCENT);
      break;
    case LONGDIVISION:
      t = jj_consume_token(LONGDIVISION);
      break;
    default:
      jj_la1[163] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    exp = parameterexpression();
                newexp = new MathExpression(table);
                newexp.addChild(new SimpleExpression(t.image,table));
                newexp.addChild(exp);

                {if (true) return newexp;}
    throw new Error("Missing return statement in function");
  }

  final public Sqrt cuberoot() throws ParseException {
    Expression root;
    jj_consume_token(CUBEROOT);
    root = parameterexpression();
                {if (true) return new Sqrt(root, new SimpleExpression("3",table), table);}
    throw new Error("Missing return statement in function");
  }

  final public Sqrt forthroot() throws ParseException {
    Expression root;
    jj_consume_token(FORTHROOT);
    root = parameterexpression();
          {if (true) return new Sqrt(root, new SimpleExpression("4",table), table);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_3R_334() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    }
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(TWONEWLINES)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(7)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_204()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) return true;
    }
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_226()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_scan_token(UNDERLINE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_scan_token(TEXTCIRCLED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) return true;
    }
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_3R_216()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(AMPERSAND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_334()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_218()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(OVERLINE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) return true;
    }
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_264() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_292()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_293()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_251() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) return true;
    }
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_3R_230()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_3R_227()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_221()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) return true;
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_206()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_3R_339()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_3R_338()) return true;
    return false;
  }

  private boolean jj_3R_283() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) {
    jj_scanpos = xsp;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(VEC)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_283()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_259() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) return true;
    }
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_3R_50()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(TEXTBF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) return true;
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_369()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_61()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_363()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_363()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) return true;
    }
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_scan_token(REF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) return true;
    }
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_337()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_337()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(LABEL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    }
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(XRIGHTARROW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_281()) jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_3R_259()) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(XLEFTARROW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_280()) jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_247()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(INDEX)) return true;
    if (jj_3R_268()) return true;
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_246()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_328()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(POD)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(LIMITS)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(NOLIMITS)) return true;
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_3R_258()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_72()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    return false;
  }

  private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) return true;
    }
    if (jj_3R_239()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(PMOD)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_3R_257()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_251()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    if (jj_3R_239()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) return true;
    }
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_352() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) return true;
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_3R_256()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) return true;
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_250()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(NEWCOMMAND)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_scan_token(COMMAND)) return true;
    if (jj_scan_token(RCB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) jj_scanpos = xsp;
    if (jj_scan_token(LCB)) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(MATHRING)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_249()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_scan_token(DDOT)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_253()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_248()) return true;
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_3R_241()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_scan_token(BREVE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(MULTICOLUMN)) return true;
    if (jj_scan_token(LCB)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_scan_token(MATHCAL)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_185()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_181()) return true;
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(BEG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_scan_token(COMMAND)) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(MATHBB)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    }
    }
    }
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(PARAM)) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(HDOTSFOR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(TEXTLATIN)) return true;
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(LEFT)) return true;
    if (jj_3R_155()) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(RIGHT)) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(TEXTLATIN)) return true;
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(FORTHROOT)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(SQRT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_scan_token(CUBEROOT)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    }
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(CFRAC)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_234()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(FRAC)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_226() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) return true;
    }
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(127)) {
    jj_scanpos = xsp;
    if (jj_scan_token(128)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) return true;
    }
    if (jj_scan_token(LCB)) return true;
    if (jj_scan_token(COMMAND)) return true;
    if (jj_scan_token(RCB)) return true;
    if (jj_scan_token(LCB)) return true;
    return false;
  }

  private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(DELIMITERSIZEMODIFIER)) return true;
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_298()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_scan_token(SUBSTACK)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_294() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_3R_335()) return true;
    }
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_scan_token(VERB)) return true;
    return false;
  }

  private boolean jj_3R_267() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) return true;
    }
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_scan_token(SIDESET)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    if (jj_scan_token(RCB)) return true;
    if (jj_scan_token(LCB)) return true;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    if (jj_scan_token(RCB)) return true;
    if (jj_3R_85()) return true;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) return true;
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(PARAM)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) return true;
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_233()) jj_scanpos = xsp;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_340()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_scan_token(OVERUNDERSET)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_scan_token(195)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_267()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_scan_token(194)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_267()) return true;
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_151() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(UNDERSET)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_3R_261()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(ENGLISHLETTER)) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_scan_token(OVERSET)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_238() {
    Token xsp;
    if (jj_3R_285()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_285()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_264()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(STACKREL)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_156() {
    Token xsp;
    if (jj_3R_236()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_236()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(SPLIT)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_264()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_265()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(SPLIT)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_scan_token(GRAVE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_3R_309()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_180() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) return true;
    }
    if (jj_scan_token(ENVEND)) return true;
    if (jj_scan_token(LCB)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_260()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) return true;
    }
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_3R_303()) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_3R_304()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_scan_token(ACUTE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_156()) return true;
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_scan_token(CHECK)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_356()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(CR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_scan_token(CASES)) return true;
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_153()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_154()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_scan_token(BAR)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_366()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(VVMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(VVMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(LENQNO)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(SUBSECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(VMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(VMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_366()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_365()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(SECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    xsp = jj_scanpos;
    if (jj_3R_360()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(BBMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(BBMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(SUP)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(LCB)) return true;
    if (jj_3R_95()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_364()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(OVERBRACE)) return true;
    if (jj_3R_267()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_270()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(BMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(BMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(CHAPTER)) return true;
    if (jj_3R_268()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(PMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(PMATRIX)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(UNDERBRACE)) return true;
    if (jj_3R_267()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_269()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(GRAVEACCENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) return true;
    }
    return false;
  }

  private boolean jj_3R_181() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    }
    }
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_261()) return true;
    if (jj_scan_token(END)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) return true;
    }
    }
    }
    }
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(RAISETAG)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(SMASH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) jj_scanpos = xsp;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(ACCENT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) return true;
    }
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_scan_token(SUBEQUATIONS)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_156()) return true;
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(SUBEQUATIONS)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_scan_token(BEG)) return true;
    if (jj_scan_token(ENVNAME)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(LBRA)) return true;
    if (jj_3R_238()) return true;
    if (jj_scan_token(RBRA)) return true;
    return false;
  }

  private boolean jj_3R_277() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) return true;
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_3R_336()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(NUMBERWITHIN)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_3R_352()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_351()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_264()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_289()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_264()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) return true;
    }
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_229() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) {
    jj_scanpos = xsp;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_scan_token(INCLUDE)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_368()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_368()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(INPUT)) return true;
    if (jj_scan_token(LCB)) return true;
    Token xsp;
    if (jj_3R_367()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RCB)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) return true;
    }
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(CASESENV)) return true;
    if (jj_scan_token(ENVEND)) return true;
    if (jj_3R_262()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_263()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(END)) return true;
    if (jj_scan_token(CASESENV)) return true;
    if (jj_scan_token(ENVEND)) return true;
    return false;
  }

  private boolean jj_3R_338() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) return true;
    }
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(NEWLINE)) return true;
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) return true;
    }
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(BINOM)) return true;
    if (jj_3R_267()) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_220()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(LTNALLCAPS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    }
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_scan_token(AMPERSAND)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_205()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) {
    jj_scanpos = xsp;
    if (jj_3R_330()) return true;
    }
    return false;
  }

  private boolean jj_3R_262() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_290()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_291()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_3R_229()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_156()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public LatexTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[164];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x18000000,0x98000000,0x0,0x98000000,0x98000000,0x40000000,0x0,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0x0,0x98000000,0x98000000,0x98000000,0x98000000,0x0,0x0,0x0,0x98000000,0xd8000000,0xd8000000,0xd8000000,0xd8000000,0xd8000180,0xd8000180,0xd8000180,0xd8000180,0x80,0x80,0x80,0x98000000,0x98000000,0x0,0x98000000,0x40000080,0x98000000,0x98000000,0x0,0x98000000,0x40000080,0x100,0x98000080,0x98000080,0x98000080,0x98000080,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0xd8000000,0x0,0xd8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0x0,0x98000000,0x0,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0x0,0x98000000,0x98000000,0x98000000,0x98000000,0x0,0x0,0x0,0x0,0x0,0x0,0x98000000,0x98000000,0x98000000,0xd8000100,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0x98000000,0xfffe00,0xd8000100,0x98000000,0x0,0x0,0x0,0x0,0x0,0x0,0xd8000100,0x0,0x98000000,0x0,0xd8000100,0xd8000100,0x0,0xd8000100,0xd8000100,0xd8000100,0xd8000100,0x0,0xd8000100,0xd8000100,0x0,0x0,0x701800,0x701800,0x0,0xd8000100,0x600,0x80000000,0x600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd8000100,0xd8000100,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x1,0x0,0x7,0x7,0x207ff818,0x0,0x1,0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x6,0x6,0x0,0x0,0x800,0x7,0x207ff87f,0x207ff87f,0x207ff87f,0x207ff87f,0x607ff87f,0x607ff87f,0x607ff87f,0x607ff87f,0x0,0x0,0x0,0x1,0x1,0x0,0x1,0x207ffd18,0x1,0x1,0x0,0x1,0x207ffd18,0x40000000,0x7,0x7,0x67,0x67,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x207ff87f,0x0,0x207ff87f,0x0,0x0,0x0,0x0,0x40000000,0x80000000,0x40000000,0x60,0xa0,0x7,0x7,0x7,0x7,0x7,0x20000000,0x7,0x18000,0x7,0x7,0x7,0x7,0x7,0xc0000,0x7,0x7,0x7,0x7,0x800,0x0,0x800,0x0,0x800,0x800,0x7,0x7,0x7,0x1f800807,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x1f800807,0x1f800807,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800807,0x0,0x1f800807,0x1f800800,0x1f800807,0x1f800807,0x0,0x1f800807,0x1f800807,0x1f800807,0x1f800807,0x0,0x1f800807,0x1f800807,0x0,0x0,0x0,0x0,0x0,0x1f800807,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x600000,0x0,0x0,0x0,0xa000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f800807,0x1f800807,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc001e8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc001e8,0xc001e8,0xc001e8,0xc001e8,0xc001e9,0xc001e9,0xc001e9,0xc001e9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc001e8,0x0,0x0,0x0,0x0,0xc001e8,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x200,0x0,0x200,0xc005e8,0x400,0xc001e8,0x400,0x0,0x0,0x10,0x1,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffbf7008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffbf7008,0xffbf7008,0x0,0x0,0x0,0x0,0x0,0x0,0xffbf7008,0x0,0xffbf7008,0xffbf3008,0xffbf7008,0xffbf7008,0x0,0xffbf7008,0xffbf7008,0xffbf7008,0xffbf7008,0x0,0xffbf7008,0xffbf7008,0x0,0x0,0x0,0x0,0x0,0xffbf7008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1f0000,0x0,0x0,0x0,0x30000000,0x800000,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0xffbf7008,0xffbf7008,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x300000,0x300000,0x0,0x100000,0x0,0x100000,0x1100000,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x2100000,0x2100000,0x2100000,0x2100000,0x2100000,0x2100000,0x2100000,0x2100000,0x2100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x7b80000,0x7b80000,0x7b80000,0x7b80000,0x0,0x0,0x40,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x2100000,0x0,0x2100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1100000,0x3100000,0x1100000,0x3100000,0x2100000,0x0,0x2100000,0x0,0x2100000,0x2100000,0x2100000,0x1100000,0x1100000,0x0,0x1100000,0x3100000,0x1100000,0x3100000,0x0,0x0,0x0,0x0,0x0,0x0,0x380000,0x380000,0x380000,0xfbff7f9f,0x2380000,0x380000,0x2380000,0x380000,0x2380000,0x380000,0x2380000,0x0,0xfa7c7f9f,0xfa7c7f8f,0x30000,0x30000,0x1000000,0x800000,0x1800000,0x1830000,0xfbff7f9f,0x1830000,0xfbff7f8f,0xf8047f8f,0xfbffff9f,0xfbffff9f,0x0,0xfbffff9f,0xfbffff9f,0xfbffff9f,0xfbffff9f,0x0,0xfbffff9f,0xfbffff9f,0x0,0x0,0x0,0x0,0x20,0xfbff7f9f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x800000,0xfbff7f9f,0xfbff7f9f,0x1830000,0xc0000000,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x7fffdf7f,0x80002080,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0xc0000,0x0,0x0,0x0,0xc0000,0x800000,0x0,0x400000,0x40000,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x800000,0xc00000,0xc00000,0xcc0000,0xcc0000,0xffec0000,0xffec0000,0xffec0000,0xffec0000,0x0,0x200000,0x0,0x0,0x0,0x40000,0x0,0x400000,0x0,0x0,0x40000,0x0,0x400000,0xff000000,0x6c0000,0x6c0000,0x6c0000,0x6c0000,0x40000,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0xcc0000,0x100000,0xcc0000,0x100000,0x200000,0x200000,0x0,0x0,0x0,0xff000000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x800000,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x40000,0x0,0x0,0xc0000,0x0,0x4c0000,0x4fffff,0x4c0000,0x4c0000,0x4c0000,0x400000,0x400000,0x400000,0x400000,0x0,0x4fffff,0x43ffff,0x0,0x0,0x0,0x0,0x0,0x0,0x4fffff,0x0,0x43ffff,0x3ffff,0x4fffff,0x4fffff,0x100000,0x4fffff,0x4fffff,0x4fffff,0x4fffff,0x100000,0x4fffff,0x4fffff,0x200000,0x200000,0x0,0x0,0x0,0x4fffff,0x0,0x0,0x0,0x200000,0xff000000,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x40000,0x40000,0x0,0x40,0x1400,0x40000,0x300,0x40000,0x3fc0,0x0,0x0,0x4fffff,0x4fffff,0x0,0xf,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xf,0xf,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0xfff0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public Latex(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Latex(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new LatexTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Latex(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new LatexTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Latex(LatexTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(LatexTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 164; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[208];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 164; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 208; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 4; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
