/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.security.PublicKey;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSSEC;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.Options;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.utils.base64;

abstract class KEYBase
extends Record {
    protected int flags;
    protected int proto;
    protected int alg;
    protected byte[] key;
    protected int footprint = -1;
    protected PublicKey publicKey = null;

    protected KEYBase() {
    }

    public KEYBase(Name name, int type, int dclass, long ttl, int flags, int proto, int alg, byte[] key) {
        super(name, type, dclass, ttl);
        this.flags = KEYBase.checkU16("flags", flags);
        this.proto = KEYBase.checkU8("proto", proto);
        this.alg = KEYBase.checkU8("alg", alg);
        this.key = key;
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.flags = in.readU16();
        this.proto = in.readU8();
        this.alg = in.readU8();
        if (in.remaining() > 0) {
            this.key = in.readByteArray();
        }
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.flags);
        sb.append(" ");
        sb.append(this.proto);
        sb.append(" ");
        sb.append(this.alg);
        if (this.key != null) {
            if (Options.check("multiline")) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.key, 64, "\t", true));
                sb.append(" ; key_tag = ");
                sb.append(this.getFootprint());
            } else {
                sb.append(" ");
                sb.append(base64.toString(this.key));
            }
        }
        return sb.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProtocol() {
        return this.proto;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getFootprint() {
        if (this.footprint >= 0) {
            return this.footprint;
        }
        int foot = 0;
        DNSOutput out = new DNSOutput();
        this.rrToWire(out, null, false);
        byte[] rdata = out.toByteArray();
        if (this.alg == 1) {
            int d1 = rdata[rdata.length - 3] & 0xFF;
            int d2 = rdata[rdata.length - 2] & 0xFF;
            foot = (d1 << 8) + d2;
        } else {
            int d1;
            int i;
            for (i = 0; i < rdata.length - 1; i += 2) {
                d1 = rdata[i] & 0xFF;
                int d2 = rdata[i + 1] & 0xFF;
                foot += (d1 << 8) + d2;
            }
            if (i < rdata.length) {
                d1 = rdata[i] & 0xFF;
                foot += d1 << 8;
            }
            foot += foot >> 16 & 0xFFFF;
        }
        this.footprint = foot & 0xFFFF;
        return this.footprint;
    }

    public PublicKey getPublicKey() throws DNSSEC.DNSSECException {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = DNSSEC.toPublicKey(this);
        return this.publicKey;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.flags);
        out.writeU8(this.proto);
        out.writeU8(this.alg);
        if (this.key != null) {
            out.writeByteArray(this.key);
        }
    }
}

