/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#ifndef QtOAI_HTTPREQUESTWORKER_H
#define QtOAI_HTTPREQUESTWORKER_H

#include "QtOAICommonExports.h"
#include "QtOAIHttpFileElement.h"

#include <QtCore/qmap.h>
#include <QtCore/qstring.h>
#include <QtCore/QUrlQuery>

#include <QtNetwork/qhttpheaders.h>
#include <QtNetwork/qrestreply.h>

#include <memory>

QT_BEGIN_NAMESPACE
class QNetworkRequestFactory;
class QRestAccessManager;
class QHttpMultiPart;
QT_END_NAMESPACE

namespace QtCommonOpenAPI {

enum QtOAIHttpRequestVarLayout {
    NOT_SET,
    ADDRESS,
    URL_ENCODED,
    MULTIPART
};

class QtOAI_COMMON_EXPORT QtOAIHttpRequestInput {
public:
    QString m_urlStr;
    QString m_httpMethod;
    QtOAIHttpRequestVarLayout m_varLayout;
    QMap<QString, QString> m_vars;
    QMap<QString, QString> m_fieldHeaders;
    QHttpHeaders m_headers;
    QList<QtOAIHttpFileElement> m_files;
    QByteArray m_requestBody;
    QUrlQuery m_queryItem;
    std::unique_ptr<QHttpMultiPart> m_multiPart;
    bool m_isFormData;

    QtOAIHttpRequestInput();
    ~QtOAIHttpRequestInput();
    QtOAIHttpRequestInput(const QString &vUrlStr, const QString &vHttpMethod);
    QtOAIHttpRequestInput(QtOAIHttpRequestInput &other);
    void initialize();
    void addVar(const QString &key, const QString &value);
    void addFieldHeaders(const QString &key, const QString &value);
    void addFile(const QString &variableName, const QString &localFilename, const QString &mimeType);
    void addVarLayout(QtOAIHttpRequestVarLayout layout);
    void setHeaders(const QHttpHeaders &newHeaders);
    void setFormData(bool isForm);
};

namespace QtOAIHttpRequestWorker {
    QtOAI_COMMON_EXPORT QtOAIHttpFileElement getHttpFileElement(const QMap<QString, QtOAIHttpFileElement> &files, const QString &fieldname = QStringLiteral(""));
    QtOAI_COMMON_EXPORT QByteArray *getMultiPartField(const QMap<QString, QByteArray *> &multiPartFields, const QString &fieldname = QStringLiteral(""));
    QtOAI_COMMON_EXPORT QNetworkRequest getNetworkRequest(QtOAIHttpRequestInput &input, QByteArray &requestContent, std::shared_ptr<QNetworkRequestFactory> factory, bool responseCompressionEnabled, bool requestCompressionEnabled);
    QtOAI_COMMON_EXPORT QByteArray parseResponse(const QRestReply &reply, const QString &workDir, QMap<QString, QtOAIHttpFileElement> *files = nullptr);

    enum QtOAICompressionType{
        Deflate,
        Gzip,
        None,
    };
    QtOAI_COMMON_EXPORT QByteArray decompressData(const QByteArray &data, QtOAICompressionType compressionType);
    QtOAI_COMMON_EXPORT QByteArray compressData(const QByteArray &input, int level, QtOAICompressionType compressionType);
} // namespace QtOAIHttpRequestWorker

} // namespace QtCommonOpenAPI

#endif // QtOAI_HTTPREQUESTWORKER_H
