/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;

public abstract class IdeResourcesTestCase
extends LightPlatformTestCase {
    public void testTipFilesPresent() {
        TreeSet<String> errors2 = new TreeSet<String>();
        List tips = TipAndTrickBean.EP_NAME.getExtensionList();
        IdeResourcesTestCase.assertNotEmpty(tips);
        for (TipAndTrickBean tip : tips) {
            URL url = tip.getPluginDescriptor().getClassLoader().getResource("tips/" + tip.fileName);
            if (url != null) continue;
            errors2.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)(tips.size() + " tips are checked, the following files are missing:\n" + String.join((CharSequence)"\n", errors2)), (int)0, (int)errors2.size());
    }

    public void testTipFilesDuplicates() {
        TreeSet<String> errors2 = new TreeSet<String>();
        List tips = TipAndTrickBean.EP_NAME.getExtensionList();
        IdeResourcesTestCase.assertNotEmpty(tips);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        for (TipAndTrickBean tip : tips) {
            if (visited.add(tip.fileName)) continue;
            errors2.add(tip.fileName);
        }
        IdeResourcesTestCase.assertEquals((String)("The following tip files are registered more than once:\n" + StringUtil.join(errors2, (String)"\n")), (int)0, (int)errors2.size());
    }
}

