/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class Segment {
    private final double pos1;
    private final double pos2;

    public Segment(double pos1, double pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        if (pos2 < pos1) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object obj) {
        Segment this2 = (Segment)obj;
        return this.pos1 == this2.pos1 && this.pos2 == this2.pos2;
    }

    public int hashCode() {
        return Double.valueOf(this.pos1).hashCode() + Double.valueOf(this.pos2).hashCode();
    }

    public final boolean contains(double y) {
        return y >= this.pos1 && y <= this.pos2;
    }

    public final boolean contains(Segment other) {
        return this.contains(other.pos1) && this.contains(other.pos2);
    }

    public String toString() {
        return "" + this.pos1 + " - " + this.pos2;
    }

    public final double getLength() {
        return this.pos2 - this.pos1;
    }

    public final double getPos1() {
        return this.pos1;
    }

    public final double getPos2() {
        return this.pos2;
    }

    public Segment merge(Segment this2) {
        return new Segment(Math.min(this.pos1, this2.pos1), Math.max(this.pos2, this2.pos2));
    }

    public Collection<Segment> cutSegmentIfNeed(Collection<Segment> allDelays) {
        ArrayList<Segment> sortedDelay = new ArrayList<Segment>(allDelays);
        Collections.sort(sortedDelay, new SortPos1());
        ArrayList<Segment> result2 = new ArrayList<Segment>();
        double pendingStart = this.pos1;
        for (Segment pause : sortedDelay) {
            if (Math.abs(pause.pos1 - pendingStart) < 0.001) {
                pendingStart = pause.pos2;
                continue;
            }
            if (pause.pos1 < pendingStart) continue;
            if (pause.pos1 > this.pos2) {
                if (pendingStart < this.pos2) {
                    result2.add(new Segment(pendingStart, this.pos2));
                }
                return Collections.unmodifiableCollection(result2);
            }
            if (!this.contains(pause)) continue;
            assert (pendingStart < pause.pos1);
            result2.add(new Segment(pendingStart, pause.pos1));
            pendingStart = pause.pos2;
        }
        if (pendingStart < this.pos2) {
            result2.add(new Segment(pendingStart, this.pos2));
        }
        return Collections.unmodifiableCollection(result2);
    }

    static class SortPos1
    implements Comparator<Segment> {
        SortPos1() {
        }

        @Override
        public int compare(Segment segA, Segment segB) {
            return (int)Math.signum(segA.pos1 - segB.pos1);
        }
    }
}

