/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.picoweb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cli.CliOptions;
import net.sourceforge.plantuml.cli.CliParser;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.picoweb.BadRequest400;
import net.sourceforge.plantuml.picoweb.ReceivedHTTPRequest;
import net.sourceforge.plantuml.picoweb.RenderRequest;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.syntax.LanguageDescriptor;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.version.Version;

public class PicoWebServer
implements Runnable {
    private final Socket connect;
    private static boolean enableStop;

    public PicoWebServer(Socket c) {
        this.connect = c;
    }

    public static void main(String[] args) throws IOException {
        PicoWebServer.startServer(8080, null, false);
    }

    public static void startServer(int port, String bindAddress, boolean argEnableStop) throws IOException {
        enableStop = argEnableStop;
        InetAddress bindAddress1 = bindAddress == null ? null : InetAddress.getByName(bindAddress);
        ServerSocket serverConnect = new ServerSocket(port, 50, bindAddress1);
        System.err.println("webPort=" + serverConnect.getLocalPort());
        PicoWebServer.serverLoop(serverConnect);
    }

    public static void serverLoop(ServerSocket serverConnect) throws IOException {
        while (true) {
            PicoWebServer myServer = new PicoWebServer(serverConnect.accept());
            Thread thread = new Thread(myServer);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(this.connect.getInputStream());
            out = new BufferedOutputStream(this.connect.getOutputStream());
            ReceivedHTTPRequest request = ReceivedHTTPRequest.fromStream(in);
            if (request.getMethod().equals("GET")) {
                if (request.getPath().startsWith("/png/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.PNG)) {
                    return;
                }
                if (request.getPath().startsWith("/plantuml/png/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.PNG)) {
                    return;
                }
                if (request.getPath().startsWith("/svg/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.SVG)) {
                    return;
                }
                if (request.getPath().startsWith("/plantuml/svg/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.SVG)) {
                    return;
                }
                if (request.getPath().startsWith("/txt/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.ATXT)) {
                    return;
                }
                if (request.getPath().startsWith("/plantuml/txt/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.ATXT)) {
                    return;
                }
                if (request.getPath().startsWith("/utxt/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.UTXT)) {
                    return;
                }
                if (request.getPath().startsWith("/plantuml/utxt/") && this.handleGET(request, (BufferedOutputStream)out, FileFormat.UTXT)) {
                    return;
                }
                if (request.getPath().startsWith("/serverinfo") && this.handleInfo((BufferedOutputStream)out)) {
                    return;
                }
                if (request.getPath().startsWith("/plantuml/serverinfo") && this.handleInfo((BufferedOutputStream)out)) {
                    return;
                }
                if (request.getPath().startsWith("/language") && this.handleLanguage((BufferedOutputStream)out)) {
                    return;
                }
                if (enableStop && (request.getPath().startsWith("/stopserver") || request.getPath().startsWith("/plantuml/stopserver")) && this.handleStop((BufferedOutputStream)out)) {
                    return;
                }
            } else if (request.getMethod().equals("POST") && request.getPath().equals("/render")) {
                this.handleRenderRequest(request, (BufferedOutputStream)out);
                return;
            }
            this.write(out, "HTTP/1.1 302 Found");
            this.write(out, "Location: /plantuml/png/oqbDJyrBuGh8ISmh2VNrKGZ8JCuFJqqAJYqgIotY0aefG5G00000");
            this.write(out, "");
            ((BufferedOutputStream)out).flush();
        }
        catch (Throwable e) {
            try {
                this.sendError(e, (BufferedOutputStream)out);
            }
            catch (Throwable e1) {
                Logme.error(e);
            }
        }
        finally {
            try {
                in.close();
                out.close();
                this.connect.close();
            }
            catch (Throwable e) {
                Logme.error(e);
            }
        }
    }

    private boolean handleStop(BufferedOutputStream out) throws IOException {
        this.write(out, "HTTP/1.1 200");
        this.write(out, "Cache-Control: no-cache");
        this.write(out, "Server: PlantUML PicoWebServer " + Version.versionString());
        this.write(out, "Date: " + new Date());
        this.write(out, "");
        this.write(out, "<html>Stoping...</html>");
        out.flush();
        Thread stop = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        stop.start();
        return true;
    }

    private boolean handleInfo(BufferedOutputStream out) throws IOException {
        this.write(out, "HTTP/1.1 200");
        this.write(out, "Cache-Control: no-cache");
        this.write(out, "Server: PlantUML PicoWebServer " + Version.versionString());
        this.write(out, "Date: " + new Date());
        this.write(out, "Content-Type: application/json");
        this.write(out, "");
        JsonArray formats = new JsonArray();
        formats.add("png");
        formats.add("svg");
        formats.add("txt");
        JsonObject json = Json.object().add("version", Version.versionString()).add("PicoWebServer", true).add("formats", formats);
        this.write(out, json.toString());
        out.flush();
        return true;
    }

    private boolean handleLanguage(BufferedOutputStream out) throws IOException {
        this.write(out, "HTTP/1.1 200");
        this.write(out, "Cache-Control: no-cache");
        this.write(out, "Server: PlantUML PicoWebServer " + Version.versionString());
        this.write(out, "Date: " + new Date());
        this.write(out, "Content-Type: text/text");
        this.write(out, "");
        PrintStream ps = new PrintStream(out);
        new LanguageDescriptor().print(ps);
        out.flush();
        return true;
    }

    private boolean handleGET(ReceivedHTTPRequest request, BufferedOutputStream out, FileFormat format) throws IOException {
        int x = request.getPath().lastIndexOf(47);
        String compressed = request.getPath().substring(x + 1);
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoderProtected();
        String source = transcoder.decode(compressed);
        SourceStringReader ssr = new SourceStringReader(source);
        FileFormatOption fileFormatOption = new FileFormatOption(format);
        List<BlockUml> blocks = ssr.getBlocks();
        if (blocks.size() > 0) {
            Diagram system = blocks.get(0).getDiagram();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageData imageData = system.exportDiagram(os, 0, fileFormatOption);
            os.close();
            this.sendDiagram(out, system, fileFormatOption, this.httpReturnCode(imageData.getStatus()), imageData, os.toByteArray());
            return true;
        }
        return false;
    }

    private void handleRenderRequest(ReceivedHTTPRequest request, BufferedOutputStream out) throws Exception {
        RenderRequest renderRequest;
        if (request.getBody().length == 0) {
            throw new BadRequest400("No request body");
        }
        try {
            renderRequest = RenderRequest.fromJson(new String(request.getBody(), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new BadRequest400("Error parsing request json: " + e.getMessage(), e);
        }
        this.handleRenderRequest(renderRequest, out);
    }

    public void handleRenderRequest(RenderRequest renderRequest, BufferedOutputStream out) throws Exception {
        ImageData imageData;
        Diagram system;
        CliOptions option = CliParser.parse(renderRequest.getOptions());
        String source = renderRequest.getSource().startsWith("@start") ? renderRequest.getSource() : "@startuml\n" + renderRequest.getSource() + "\n@enduml";
        SFile newCurrentDir = option.getFileDir() == null ? null : new SFile(option.getFileDir());
        SourceStringReader ssr = new SourceStringReader(option.getDefaultDefines(), source, StandardCharsets.UTF_8, option.getConfig(), newCurrentDir);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (ssr.getBlocks().size() == 0) {
            system = PSystemErrorUtils.buildV2(null, new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "No valid @start/@end found, please check the version", 0, new LineLocationImpl("", null), null), null, Collections.emptyList(), new PreprocessingArtifact());
            imageData = ssr.noValidStartFound(os, option.getFileFormatOption());
        } else {
            system = ssr.getBlocks().get(0).getDiagram();
            imageData = system.exportDiagram(os, 0, option.getFileFormatOption());
        }
        this.sendDiagram(out, system, option.getFileFormatOption(), "200", imageData, os.toByteArray());
    }

    private void sendDiagram(BufferedOutputStream out, Diagram system, FileFormatOption fileFormatOption, String returnCode, ImageData imageData, byte[] fileData) throws IOException {
        String encode;
        this.write(out, "HTTP/1.1 " + returnCode);
        this.write(out, "Cache-Control: no-cache");
        this.write(out, "Server: PlantUML PicoWebServer " + Version.versionString());
        this.write(out, "Date: " + new Date());
        this.write(out, "Access-Control-Allow-Origin: *");
        this.write(out, "Content-type: " + fileFormatOption.getFileFormat().getMimeType());
        this.write(out, "Content-length: " + fileData.length);
        this.write(out, "X-PlantUML-Diagram-Width: " + imageData.getWidth());
        this.write(out, "X-PlantUML-Diagram-Height: " + imageData.getHeight());
        this.write(out, "X-PlantUML-Diagram-Description: " + system.getDescription().getDescription());
        if (system instanceof PSystemError) {
            PSystemError error = (PSystemError)system;
            for (ErrorUml err : error.getErrorsUml()) {
                this.write(out, "X-PlantUML-Diagram-Error: " + err.getError());
                this.write(out, "X-PlantUML-Diagram-Error-Line: " + (1 + err.getLineLocation().getPosition()));
            }
        }
        if (system.getTitleDisplay() != null && system.getTitleDisplay().size() == 1 && (encode = URLEncoder.encode(system.getTitleDisplay().asList().get(0).toString(), "UTF-8")).length() < 256) {
            this.write(out, "X-PlantUML-Diagram-Title: " + encode);
        }
        this.write(out, "X-Patreon: Support us on https://plantuml.com/patreon");
        this.write(out, "X-Donate: https://plantuml.com/paypal");
        this.write(out, "X-Quote: " + StringUtils.rot(QuoteUtils.getSomeQuote()));
        this.write(out, "");
        out.flush();
        out.write(fileData);
        out.flush();
    }

    private void sendError(Throwable e, BufferedOutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        if (e instanceof BadRequest400 && e.getCause() == null) {
            printWriter.write(e.getMessage());
        } else {
            e.printStackTrace(printWriter);
        }
        printWriter.close();
        this.write(out, "HTTP/1.1 " + (e instanceof BadRequest400 ? "400 Bad Request" : "500 Internal Server Error"));
        this.write(out, "Content-type: text/plain");
        this.write(out, "Content-length: " + baos.size());
        this.write(out, "");
        out.write(baos.toByteArray());
        out.flush();
    }

    private String httpReturnCode(int status) {
        if (status == 0 || status == 200) {
            return "200 OK";
        }
        return "" + status + " ERROR";
    }

    private void write(OutputStream os, String s) throws IOException {
        s = s + "\r\n";
        os.write(s.getBytes(StandardCharsets.UTF_8));
    }
}

