/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.math.BigInteger;

public class QBlock {
    private final BigInteger big;

    public static QBlock fromBuffer(byte[] buffer) {
        byte[] block = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, block, 1, buffer.length);
        BigInteger big = new BigInteger(block);
        return new QBlock(big);
    }

    public QBlock(BigInteger number) {
        this.big = number;
    }

    public QBlock change(BigInteger E, BigInteger N) {
        BigInteger changed = this.big.modPow(E, N);
        return new QBlock(changed);
    }

    public byte[] getData512() {
        byte[] nb = this.big.toByteArray();
        if (nb.length == 512) {
            return nb;
        }
        byte[] result = new byte[512];
        if (nb.length < 512) {
            System.arraycopy(nb, 0, result, 512 - nb.length, nb.length);
        } else {
            System.arraycopy(nb, nb.length - 512, result, 0, 512);
        }
        return result;
    }

    public byte[] getDataRaw() {
        return this.big.toByteArray();
    }

    public String toString() {
        return this.big.toByteArray().length + " " + this.big.toString(36);
    }
}

