/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.CaseMode;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.TextNavigator;

public class ChallengeSingleChar
implements Challenge {
    private final CaseMode mode = CaseMode.CASE_INSENSITIVE;
    private final char ch;

    public ChallengeSingleChar(char ch) {
        switch (ch) {
            case '\u2507': 
            case '\u3004': 
            case '\u3007': 
            case '\u300c': 
            case '\u300d': 
            case '\u3010': 
            case '\u3011': 
            case '\u3018': 
            case '\u3019': 
            case '\u301c': 
            case '\u3024': 
            case '\u3034': 
            case '\u3036': {
                throw new IllegalArgumentException();
            }
        }
        if (this.mode == CaseMode.CASE_INSENSITIVE) {
            ch = CaseMode.ensureLowercase(ch);
        }
        this.ch = ch;
    }

    public String toString() {
        return "[" + this.ch + "]";
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        if (string.length() == position) {
            return new ChallengeResult(Integer.MIN_VALUE);
        }
        char extract = string.charAt(position);
        if (this.mode == CaseMode.CASE_INSENSITIVE) {
            extract = CaseMode.ensureLowercase(extract);
        }
        if (extract == this.ch) {
            return new ChallengeResult(1);
        }
        return new ChallengeResult(Integer.MIN_VALUE);
    }
}

