/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SimpleQueryStringFlags;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SimpleQueryStringQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, SimpleQueryStringQuery> {
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final Operator defaultOperator;
    @Nonnull
    private final List<String> fields;
    @Nullable
    private final SimpleQueryStringFlags flags;
    @Nullable
    private final Integer fuzzyMaxExpansions;
    @Nullable
    private final Integer fuzzyPrefixLength;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final String minimumShouldMatch;
    @Nonnull
    private final String query;
    @Nullable
    private final String quoteFieldSuffix;
    public static final JsonpDeserializer<SimpleQueryStringQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimpleQueryStringQuery::setupSimpleQueryStringQueryDeserializer);

    private SimpleQueryStringQuery(Builder builder) {
        super(builder);
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.defaultOperator = builder.defaultOperator;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.flags = builder.flags;
        this.fuzzyMaxExpansions = builder.fuzzyMaxExpansions;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.quoteFieldSuffix = builder.quoteFieldSuffix;
    }

    public static SimpleQueryStringQuery of(Function<Builder, ObjectBuilder<SimpleQueryStringQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SimpleQueryString;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final SimpleQueryStringFlags flags() {
        return this.flags;
    }

    @Nullable
    public final Integer fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    @Nullable
    public final Integer fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Nullable
    public final Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nonnull
    public final String query() {
        return this.query;
    }

    @Nullable
    public final String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.flags != null) {
            generator.writeKey("flags");
            this.flags.serialize(generator, mapper);
        }
        if (this.fuzzyMaxExpansions != null) {
            generator.writeKey("fuzzy_max_expansions");
            generator.write(this.fuzzyMaxExpansions.intValue());
        }
        if (this.fuzzyPrefixLength != null) {
            generator.writeKey("fuzzy_prefix_length");
            generator.write(this.fuzzyPrefixLength.intValue());
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.quoteFieldSuffix != null) {
            generator.writeKey("quote_field_suffix");
            generator.write(this.quoteFieldSuffix);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSimpleQueryStringQueryDeserializer(ObjectDeserializer<Builder> op) {
        SimpleQueryStringQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard");
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::defaultOperator, Operator._DESERIALIZER, "default_operator");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::flags, SimpleQueryStringFlags._DESERIALIZER, "flags");
        op.add(Builder::fuzzyMaxExpansions, JsonpDeserializer.integerDeserializer(), "fuzzy_max_expansions");
        op.add(Builder::fuzzyPrefixLength, JsonpDeserializer.integerDeserializer(), "fuzzy_prefix_length");
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions");
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::quoteFieldSuffix, JsonpDeserializer.stringDeserializer(), "quote_field_suffix");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.analyzeWildcard);
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.autoGenerateSynonymsPhraseQuery);
        result = 31 * result + Objects.hashCode(this.defaultOperator);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.flags);
        result = 31 * result + Objects.hashCode(this.fuzzyMaxExpansions);
        result = 31 * result + Objects.hashCode(this.fuzzyPrefixLength);
        result = 31 * result + Objects.hashCode(this.fuzzyTranspositions);
        result = 31 * result + Objects.hashCode(this.lenient);
        result = 31 * result + Objects.hashCode(this.minimumShouldMatch);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.quoteFieldSuffix);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleQueryStringQuery other = (SimpleQueryStringQuery)o;
        return Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.fields, other.fields) && Objects.equals(this.flags, other.flags) && Objects.equals(this.fuzzyMaxExpansions, other.fuzzyMaxExpansions) && Objects.equals(this.fuzzyPrefixLength, other.fuzzyPrefixLength) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && this.query.equals(other.query) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SimpleQueryStringQuery> {
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private List<String> fields;
        @Nullable
        private SimpleQueryStringFlags flags;
        @Nullable
        private Integer fuzzyMaxExpansions;
        @Nullable
        private Integer fuzzyPrefixLength;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private String minimumShouldMatch;
        private String query;
        @Nullable
        private String quoteFieldSuffix;

        public Builder() {
        }

        private Builder(SimpleQueryStringQuery o) {
            super(o);
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.autoGenerateSynonymsPhraseQuery = o.autoGenerateSynonymsPhraseQuery;
            this.defaultOperator = o.defaultOperator;
            this.fields = Builder._listCopy(o.fields);
            this.flags = o.flags;
            this.fuzzyMaxExpansions = o.fuzzyMaxExpansions;
            this.fuzzyPrefixLength = o.fuzzyPrefixLength;
            this.fuzzyTranspositions = o.fuzzyTranspositions;
            this.lenient = o.lenient;
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.query = o.query;
            this.quoteFieldSuffix = o.quoteFieldSuffix;
        }

        private Builder(Builder o) {
            super(o);
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.autoGenerateSynonymsPhraseQuery = o.autoGenerateSynonymsPhraseQuery;
            this.defaultOperator = o.defaultOperator;
            this.fields = Builder._listCopy(o.fields);
            this.flags = o.flags;
            this.fuzzyMaxExpansions = o.fuzzyMaxExpansions;
            this.fuzzyPrefixLength = o.fuzzyPrefixLength;
            this.fuzzyTranspositions = o.fuzzyTranspositions;
            this.lenient = o.lenient;
            this.minimumShouldMatch = o.minimumShouldMatch;
            this.query = o.query;
            this.quoteFieldSuffix = o.quoteFieldSuffix;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        @Nonnull
        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder flags(@Nullable SimpleQueryStringFlags value) {
            this.flags = value;
            return this;
        }

        @Nonnull
        public final Builder flags(Function<SimpleQueryStringFlags.Builder, ObjectBuilder<SimpleQueryStringFlags>> fn) {
            return this.flags(fn.apply(new SimpleQueryStringFlags.Builder()).build());
        }

        @Nonnull
        public final Builder fuzzyMaxExpansions(@Nullable Integer value) {
            this.fuzzyMaxExpansions = value;
            return this;
        }

        @Nonnull
        public final Builder fuzzyPrefixLength(@Nullable Integer value) {
            this.fuzzyPrefixLength = value;
            return this;
        }

        @Nonnull
        public final Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        @Nonnull
        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        @Nonnull
        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        @Nonnull
        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder quoteFieldSuffix(@Nullable String value) {
            this.quoteFieldSuffix = value;
            return this;
        }

        @Override
        @Nonnull
        public SimpleQueryStringQuery build() {
            this._checkSingleUse();
            return new SimpleQueryStringQuery(this);
        }
    }
}

