/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.FieldType;
import com.oracle.labs.mlrg.olcut.config.PropertySheet;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.MapProvenance;
import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import com.oracle.labs.mlrg.olcut.provenance.primitives.BooleanProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.ByteProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.CharProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DoubleProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.EnumProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.FileProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.FloatProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.IntProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.LongProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.ShortProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.TimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.URLProvenance;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SkeletalConfiguredObjectProvenance
implements ConfiguredObjectProvenance {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SkeletalConfiguredObjectProvenance.class.getName());
    protected static final String HOST_SHORT_NAME = "host-short-name";
    protected final String className;
    protected final String hostShortName;
    protected final Map<String, Provenance> configuredParameters;

    protected <T extends Configurable> SkeletalConfiguredObjectProvenance(T host, String hostShortName) {
        this.className = host.getClass().getName();
        this.hostShortName = hostShortName;
        Map provMap = AccessController.doPrivileged(() -> SkeletalConfiguredObjectProvenance.getConfiguredFields(host));
        this.configuredParameters = Collections.unmodifiableMap(provMap);
    }

    protected SkeletalConfiguredObjectProvenance(ExtractedInfo info) {
        this.className = info.className;
        this.hostShortName = info.hostShortName;
        this.configuredParameters = Collections.unmodifiableMap(new HashMap<String, Provenance>(info.configuredParameters));
    }

    protected static <T extends Provenance> T checkAndExtractProvenance(ExtractedInfo info, String key, Class<T> type, String provClassName) throws ProvenanceException {
        Provenance tmp = info.instanceValues.get(key);
        if (tmp != null) {
            if (type.isInstance(tmp)) {
                return (T)tmp;
            }
            throw new ProvenanceException("Failed to cast " + key + " when constructing " + provClassName + ", found " + tmp);
        }
        throw new ProvenanceException("Failed to find " + key + " when constructing " + provClassName);
    }

    private static <T extends Configurable> Map<String, Provenance> getConfiguredFields(T host) {
        HashMap<String, Provenance> map = new HashMap<String, Provenance>();
        Class<?> hostClass = host.getClass();
        Set<Field> fields = PropertySheet.getAllFields(hostClass);
        try {
            for (Field f : fields) {
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                Config configAnnotation = f.getAnnotation(Config.class);
                if (configAnnotation != null && !configAnnotation.redact()) {
                    FieldType ft = FieldType.getFieldType(f);
                    if (ft == null) {
                        logger.log(Level.SEVERE, "Provenance and configuration not supported for field '" + f.getName() + "' of type '" + f.getType() + ", value not recorded.");
                    } else {
                        switch (ft) {
                            case BOOLEAN: 
                            case BYTE: 
                            case CHAR: 
                            case SHORT: 
                            case INTEGER: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case STRING: 
                            case FILE: 
                            case PATH: 
                            case URL: 
                            case DATE_TIME: 
                            case DATE: 
                            case TIME: 
                            case ENUM: 
                            case CONFIGURABLE: 
                            case ATOMIC_INTEGER: 
                            case ATOMIC_LONG: {
                                Optional<Provenance> opt = SkeletalConfiguredObjectProvenance.convertPrimitive(ft, f.getType(), f.getName(), f.get(host));
                                if (!opt.isPresent()) break;
                                map.put(f.getName(), opt.get());
                                break;
                            }
                            case BYTE_ARRAY: 
                            case CHAR_ARRAY: 
                            case SHORT_ARRAY: 
                            case INTEGER_ARRAY: 
                            case LONG_ARRAY: 
                            case FLOAT_ARRAY: 
                            case DOUBLE_ARRAY: 
                            case BOOLEAN_ARRAY: {
                                map.put(f.getName(), SkeletalConfiguredObjectProvenance.convertPrimitiveArray(ft, f, f.get(host)));
                                break;
                            }
                            case STRING_ARRAY: 
                            case CONFIGURABLE_ARRAY: {
                                map.put(f.getName(), SkeletalConfiguredObjectProvenance.convertObjectArray(ft, f, (Object[])f.get(host)));
                                break;
                            }
                            case LIST: 
                            case ENUM_SET: 
                            case SET: {
                                List<Class<?>> genericClasses = PropertySheet.getGenericClass(f);
                                if (genericClasses.size() != 1) {
                                    logger.log(Level.SEVERE, "Invalid configurable field definition, field not recorded - found too many or too few generic type parameters for field " + f.getName());
                                    break;
                                }
                                map.put(f.getName(), SkeletalConfiguredObjectProvenance.convertCollection(f, (Collection)f.get(host), genericClasses.get(0)));
                                break;
                            }
                            case MAP: {
                                List<Class<?>> genericClasses = PropertySheet.getGenericClass(f);
                                if (genericClasses.size() != 2) {
                                    logger.log(Level.SEVERE, "Invalid configurable field definition, field not recorded - found too many or too few generic type parameters for field " + f.getName());
                                    break;
                                }
                                map.put(f.getName(), SkeletalConfiguredObjectProvenance.convertMap(f, (Map)f.get(host), genericClasses.get(1)));
                                break;
                            }
                            default: {
                                logger.log(Level.SEVERE, "Automatic provenance not supported for field type " + (Object)((Object)ft) + ", field '" + f.getName() + "' not recorded.");
                            }
                        }
                    }
                }
                f.setAccessible(accessible);
            }
        }
        catch (ClassCastException e) {
            logger.log(Level.SEVERE, "Failed to cast field from host object " + host.toString() + ". Fields not recorded.", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Failed to access field in host object " + host.toString() + ". Fields not recorded.", e);
        }
        return map;
    }

    private static ListProvenance<?> convertPrimitiveArray(FieldType ft, Field f, Object object) {
        if (object == null) {
            return new ListProvenance();
        }
        String fieldName = f.getName();
        ArrayList<PrimitiveProvenance<Byte>> list = new ArrayList<PrimitiveProvenance<Byte>>();
        switch (ft) {
            case BYTE_ARRAY: {
                byte[] array;
                for (byte e : array = (byte[])object) {
                    list.add(new ByteProvenance(fieldName, e));
                }
                break;
            }
            case CHAR_ARRAY: {
                char[] array;
                for (char e : array = (char[])object) {
                    list.add(new CharProvenance(fieldName, e));
                }
                break;
            }
            case SHORT_ARRAY: {
                short[] array;
                for (short e : array = (short[])object) {
                    list.add(new ShortProvenance(fieldName, e));
                }
                break;
            }
            case INTEGER_ARRAY: {
                int[] array;
                for (int e : array = (int[])object) {
                    list.add(new IntProvenance(fieldName, e));
                }
                break;
            }
            case LONG_ARRAY: {
                long[] array;
                for (long e : array = (long[])object) {
                    list.add(new LongProvenance(fieldName, e));
                }
                break;
            }
            case FLOAT_ARRAY: {
                float[] array;
                for (float e : array = (float[])object) {
                    list.add(new FloatProvenance(fieldName, e));
                }
                break;
            }
            case DOUBLE_ARRAY: {
                double[] array;
                for (double e : array = (double[])object) {
                    list.add(new DoubleProvenance(fieldName, e));
                }
                break;
            }
            case BOOLEAN_ARRAY: {
                boolean[] array;
                for (boolean e : array = (boolean[])object) {
                    list.add(new BooleanProvenance(fieldName, e));
                }
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Automatic provenance not supported for field type " + (Object)((Object)ft) + ", field '" + f.getName() + "' not recorded.");
                return new ListProvenance();
            }
        }
        return new ListProvenance(list);
    }

    private static ListProvenance<?> convertObjectArray(FieldType ft, Field f, Object[] array) {
        if (array == null) {
            return new ListProvenance();
        }
        String fieldName = f.getName();
        switch (ft) {
            case STRING_ARRAY: {
                ArrayList<StringProvenance> sp = new ArrayList<StringProvenance>();
                for (Object o : array) {
                    String s = (String)o;
                    sp.add(new StringProvenance(fieldName, s));
                }
                return new ListProvenance(sp);
            }
            case CONFIGURABLE_ARRAY: {
                ArrayList<ConfiguredObjectProvenance> lp = new ArrayList<ConfiguredObjectProvenance>();
                for (Object o : array) {
                    if (o == null) {
                        lp.add(ConfiguredObjectProvenance.getEmptyProvenance(f.getType().getComponentType().getName()));
                        continue;
                    }
                    if (o instanceof Provenancable) {
                        Provenancable p = (Provenancable)o;
                        lp.add((ConfiguredObjectProvenance)p.getProvenance());
                        continue;
                    }
                    logger.log(Level.WARNING, "Automatic provenance generated for Configurable class, consider opting into provenance by implementing Provenancable on " + o.getClass().toString());
                    lp.add(new ConfiguredObjectProvenanceImpl((Configurable)o, fieldName));
                }
                return new ListProvenance(lp);
            }
        }
        logger.log(Level.SEVERE, "Automatic provenance not supported for field type " + (Object)((Object)ft) + ", field '" + f.getName() + "' not recorded.");
        return new ListProvenance();
    }

    private static ListProvenance<?> convertCollection(Field f, Collection collection, Class<?> genericType) {
        if (collection == null) {
            return new ListProvenance();
        }
        String fieldName = f.getName();
        FieldType genericFieldType = FieldType.getFieldType(genericType);
        ArrayList list = new ArrayList();
        for (Object o : collection) {
            Optional<Provenance> opt = SkeletalConfiguredObjectProvenance.convertPrimitive(genericFieldType, genericType, fieldName, o);
            opt.ifPresent(list::add);
        }
        return new ListProvenance(list);
    }

    private static MapProvenance<?> convertMap(Field f, Map<?, ?> inputMap, Class<?> genericType) {
        if (inputMap == null) {
            return new MapProvenance();
        }
        FieldType genericFieldType = FieldType.getFieldType(genericType);
        HashMap<String, Provenance> outputMap = new HashMap<String, Provenance>();
        for (Map.Entry<?, ?> e : inputMap.entrySet()) {
            String key = e.getKey().toString();
            Optional<Provenance> opt = SkeletalConfiguredObjectProvenance.convertPrimitive(genericFieldType, genericType, key, e.getValue());
            if (!opt.isPresent()) continue;
            outputMap.put(key, opt.get());
        }
        return new MapProvenance(outputMap);
    }

    private static Optional<Provenance> convertPrimitive(FieldType ft, Class<?> fieldClass, String fieldName, Object o) {
        switch (ft) {
            case BOOLEAN: {
                return Optional.of(new BooleanProvenance(fieldName, (Boolean)o));
            }
            case BYTE: {
                return Optional.of(new ByteProvenance(fieldName, (Byte)o));
            }
            case CHAR: {
                return Optional.of(new CharProvenance(fieldName, ((Character)o).charValue()));
            }
            case SHORT: {
                return Optional.of(new ShortProvenance(fieldName, (Short)o));
            }
            case INTEGER: {
                return Optional.of(new IntProvenance(fieldName, (Integer)o));
            }
            case LONG: {
                return Optional.of(new LongProvenance(fieldName, (Long)o));
            }
            case FLOAT: {
                return Optional.of(new FloatProvenance(fieldName, ((Float)o).floatValue()));
            }
            case DOUBLE: {
                return Optional.of(new DoubleProvenance(fieldName, (Double)o));
            }
            case STRING: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new StringProvenance(fieldName, (String)o));
            }
            case FILE: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new FileProvenance(fieldName, (File)o));
            }
            case PATH: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new FileProvenance(fieldName, (Path)o));
            }
            case URL: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new URLProvenance(fieldName, (URL)o));
            }
            case DATE_TIME: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new DateTimeProvenance(fieldName, (OffsetDateTime)o));
            }
            case DATE: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new DateProvenance(fieldName, (LocalDate)o));
            }
            case TIME: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new TimeProvenance(fieldName, (OffsetTime)o));
            }
            case ENUM: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new EnumProvenance<Enum>(fieldName, (Enum)o));
            }
            case CONFIGURABLE: {
                if (o == null) {
                    return Optional.of(ConfiguredObjectProvenance.getEmptyProvenance(fieldClass.getName()));
                }
                if (o instanceof Provenancable) {
                    return Optional.of(((Provenancable)o).getProvenance());
                }
                logger.log(Level.WARNING, "Automatic provenance generated for Configurable class, consider opting into provenance by implementing Provenancable on " + o.getClass().toString());
                return Optional.of(new ConfiguredObjectProvenanceImpl((Configurable)o, fieldName));
            }
            case ATOMIC_INTEGER: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new IntProvenance(fieldName, ((AtomicInteger)o).get()));
            }
            case ATOMIC_LONG: {
                if (o == null) {
                    return Optional.empty();
                }
                return Optional.of(new LongProvenance(fieldName, ((AtomicLong)o).get()));
            }
            case RANDOM: {
                logger.log(Level.SEVERE, "Random is deprecated and not supported in the provenance system, field '" + fieldName + "' not recorded.");
                return Optional.empty();
            }
        }
        logger.log(Level.SEVERE, "Automatic provenance not supported for nested field type " + (Object)((Object)ft) + ", field '" + fieldName + "' not recorded.");
        return Optional.empty();
    }

    @Override
    public Map<String, PrimitiveProvenance<?>> getInstanceValues() {
        HashMap output = new HashMap();
        output.put(HOST_SHORT_NAME, new StringProvenance(HOST_SHORT_NAME, this.hostShortName));
        return output;
    }

    @Override
    public Map<String, Provenance> getConfiguredParameters() {
        return this.configuredParameters;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return this.generateString(this.hostShortName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkeletalConfiguredObjectProvenance)) {
            return false;
        }
        SkeletalConfiguredObjectProvenance pairs = (SkeletalConfiguredObjectProvenance)o;
        return this.className.equals(pairs.className) && this.hostShortName.equals(pairs.hostShortName) && this.configuredParameters.equals(pairs.configuredParameters);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.hostShortName, this.configuredParameters);
    }

    protected static class ExtractedInfo {
        public final String className;
        public final String hostShortName;
        public final Map<String, Provenance> configuredParameters;
        public final Map<String, PrimitiveProvenance<?>> instanceValues;

        public ExtractedInfo(String className, String hostShortName, Map<String, Provenance> configuredParameters, Map<String, PrimitiveProvenance<?>> instanceValues) {
            this.className = className;
            this.hostShortName = hostShortName;
            this.configuredParameters = configuredParameters;
            this.instanceValues = instanceValues;
        }
    }
}

