/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.cancellation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.WorkloadGroupTask;
import org.opensearch.wlm.cancellation.TaskSelectionStrategy;

public class MaximumResourceTaskSelectionStrategy
implements TaskSelectionStrategy {
    private Comparator<WorkloadGroupTask> sortingCondition(ResourceType resourceType) {
        return Comparator.comparingDouble(task -> resourceType.getResourceUsageCalculator().calculateTaskResourceUsage((WorkloadGroupTask)task));
    }

    @Override
    public List<WorkloadGroupTask> selectTasksForCancellation(List<WorkloadGroupTask> tasks, double limit, ResourceType resourceType) {
        if (limit < 0.0) {
            throw new IllegalArgumentException("limit has to be greater than zero");
        }
        if (limit < 1.0E-9) {
            return Collections.emptyList();
        }
        List sortedTasks = tasks.stream().sorted(this.sortingCondition(resourceType).reversed()).collect(Collectors.toList());
        ArrayList<WorkloadGroupTask> selectedTasks = new ArrayList<WorkloadGroupTask>();
        double accumulated = 0.0;
        for (WorkloadGroupTask task : sortedTasks) {
            selectedTasks.add(task);
            if (!((accumulated += resourceType.getResourceUsageCalculator().calculateTaskResourceUsage(task)) - limit > 1.0E-9)) continue;
            break;
        }
        return selectedTasks;
    }
}

