/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geometry.utils;

import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.utils.GeometryValidator;

public class GeographyValidator
implements GeometryValidator {
    private static final double MIN_LON_INCL = -180.0;
    private static final double MAX_LON_INCL = 180.0;
    private static final double MIN_LAT_INCL = -90.0;
    private static final double MAX_LAT_INCL = 90.0;
    private final boolean ignoreZValue;

    public GeographyValidator(boolean ignoreZValue) {
        this.ignoreZValue = ignoreZValue;
    }

    protected void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between -90.0 and 90.0");
        }
    }

    protected void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between -180.0 and 180.0");
        }
    }

    protected void checkAltitude(double zValue) {
        if (!this.ignoreZValue && !Double.isNaN(zValue)) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + this.ignoreZValue + "]");
        }
    }

    @Override
    public void validate(Geometry geometry) {
        geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

            @Override
            public Void visit(Circle circle) throws RuntimeException {
                GeographyValidator.this.checkLatitude(circle.getY());
                GeographyValidator.this.checkLongitude(circle.getX());
                GeographyValidator.this.checkAltitude(circle.getZ());
                return null;
            }

            @Override
            public Void visit(GeometryCollection<?> collection) throws RuntimeException {
                for (Geometry g : collection) {
                    g.visit(this);
                }
                return null;
            }

            @Override
            public Void visit(Line line) throws RuntimeException {
                for (int i = 0; i < line.length(); ++i) {
                    GeographyValidator.this.checkLatitude(line.getY(i));
                    GeographyValidator.this.checkLongitude(line.getX(i));
                    GeographyValidator.this.checkAltitude(line.getZ(i));
                }
                return null;
            }

            @Override
            public Void visit(LinearRing ring) throws RuntimeException {
                for (int i = 0; i < ring.length(); ++i) {
                    GeographyValidator.this.checkLatitude(ring.getY(i));
                    GeographyValidator.this.checkLongitude(ring.getX(i));
                    GeographyValidator.this.checkAltitude(ring.getZ(i));
                }
                return null;
            }

            @Override
            public Void visit(MultiLine multiLine) throws RuntimeException {
                return this.visit((GeometryCollection)multiLine);
            }

            @Override
            public Void visit(MultiPoint multiPoint) throws RuntimeException {
                return this.visit((GeometryCollection)multiPoint);
            }

            @Override
            public Void visit(MultiPolygon multiPolygon) throws RuntimeException {
                return this.visit((GeometryCollection)multiPolygon);
            }

            @Override
            public Void visit(Point point) throws RuntimeException {
                GeographyValidator.this.checkLatitude(point.getY());
                GeographyValidator.this.checkLongitude(point.getX());
                GeographyValidator.this.checkAltitude(point.getZ());
                return null;
            }

            @Override
            public Void visit(Polygon polygon) throws RuntimeException {
                polygon.getPolygon().visit(this);
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    polygon.getHole(i).visit(this);
                }
                return null;
            }

            @Override
            public Void visit(Rectangle rectangle) throws RuntimeException {
                GeographyValidator.this.checkLatitude(rectangle.getMinY());
                GeographyValidator.this.checkLatitude(rectangle.getMaxY());
                GeographyValidator.this.checkLongitude(rectangle.getMinX());
                GeographyValidator.this.checkLongitude(rectangle.getMaxX());
                GeographyValidator.this.checkAltitude(rectangle.getMinZ());
                GeographyValidator.this.checkAltitude(rectangle.getMaxZ());
                return null;
            }
        });
    }
}

