/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.aggregation;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.profile.AbstractProfiler;
import org.opensearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.opensearch.search.profile.aggregation.InternalAggregationProfileTree;

@PublicApi(since="1.0.0")
public class AggregationProfiler
extends AbstractProfiler<AggregationProfileBreakdown, Aggregator> {
    private final Map<Aggregator, AggregationProfileBreakdown> profileBreakdownLookup = new HashMap<Aggregator, AggregationProfileBreakdown>();

    public AggregationProfiler() {
        super(new InternalAggregationProfileTree());
    }

    @Override
    public AggregationProfileBreakdown getQueryBreakdown(Aggregator agg) {
        AggregationProfileBreakdown aggregationProfileBreakdown = this.profileBreakdownLookup.get(agg);
        if (aggregationProfileBreakdown == null) {
            aggregationProfileBreakdown = (AggregationProfileBreakdown)super.getQueryBreakdown(agg);
            this.profileBreakdownLookup.put(agg, aggregationProfileBreakdown);
        }
        return aggregationProfileBreakdown;
    }
}

