/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.lookup.SourceLookup;

public interface FetchSubPhase {
    public FetchSubPhaseProcessor getProcessor(FetchContext var1) throws IOException;

    public static class HitContext {
        private final SearchHit hit;
        private final LeafReaderContext readerContext;
        private final int docId;
        private final SourceLookup sourceLookup;

        public HitContext(SearchHit hit, LeafReaderContext context, int docId, SourceLookup sourceLookup) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.sourceLookup = sourceLookup;
            sourceLookup.setSegmentAndDocument(context, docId);
        }

        public SearchHit hit() {
            return this.hit;
        }

        public LeafReader reader() {
            return this.readerContext.reader();
        }

        public LeafReaderContext readerContext() {
            return this.readerContext;
        }

        public int docId() {
            return this.docId;
        }

        public SourceLookup sourceLookup() {
            return this.sourceLookup;
        }

        public IndexReader topLevelReader() {
            return ReaderUtil.getTopLevelContext((IndexReaderContext)this.readerContext).reader();
        }
    }
}

