/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Iterator;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.AbstractUpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class UpdateRowsCoordinatorOneToMany
extends AbstractUpdateRowsCoordinator {
    private final RowMutationOperations rowMutationOperations;
    private MutationOperationGroup deleteOperationGroup;
    private MutationOperationGroup insertOperationGroup;

    public UpdateRowsCoordinatorOneToMany(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations, SessionFactoryImplementor sessionFactory) {
        super(mutationTarget, sessionFactory);
        this.rowMutationOperations = rowMutationOperations;
    }

    @Override
    protected int doUpdate(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        if (this.rowMutationOperations.hasDeleteRow()) {
            this.deleteRows(key, collection, session);
        }
        if (this.rowMutationOperations.hasInsertRow()) {
            return this.insertRows(key, collection, session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        Iterator<?> entries = collection.entries(collectionDescriptor);
        if (!entries.hasNext()) {
            return;
        }
        MutationOperationGroup operationGroup = this.resolveDeleteGroup();
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-DELETE"), operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            int entryPosition = -1;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                Object entryToUpdate = collection.getSnapshotElement(entry, entryPosition);
                this.rowMutationOperations.getDeleteRowRestrictions().applyRestrictions(collection, key, entryToUpdate, entryPosition, session, jdbcValueBindings);
                mutationExecutor.execute(entryToUpdate, null, null, null, session);
            }
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroup resolveDeleteGroup() {
        if (this.deleteOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getDeleteRowOperation();
            assert (operation != null);
            this.deleteOperationGroup = MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.getMutationTarget(), operation);
        }
        return this.deleteOperationGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertRows(Object key, PersistentCollection<?> collection, SharedSessionContractImplementor session) {
        PluralAttributeMapping attributeMapping = this.getMutationTarget().getTargetPart();
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        Iterator<?> entries = collection.entries(collectionDescriptor);
        if (!entries.hasNext()) {
            return -1;
        }
        MutationOperationGroup operationGroup = this.resolveInsertGroup();
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getMutationTarget().getRolePath() + "#UPDATE-INSERT"), operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            int entryPosition = -1;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (!collection.needsUpdating(entry, ++entryPosition, attributeMapping)) continue;
                this.rowMutationOperations.getInsertRowValues().applyValues(collection, key, entry, entryPosition, session, jdbcValueBindings);
                mutationExecutor.execute(entry, null, null, null, session);
            }
            int n = entryPosition;
            return n;
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroup resolveInsertGroup() {
        if (this.insertOperationGroup == null) {
            JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
            assert (operation != null);
            this.insertOperationGroup = MutationOperationGroupFactory.singleOperation(MutationType.INSERT, this.getMutationTarget(), operation);
        }
        return this.insertOperationGroup;
    }
}

