/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.server.multipart.FileItem;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataInput;

public final class FormData
implements Iterable<String> {
    private static final Logger log = Logger.getLogger(FormData.class);
    private final Map<String, Deque<FormValue>> values = new LinkedHashMap<String, Deque<FormValue>>();
    private final int maxValues;
    private int valueCount = 0;

    public FormData(int maxValues) {
        this.maxValues = maxValues;
    }

    public MultipartFormDataInput toMultipartFormDataInput() {
        return new MultipartFormDataInput(){

            @Override
            public Map<String, Collection<FormValue>> getValues() {
                LinkedHashMap<String, Collection<FormValue>> result = new LinkedHashMap<String, Collection<FormValue>>(FormData.this.values);
                return result;
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.keySet().iterator();
    }

    public FormValue getFirst(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekFirst();
    }

    public FormValue getLast(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekLast();
    }

    public Deque<FormValue> get(String name) {
        return this.values.get(name);
    }

    public void add(String name, byte[] value, String fileName, CaseInsensitiveMap<String> headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, fileName, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException("Param limit of " + this.maxValues + " was exceeded");
        }
    }

    public void add(String name, String value) {
        this.add(name, value, null, null);
    }

    public void add(String name, String value, CaseInsensitiveMap<String> headers) {
        this.add(name, value, null, headers);
    }

    public void add(String name, String value, String charset, CaseInsensitiveMap<String> headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, charset, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException("Param limit of " + this.maxValues + " was exceeded");
        }
    }

    public void add(String name, Path value, String fileName, CaseInsensitiveMap<String> headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, fileName, headers));
        if (values.size() > this.maxValues) {
            throw new RuntimeException("Param limit of " + this.maxValues + " was exceeded");
        }
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException("Param limit of " + this.maxValues + " was exceeded");
        }
    }

    public void put(String name, String value, CaseInsensitiveMap<String> headers) {
        ArrayDeque<FormValueImpl> values = new ArrayDeque<FormValueImpl>(1);
        Deque old = this.values.put(name, values);
        if (old != null) {
            this.valueCount -= old.size();
        }
        values.add(new FormValueImpl(value, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException("Param limit of " + this.maxValues + " was exceeded");
        }
    }

    public Deque<FormValue> remove(String name) {
        Deque<FormValue> old = this.values.remove(name);
        if (old != null) {
            this.valueCount -= old.size();
        }
        return old;
    }

    public boolean contains(String name) {
        Deque<FormValue> value = this.values.get(name);
        return value != null && !value.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormData strings = (FormData)o;
        return !(this.values != null ? !this.values.equals(strings.values) : strings.values != null);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }

    public String toString() {
        return "FormData{values=" + String.valueOf(this.values) + "}";
    }

    public void deleteFiles() {
        for (Deque<FormValue> i : this.values.values()) {
            for (FormValue j : i) {
                if (!j.isFileItem() || j.getFileItem().isInMemory()) continue;
                try {
                    Files.deleteIfExists(j.getFileItem().getFile());
                }
                catch (IOException e) {
                    log.error((Object)("Cannot remove uploaded file " + String.valueOf(j.getFileItem().getFile())), (Throwable)e);
                }
            }
        }
    }

    static class FormValueImpl
    implements FormValue {
        private final String value;
        private final String fileName;
        private final CaseInsensitiveMap<String> headers;
        private final FileItemImpl fileItemImpl;
        private final String charset;

        FormValueImpl(String value, CaseInsensitiveMap<String> headers) {
            this.value = value;
            this.headers = headers;
            this.fileName = null;
            this.fileItemImpl = null;
            this.charset = null;
        }

        FormValueImpl(String value, String charset, CaseInsensitiveMap<String> headers) {
            this.value = value;
            this.charset = charset;
            this.headers = headers;
            this.fileName = null;
            this.fileItemImpl = null;
        }

        FormValueImpl(Path file, String fileName, CaseInsensitiveMap<String> headers) {
            this.fileItemImpl = new FileItemImpl(file);
            this.headers = headers;
            this.fileName = fileName;
            this.value = null;
            this.charset = null;
        }

        FormValueImpl(byte[] data, String fileName, CaseInsensitiveMap<String> headers) {
            this.fileItemImpl = new FileItemImpl(data);
            this.fileName = fileName;
            this.headers = headers;
            this.value = null;
            this.charset = null;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                throw new RuntimeException("Form value is a file");
            }
            return this.value;
        }

        @Override
        public String getCharset() {
            return this.charset;
        }

        @Override
        public FileItemImpl getFileItem() {
            if (this.fileItemImpl == null) {
                throw new RuntimeException("Form value is a string");
            }
            return this.fileItemImpl;
        }

        @Override
        public boolean isFileItem() {
            return this.fileItemImpl != null;
        }

        public CaseInsensitiveMap<String> getHeaders() {
            return this.headers;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    public static class FileItemImpl
    implements FileItem {
        private final Path file;
        private final byte[] content;

        public FileItemImpl(Path file) {
            this.file = file;
            this.content = null;
        }

        public FileItemImpl(byte[] content) {
            this.file = null;
            this.content = content;
        }

        @Override
        public boolean isInMemory() {
            return this.file == null;
        }

        @Override
        public Path getFile() {
            return this.file;
        }

        @Override
        public long getFileSize() throws IOException {
            if (this.isInMemory()) {
                return this.content.length;
            }
            return Files.size(this.file);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.file != null) {
                return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));
            }
            return new ByteArrayInputStream(this.content);
        }

        @Override
        public void delete() throws IOException {
            if (this.file != null) {
                try {
                    Files.delete(this.file);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void write(Path target) throws IOException {
            if (this.file != null) {
                try {
                    Files.move(this.file, target, new CopyOption[0]);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try (InputStream is = this.getInputStream();){
                Files.copy(is, target, new CopyOption[0]);
            }
        }
    }
}

