/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface WaitableProcessHandle
extends ProcessHandle {
    public Path command();

    public List<String> arguments();

    public int waitFor() throws InterruptedException;

    default public int waitUninterruptiblyFor() {
        boolean intr = false;
        while (true) {
            try {
                int n = this.waitFor();
                return n;
            }
            catch (InterruptedException ignored) {
                intr = true;
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean waitFor(long var1, TimeUnit var3) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean waitUninterruptiblyFor(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            return !this.isAlive();
        }
        long start = System.nanoTime();
        boolean intr = false;
        try {
            long elapsed;
            for (long nanos = unit.toNanos(timeout); nanos > 0L; nanos -= elapsed) {
                try {
                    if (this.waitFor(nanos, TimeUnit.NANOSECONDS)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (InterruptedException e) {
                    intr = true;
                }
                long l = -start;
                start = System.nanoTime();
                elapsed = l + start;
            }
            boolean bl = !this.isAlive();
            return bl;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int exitValue();
}

