/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupDescribeResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DescribedGroup> groups;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", new CompactArrayOf(DescribedGroup.SCHEMA_0), "Each described group."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupDescribeResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public StreamsGroupDescribeResponseData() {
        this.throttleTimeMs = 0;
        this.groups = new ArrayList<DescribedGroup>(0);
    }

    @Override
    public short apiKey() {
        return 89;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field groups was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<DescribedGroup> newCollection = new ArrayList<DescribedGroup>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribedGroup(_readable, _version));
        }
        this.groups = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.groups.size() + 1);
        for (DescribedGroup groupsElement : this.groups) {
            groupsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groups.size() + 1));
        for (DescribedGroup groupsElement : this.groups) {
            groupsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupDescribeResponseData)) {
            return false;
        }
        StreamsGroupDescribeResponseData other = (StreamsGroupDescribeResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    @Override
    public StreamsGroupDescribeResponseData duplicate() {
        StreamsGroupDescribeResponseData _duplicate = new StreamsGroupDescribeResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribedGroup> newGroups = new ArrayList<DescribedGroup>(this.groups.size());
        for (DescribedGroup _element : this.groups) {
            newGroups.add(_element.duplicate());
        }
        _duplicate.groups = newGroups;
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupDescribeResponseData(throttleTimeMs=" + this.throttleTimeMs + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribedGroup> groups() {
        return this.groups;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupDescribeResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public StreamsGroupDescribeResponseData setGroups(List<DescribedGroup> v) {
        this.groups = v;
        return this;
    }

    public static class DescribedGroup
    implements Message {
        short errorCode;
        String errorMessage;
        String groupId;
        String groupState;
        int groupEpoch;
        int assignmentEpoch;
        Topology topology;
        List<Member> members;
        int authorizedOperations;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The describe error, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("group_id", Type.COMPACT_STRING, "The group ID string."), new Field("group_state", Type.COMPACT_STRING, "The group state string, or the empty string."), new Field("group_epoch", Type.INT32, "The group epoch."), new Field("assignment_epoch", Type.INT32, "The assignment epoch."), new Field("topology", Topology.SCHEMA_0, "The topology metadata currently initialized for the streams application. Can be null in case of a describe error."), new Field("members", new CompactArrayOf(Member.SCHEMA_0), "The members."), new Field("authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this group."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public DescribedGroup(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedGroup() {
            this.errorCode = 0;
            this.errorMessage = null;
            this.groupId = "";
            this.groupState = "";
            this.groupEpoch = 0;
            this.assignmentEpoch = 0;
            this.topology = null;
            this.members = new ArrayList<Member>(0);
            this.authorizedOperations = Integer.MIN_VALUE;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroup");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupState had invalid length " + length);
            }
            this.groupState = _readable.readString(length);
            this.groupEpoch = _readable.readInt();
            this.assignmentEpoch = _readable.readInt();
            this.topology = _readable.readByte() < 0 ? null : new Topology(_readable, _version);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Member> newCollection = new ArrayList<Member>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new Member(_readable, _version));
            }
            this.members = newCollection;
            this.authorizedOperations = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.groupState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.groupEpoch);
            _writable.writeInt(this.assignmentEpoch);
            if (this.topology == null) {
                _writable.writeByte((byte)-1);
            } else {
                _writable.writeByte((byte)1);
                this.topology.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.members.size() + 1);
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                Member membersElement = (Member)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
            _writable.writeInt(this.authorizedOperations);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedGroup");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.groupState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(4);
            if (this.topology == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(1);
                this.topology.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1));
            for (Member membersElement : this.members) {
                membersElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroup)) {
                return false;
            }
            DescribedGroup other = (DescribedGroup)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.groupState == null ? other.groupState != null : !this.groupState.equals(other.groupState)) {
                return false;
            }
            if (this.groupEpoch != other.groupEpoch) {
                return false;
            }
            if (this.assignmentEpoch != other.assignmentEpoch) {
                return false;
            }
            if (this.topology == null ? other.topology != null : !this.topology.equals(other.topology)) {
                return false;
            }
            if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
                return false;
            }
            if (this.authorizedOperations != other.authorizedOperations) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.groupState == null ? 0 : this.groupState.hashCode());
            hashCode = 31 * hashCode + this.groupEpoch;
            hashCode = 31 * hashCode + this.assignmentEpoch;
            hashCode = 31 * hashCode + (this.topology == null ? 0 : this.topology.hashCode());
            hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
            hashCode = 31 * hashCode + this.authorizedOperations;
            return hashCode;
        }

        @Override
        public DescribedGroup duplicate() {
            DescribedGroup _duplicate = new DescribedGroup();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.groupId = this.groupId;
            _duplicate.groupState = this.groupState;
            _duplicate.groupEpoch = this.groupEpoch;
            _duplicate.assignmentEpoch = this.assignmentEpoch;
            _duplicate.topology = this.topology == null ? null : this.topology.duplicate();
            ArrayList<Member> newMembers = new ArrayList<Member>(this.members.size());
            for (Member _element : this.members) {
                newMembers.add(_element.duplicate());
            }
            _duplicate.members = newMembers;
            _duplicate.authorizedOperations = this.authorizedOperations;
            return _duplicate;
        }

        public String toString() {
            return "DescribedGroup(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", groupState=" + (String)(this.groupState == null ? "null" : "'" + this.groupState.toString() + "'") + ", groupEpoch=" + this.groupEpoch + ", assignmentEpoch=" + this.assignmentEpoch + ", topology=" + (this.topology == null ? "null" : this.topology.toString()) + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ", authorizedOperations=" + this.authorizedOperations + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String groupId() {
            return this.groupId;
        }

        public String groupState() {
            return this.groupState;
        }

        public int groupEpoch() {
            return this.groupEpoch;
        }

        public int assignmentEpoch() {
            return this.assignmentEpoch;
        }

        public Topology topology() {
            return this.topology;
        }

        public List<Member> members() {
            return this.members;
        }

        public int authorizedOperations() {
            return this.authorizedOperations;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedGroup setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribedGroup setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DescribedGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DescribedGroup setGroupState(String v) {
            this.groupState = v;
            return this;
        }

        public DescribedGroup setGroupEpoch(int v) {
            this.groupEpoch = v;
            return this;
        }

        public DescribedGroup setAssignmentEpoch(int v) {
            this.assignmentEpoch = v;
            return this;
        }

        public DescribedGroup setTopology(Topology v) {
            this.topology = v;
            return this;
        }

        public DescribedGroup setMembers(List<Member> v) {
            this.members = v;
            return this;
        }

        public DescribedGroup setAuthorizedOperations(int v) {
            this.authorizedOperations = v;
            return this;
        }
    }

    public static class TopicInfo
    implements Message {
        String name;
        int partitions;
        short replicationFactor;
        List<KeyValue> topicConfigs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic."), new Field("partitions", Type.INT32, "The number of partitions in the topic. Can be 0 if no specific number of partitions is enforced. Always 0 for changelog topics."), new Field("replication_factor", Type.INT16, "The replication factor of the topic. Can be 0 if the default replication factor should be used."), new Field("topic_configs", new CompactArrayOf(KeyValue.SCHEMA_0), "Topic-level configurations as key-value pairs."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicInfo(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicInfo() {
            this.name = "";
            this.partitions = 0;
            this.replicationFactor = 0;
            this.topicConfigs = new ArrayList<KeyValue>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.partitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicConfigs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<KeyValue> newCollection = new ArrayList<KeyValue>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new KeyValue(_readable, _version));
            }
            this.topicConfigs = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions);
            _writable.writeShort(this.replicationFactor);
            _writable.writeUnsignedVarint(this.topicConfigs.size() + 1);
            _stringBytes = this.topicConfigs.iterator();
            while (_stringBytes.hasNext()) {
                KeyValue topicConfigsElement = (KeyValue)_stringBytes.next();
                topicConfigsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicConfigs.size() + 1));
            for (KeyValue topicConfigsElement : this.topicConfigs) {
                topicConfigsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicInfo)) {
                return false;
            }
            TopicInfo other = (TopicInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions != other.partitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.topicConfigs == null ? other.topicConfigs != null : !this.topicConfigs.equals(other.topicConfigs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.partitions;
            hashCode = 31 * hashCode + this.replicationFactor;
            hashCode = 31 * hashCode + (this.topicConfigs == null ? 0 : this.topicConfigs.hashCode());
            return hashCode;
        }

        @Override
        public TopicInfo duplicate() {
            TopicInfo _duplicate = new TopicInfo();
            _duplicate.name = this.name;
            _duplicate.partitions = this.partitions;
            _duplicate.replicationFactor = this.replicationFactor;
            ArrayList<KeyValue> newTopicConfigs = new ArrayList<KeyValue>(this.topicConfigs.size());
            for (KeyValue _element : this.topicConfigs) {
                newTopicConfigs.add(_element.duplicate());
            }
            _duplicate.topicConfigs = newTopicConfigs;
            return _duplicate;
        }

        public String toString() {
            return "TopicInfo(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + this.partitions + ", replicationFactor=" + this.replicationFactor + ", topicConfigs=" + MessageUtil.deepToString(this.topicConfigs.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int partitions() {
            return this.partitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public List<KeyValue> topicConfigs() {
            return this.topicConfigs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicInfo setName(String v) {
            this.name = v;
            return this;
        }

        public TopicInfo setPartitions(int v) {
            this.partitions = v;
            return this;
        }

        public TopicInfo setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public TopicInfo setTopicConfigs(List<KeyValue> v) {
            this.topicConfigs = v;
            return this;
        }
    }

    public static class TaskOffset
    implements Message {
        String subtopologyId;
        int partition;
        long offset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."), new Field("partition", Type.INT32, "The partition."), new Field("offset", Type.INT64, "The offset."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskOffset(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskOffset() {
            this.subtopologyId = "";
            this.partition = 0;
            this.offset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            this.partition = _readable.readInt();
            this.offset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partition);
            _writable.writeLong(this.offset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskOffset)) {
                return false;
            }
            TaskOffset other = (TaskOffset)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        @Override
        public TaskOffset duplicate() {
            TaskOffset _duplicate = new TaskOffset();
            _duplicate.subtopologyId = this.subtopologyId;
            _duplicate.partition = this.partition;
            _duplicate.offset = this.offset;
            return _duplicate;
        }

        public String toString() {
            return "TaskOffset(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partition=" + this.partition + ", offset=" + this.offset + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public int partition() {
            return this.partition;
        }

        public long offset() {
            return this.offset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskOffset setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskOffset setPartition(int v) {
            this.partition = v;
            return this;
        }

        public TaskOffset setOffset(long v) {
            this.offset = v;
            return this;
        }
    }

    public static class TaskIds
    implements Message {
        String subtopologyId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions of the input topics processed by this member."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskIds(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TaskIds() {
            this.subtopologyId = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskIds)) {
                return false;
            }
            TaskIds other = (TaskIds)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TaskIds duplicate() {
            TaskIds _duplicate = new TaskIds();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TaskIds(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskIds setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskIds setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class KeyValue
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.COMPACT_STRING, "key of the config"), new Field("value", Type.COMPACT_STRING, "value of the config"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public KeyValue(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public KeyValue() {
            this.key = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public KeyValue duplicate() {
            KeyValue _duplicate = new KeyValue();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "KeyValue(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public KeyValue setKey(String v) {
            this.key = v;
            return this;
        }

        public KeyValue setValue(String v) {
            this.value = v;
            return this;
        }
    }

    public static class Endpoint
    implements Message {
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("host", Type.COMPACT_STRING, "host of the endpoint"), new Field("port", Type.UINT16, "port of the endpoint"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Endpoint(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Endpoint() {
            this.host = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        @Override
        public Endpoint duplicate() {
            Endpoint _duplicate = new Endpoint();
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Endpoint(host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Endpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public Endpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }
    }

    public static class Assignment
    implements Message {
        List<TaskIds> activeTasks;
        List<TaskIds> standbyTasks;
        List<TaskIds> warmupTasks;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("active_tasks", new CompactArrayOf(TaskIds.SCHEMA_0), "Active tasks for this client."), new Field("standby_tasks", new CompactArrayOf(TaskIds.SCHEMA_0), "Standby tasks for this client."), new Field("warmup_tasks", new CompactArrayOf(TaskIds.SCHEMA_0), "Warm-up tasks for this client. "), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Assignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Assignment() {
            this.activeTasks = new ArrayList<TaskIds>(0);
            this.standbyTasks = new ArrayList<TaskIds>(0);
            this.warmupTasks = new ArrayList<TaskIds>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int i;
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field activeTasks was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TaskIds> newCollection = new ArrayList<TaskIds>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version));
            }
            this.activeTasks = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field standbyTasks was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version));
            }
            this.standbyTasks = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field warmupTasks was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version));
            }
            this.warmupTasks = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.activeTasks.size() + 1);
            for (TaskIds activeTasksElement : this.activeTasks) {
                activeTasksElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.standbyTasks.size() + 1);
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.warmupTasks.size() + 1);
            for (TaskIds warmupTasksElement : this.warmupTasks) {
                warmupTasksElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.activeTasks.size() + 1));
            for (TaskIds activeTasksElement : this.activeTasks) {
                activeTasksElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.standbyTasks.size() + 1));
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.warmupTasks.size() + 1));
            for (TaskIds warmupTasksElement : this.warmupTasks) {
                warmupTasksElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)obj;
            if (this.activeTasks == null ? other.activeTasks != null : !this.activeTasks.equals(other.activeTasks)) {
                return false;
            }
            if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
                return false;
            }
            if (this.warmupTasks == null ? other.warmupTasks != null : !this.warmupTasks.equals(other.warmupTasks)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.activeTasks == null ? 0 : this.activeTasks.hashCode());
            hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
            hashCode = 31 * hashCode + (this.warmupTasks == null ? 0 : this.warmupTasks.hashCode());
            return hashCode;
        }

        @Override
        public Assignment duplicate() {
            Assignment _duplicate = new Assignment();
            ArrayList<TaskIds> newActiveTasks = new ArrayList<TaskIds>(this.activeTasks.size());
            for (TaskIds taskIds : this.activeTasks) {
                newActiveTasks.add(taskIds.duplicate());
            }
            _duplicate.activeTasks = newActiveTasks;
            ArrayList<TaskIds> newStandbyTasks = new ArrayList<TaskIds>(this.standbyTasks.size());
            for (TaskIds _element : this.standbyTasks) {
                newStandbyTasks.add(_element.duplicate());
            }
            _duplicate.standbyTasks = newStandbyTasks;
            ArrayList<TaskIds> arrayList = new ArrayList<TaskIds>(this.warmupTasks.size());
            for (TaskIds _element : this.warmupTasks) {
                arrayList.add(_element.duplicate());
            }
            _duplicate.warmupTasks = arrayList;
            return _duplicate;
        }

        public String toString() {
            return "Assignment(activeTasks=" + MessageUtil.deepToString(this.activeTasks.iterator()) + ", standbyTasks=" + MessageUtil.deepToString(this.standbyTasks.iterator()) + ", warmupTasks=" + MessageUtil.deepToString(this.warmupTasks.iterator()) + ")";
        }

        public List<TaskIds> activeTasks() {
            return this.activeTasks;
        }

        public List<TaskIds> standbyTasks() {
            return this.standbyTasks;
        }

        public List<TaskIds> warmupTasks() {
            return this.warmupTasks;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Assignment setActiveTasks(List<TaskIds> v) {
            this.activeTasks = v;
            return this;
        }

        public Assignment setStandbyTasks(List<TaskIds> v) {
            this.standbyTasks = v;
            return this;
        }

        public Assignment setWarmupTasks(List<TaskIds> v) {
            this.warmupTasks = v;
            return this;
        }
    }

    public static class Member
    implements Message {
        String memberId;
        int memberEpoch;
        String instanceId;
        String rackId;
        String clientId;
        String clientHost;
        int topologyEpoch;
        String processId;
        Endpoint userEndpoint;
        List<KeyValue> clientTags;
        List<TaskOffset> taskOffsets;
        List<TaskOffset> taskEndOffsets;
        Assignment assignment;
        Assignment targetAssignment;
        boolean isClassic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The member ID."), new Field("member_epoch", Type.INT32, "The member epoch."), new Field("instance_id", Type.COMPACT_NULLABLE_STRING, "The member instance ID for static membership."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "The rack ID."), new Field("client_id", Type.COMPACT_STRING, "The client ID."), new Field("client_host", Type.COMPACT_STRING, "The client host."), new Field("topology_epoch", Type.INT32, "The epoch of the topology on the client."), new Field("process_id", Type.COMPACT_STRING, "Identity of the streams instance that may have multiple clients. "), new Field("user_endpoint", Endpoint.SCHEMA_0, "User-defined endpoint for Interactive Queries. Null if not defined for this client."), new Field("client_tags", new CompactArrayOf(KeyValue.SCHEMA_0), "Used for rack-aware assignment algorithm."), new Field("task_offsets", new CompactArrayOf(TaskOffset.SCHEMA_0), "Cumulative changelog offsets for tasks."), new Field("task_end_offsets", new CompactArrayOf(TaskOffset.SCHEMA_0), "Cumulative changelog end offsets for tasks."), new Field("assignment", Assignment.SCHEMA_0, "The current assignment."), new Field("target_assignment", Assignment.SCHEMA_0, "The target assignment."), new Field("is_classic", Type.BOOLEAN, "True for classic members that have not been upgraded yet."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Member(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Member() {
            this.memberId = "";
            this.memberEpoch = 0;
            this.instanceId = null;
            this.rackId = null;
            this.clientId = "";
            this.clientHost = "";
            this.topologyEpoch = 0;
            this.processId = "";
            this.userEndpoint = null;
            this.clientTags = new ArrayList<KeyValue>(0);
            this.taskOffsets = new ArrayList<TaskOffset>(0);
            this.taskEndOffsets = new ArrayList<TaskOffset>(0);
            this.assignment = new Assignment();
            this.targetAssignment = new Assignment();
            this.isClassic = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Member");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            this.memberEpoch = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.instanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field instanceId had invalid length " + length);
                }
                this.instanceId = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rackId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field rackId had invalid length " + length);
                }
                this.rackId = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            }
            this.clientHost = _readable.readString(length);
            this.topologyEpoch = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field processId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field processId had invalid length " + length);
            }
            this.processId = _readable.readString(length);
            this.userEndpoint = _readable.readByte() < 0 ? null : new Endpoint(_readable, _version);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field clientTags was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<KeyValue> newCollection = new ArrayList<KeyValue>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new KeyValue(_readable, _version));
            }
            this.clientTags = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field taskOffsets was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((KeyValue)((Object)new TaskOffset(_readable, _version)));
            }
            this.taskOffsets = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field taskEndOffsets was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((KeyValue)((Object)new TaskOffset(_readable, _version)));
            }
            this.taskEndOffsets = newCollection;
            this.assignment = new Assignment(_readable, _version);
            this.targetAssignment = new Assignment(_readable, _version);
            this.isClassic = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.memberEpoch);
            if (this.instanceId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.instanceId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (this.rackId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.rackId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.clientId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.clientHost);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.topologyEpoch);
            _stringBytes = _cache.getSerializedValue(this.processId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.userEndpoint == null) {
                _writable.writeByte((byte)-1);
            } else {
                _writable.writeByte((byte)1);
                this.userEndpoint.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.clientTags.size() + 1);
            _stringBytes = this.clientTags.iterator();
            while (_stringBytes.hasNext()) {
                KeyValue clientTagsElement = (KeyValue)_stringBytes.next();
                clientTagsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.taskOffsets.size() + 1);
            for (TaskOffset taskOffsetsElement : this.taskOffsets) {
                taskOffsetsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.taskEndOffsets.size() + 1);
            for (TaskOffset taskEndOffsetsElement : this.taskEndOffsets) {
                taskEndOffsetsElement.write(_writable, _cache, _version);
            }
            this.assignment.write(_writable, _cache, _version);
            this.targetAssignment.write(_writable, _cache, _version);
            _writable.writeByte(this.isClassic ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Member");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            if (this.instanceId == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.instanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'instanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.instanceId, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this.rackId == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'rackId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.rackId, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientHost, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _stringBytes = this.processId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'processId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.processId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.userEndpoint == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(1);
                this.userEndpoint.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clientTags.size() + 1));
            for (KeyValue clientTagsElement : this.clientTags) {
                clientTagsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.taskOffsets.size() + 1));
            for (TaskOffset taskOffsetsElement : this.taskOffsets) {
                taskOffsetsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.taskEndOffsets.size() + 1));
            for (TaskOffset taskEndOffsetsElement : this.taskEndOffsets) {
                taskEndOffsetsElement.addSize(_size, _cache, _version);
            }
            this.assignment.addSize(_size, _cache, _version);
            this.targetAssignment.addSize(_size, _cache, _version);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Member)) {
                return false;
            }
            Member other = (Member)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.memberEpoch != other.memberEpoch) {
                return false;
            }
            if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
                return false;
            }
            if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (this.topologyEpoch != other.topologyEpoch) {
                return false;
            }
            if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
                return false;
            }
            if (this.userEndpoint == null ? other.userEndpoint != null : !this.userEndpoint.equals(other.userEndpoint)) {
                return false;
            }
            if (this.clientTags == null ? other.clientTags != null : !this.clientTags.equals(other.clientTags)) {
                return false;
            }
            if (this.taskOffsets == null ? other.taskOffsets != null : !this.taskOffsets.equals(other.taskOffsets)) {
                return false;
            }
            if (this.taskEndOffsets == null ? other.taskEndOffsets != null : !this.taskEndOffsets.equals(other.taskEndOffsets)) {
                return false;
            }
            if (this.assignment == null ? other.assignment != null : !this.assignment.equals(other.assignment)) {
                return false;
            }
            if (this.targetAssignment == null ? other.targetAssignment != null : !this.targetAssignment.equals(other.targetAssignment)) {
                return false;
            }
            if (this.isClassic != other.isClassic) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + this.memberEpoch;
            hashCode = 31 * hashCode + (this.instanceId == null ? 0 : this.instanceId.hashCode());
            hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + this.topologyEpoch;
            hashCode = 31 * hashCode + (this.processId == null ? 0 : this.processId.hashCode());
            hashCode = 31 * hashCode + (this.userEndpoint == null ? 0 : this.userEndpoint.hashCode());
            hashCode = 31 * hashCode + (this.clientTags == null ? 0 : this.clientTags.hashCode());
            hashCode = 31 * hashCode + (this.taskOffsets == null ? 0 : this.taskOffsets.hashCode());
            hashCode = 31 * hashCode + (this.taskEndOffsets == null ? 0 : this.taskEndOffsets.hashCode());
            hashCode = 31 * hashCode + (this.assignment == null ? 0 : this.assignment.hashCode());
            hashCode = 31 * hashCode + (this.targetAssignment == null ? 0 : this.targetAssignment.hashCode());
            hashCode = 31 * hashCode + (this.isClassic ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public Member duplicate() {
            Member _duplicate = new Member();
            _duplicate.memberId = this.memberId;
            _duplicate.memberEpoch = this.memberEpoch;
            _duplicate.instanceId = this.instanceId == null ? null : this.instanceId;
            _duplicate.rackId = this.rackId == null ? null : this.rackId;
            _duplicate.clientId = this.clientId;
            _duplicate.clientHost = this.clientHost;
            _duplicate.topologyEpoch = this.topologyEpoch;
            _duplicate.processId = this.processId;
            _duplicate.userEndpoint = this.userEndpoint == null ? null : this.userEndpoint.duplicate();
            ArrayList<KeyValue> newClientTags = new ArrayList<KeyValue>(this.clientTags.size());
            for (KeyValue keyValue : this.clientTags) {
                newClientTags.add(keyValue.duplicate());
            }
            _duplicate.clientTags = newClientTags;
            ArrayList<TaskOffset> newTaskOffsets = new ArrayList<TaskOffset>(this.taskOffsets.size());
            for (TaskOffset _element : this.taskOffsets) {
                newTaskOffsets.add(_element.duplicate());
            }
            _duplicate.taskOffsets = newTaskOffsets;
            ArrayList<TaskOffset> arrayList = new ArrayList<TaskOffset>(this.taskEndOffsets.size());
            for (TaskOffset _element : this.taskEndOffsets) {
                arrayList.add(_element.duplicate());
            }
            _duplicate.taskEndOffsets = arrayList;
            _duplicate.assignment = this.assignment.duplicate();
            _duplicate.targetAssignment = this.targetAssignment.duplicate();
            _duplicate.isClassic = this.isClassic;
            return _duplicate;
        }

        public String toString() {
            return "Member(memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", instanceId=" + (String)(this.instanceId == null ? "null" : "'" + this.instanceId.toString() + "'") + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", clientId=" + (String)(this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (String)(this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", topologyEpoch=" + this.topologyEpoch + ", processId=" + (String)(this.processId == null ? "null" : "'" + this.processId.toString() + "'") + ", userEndpoint=" + (this.userEndpoint == null ? "null" : this.userEndpoint.toString()) + ", clientTags=" + MessageUtil.deepToString(this.clientTags.iterator()) + ", taskOffsets=" + MessageUtil.deepToString(this.taskOffsets.iterator()) + ", taskEndOffsets=" + MessageUtil.deepToString(this.taskEndOffsets.iterator()) + ", assignment=" + this.assignment.toString() + ", targetAssignment=" + this.targetAssignment.toString() + ", isClassic=" + (this.isClassic ? "true" : "false") + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public int memberEpoch() {
            return this.memberEpoch;
        }

        public String instanceId() {
            return this.instanceId;
        }

        public String rackId() {
            return this.rackId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public int topologyEpoch() {
            return this.topologyEpoch;
        }

        public String processId() {
            return this.processId;
        }

        public Endpoint userEndpoint() {
            return this.userEndpoint;
        }

        public List<KeyValue> clientTags() {
            return this.clientTags;
        }

        public List<TaskOffset> taskOffsets() {
            return this.taskOffsets;
        }

        public List<TaskOffset> taskEndOffsets() {
            return this.taskEndOffsets;
        }

        public Assignment assignment() {
            return this.assignment;
        }

        public Assignment targetAssignment() {
            return this.targetAssignment;
        }

        public boolean isClassic() {
            return this.isClassic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Member setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public Member setMemberEpoch(int v) {
            this.memberEpoch = v;
            return this;
        }

        public Member setInstanceId(String v) {
            this.instanceId = v;
            return this;
        }

        public Member setRackId(String v) {
            this.rackId = v;
            return this;
        }

        public Member setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public Member setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public Member setTopologyEpoch(int v) {
            this.topologyEpoch = v;
            return this;
        }

        public Member setProcessId(String v) {
            this.processId = v;
            return this;
        }

        public Member setUserEndpoint(Endpoint v) {
            this.userEndpoint = v;
            return this;
        }

        public Member setClientTags(List<KeyValue> v) {
            this.clientTags = v;
            return this;
        }

        public Member setTaskOffsets(List<TaskOffset> v) {
            this.taskOffsets = v;
            return this;
        }

        public Member setTaskEndOffsets(List<TaskOffset> v) {
            this.taskEndOffsets = v;
            return this;
        }

        public Member setAssignment(Assignment v) {
            this.assignment = v;
            return this;
        }

        public Member setTargetAssignment(Assignment v) {
            this.targetAssignment = v;
            return this;
        }

        public Member setIsClassic(boolean v) {
            this.isClassic = v;
            return this;
        }
    }

    public static class Subtopology
    implements Message {
        String subtopologyId;
        List<String> sourceTopics;
        List<String> repartitionSinkTopics;
        List<TopicInfo> stateChangelogTopics;
        List<TopicInfo> repartitionSourceTopics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "String to uniquely identify the subtopology."), new Field("source_topics", new CompactArrayOf(Type.COMPACT_STRING), "The topics the subtopology reads from."), new Field("repartition_sink_topics", new CompactArrayOf(Type.COMPACT_STRING), "The repartition topics the subtopology writes to."), new Field("state_changelog_topics", new CompactArrayOf(TopicInfo.SCHEMA_0), "The set of state changelog topics associated with this subtopology. Created automatically."), new Field("repartition_source_topics", new CompactArrayOf(TopicInfo.SCHEMA_0), "The set of source topics that are internally created repartition topics. Created automatically."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Subtopology(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Subtopology() {
            this.subtopologyId = "";
            this.sourceTopics = new ArrayList<String>(0);
            this.repartitionSinkTopics = new ArrayList<String>(0);
            this.stateChangelogTopics = new ArrayList<TopicInfo>(0);
            this.repartitionSourceTopics = new ArrayList<TopicInfo>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int length;
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Subtopology");
            }
            int length2 = _readable.readUnsignedVarint() - 1;
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length2);
            }
            this.subtopologyId = _readable.readString(length2);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field sourceTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field sourceTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.sourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSinkTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field repartitionSinkTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field repartitionSinkTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.repartitionSinkTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field stateChangelogTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version)));
            }
            this.stateChangelogTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version)));
            }
            this.repartitionSourceTopics = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            Object _stringBytes2 = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
            _writable.writeByteArray((byte[])_stringBytes2);
            _writable.writeUnsignedVarint(this.sourceTopics.size() + 1);
            _stringBytes2 = this.sourceTopics.iterator();
            while (_stringBytes2.hasNext()) {
                String sourceTopicsElement = (String)_stringBytes2.next();
                _stringBytes = _cache.getSerializedValue(sourceTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.repartitionSinkTopics.size() + 1);
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = _cache.getSerializedValue(repartitionSinkTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.stateChangelogTopics.size() + 1);
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.repartitionSourceTopics.size() + 1);
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Subtopology");
            }
            byte[] _stringBytes2 = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.sourceTopics.size() + 1));
            for (String sourceTopicsElement : this.sourceTopics) {
                _stringBytes = sourceTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(sourceTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.repartitionSinkTopics.size() + 1));
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = repartitionSinkTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'repartitionSinkTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(repartitionSinkTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stateChangelogTopics.size() + 1));
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.repartitionSourceTopics.size() + 1));
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Subtopology)) {
                return false;
            }
            Subtopology other = (Subtopology)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.sourceTopics == null ? other.sourceTopics != null : !this.sourceTopics.equals(other.sourceTopics)) {
                return false;
            }
            if (this.repartitionSinkTopics == null ? other.repartitionSinkTopics != null : !this.repartitionSinkTopics.equals(other.repartitionSinkTopics)) {
                return false;
            }
            if (this.stateChangelogTopics == null ? other.stateChangelogTopics != null : !this.stateChangelogTopics.equals(other.stateChangelogTopics)) {
                return false;
            }
            if (this.repartitionSourceTopics == null ? other.repartitionSourceTopics != null : !this.repartitionSourceTopics.equals(other.repartitionSourceTopics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopics == null ? 0 : this.sourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSinkTopics == null ? 0 : this.repartitionSinkTopics.hashCode());
            hashCode = 31 * hashCode + (this.stateChangelogTopics == null ? 0 : this.stateChangelogTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSourceTopics == null ? 0 : this.repartitionSourceTopics.hashCode());
            return hashCode;
        }

        @Override
        public Subtopology duplicate() {
            Subtopology _duplicate = new Subtopology();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<String> newSourceTopics = new ArrayList<String>(this.sourceTopics.size());
            for (String string : this.sourceTopics) {
                newSourceTopics.add(string);
            }
            _duplicate.sourceTopics = newSourceTopics;
            ArrayList<String> newRepartitionSinkTopics = new ArrayList<String>(this.repartitionSinkTopics.size());
            for (String string : this.repartitionSinkTopics) {
                newRepartitionSinkTopics.add(string);
            }
            _duplicate.repartitionSinkTopics = newRepartitionSinkTopics;
            ArrayList<TopicInfo> arrayList = new ArrayList<TopicInfo>(this.stateChangelogTopics.size());
            for (TopicInfo _element : this.stateChangelogTopics) {
                arrayList.add(_element.duplicate());
            }
            _duplicate.stateChangelogTopics = arrayList;
            ArrayList<TopicInfo> arrayList2 = new ArrayList<TopicInfo>(this.repartitionSourceTopics.size());
            for (TopicInfo _element : this.repartitionSourceTopics) {
                arrayList2.add(_element.duplicate());
            }
            _duplicate.repartitionSourceTopics = arrayList2;
            return _duplicate;
        }

        public String toString() {
            return "Subtopology(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", sourceTopics=" + MessageUtil.deepToString(this.sourceTopics.iterator()) + ", repartitionSinkTopics=" + MessageUtil.deepToString(this.repartitionSinkTopics.iterator()) + ", stateChangelogTopics=" + MessageUtil.deepToString(this.stateChangelogTopics.iterator()) + ", repartitionSourceTopics=" + MessageUtil.deepToString(this.repartitionSourceTopics.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<String> sourceTopics() {
            return this.sourceTopics;
        }

        public List<String> repartitionSinkTopics() {
            return this.repartitionSinkTopics;
        }

        public List<TopicInfo> stateChangelogTopics() {
            return this.stateChangelogTopics;
        }

        public List<TopicInfo> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Subtopology setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public Subtopology setSourceTopics(List<String> v) {
            this.sourceTopics = v;
            return this;
        }

        public Subtopology setRepartitionSinkTopics(List<String> v) {
            this.repartitionSinkTopics = v;
            return this;
        }

        public Subtopology setStateChangelogTopics(List<TopicInfo> v) {
            this.stateChangelogTopics = v;
            return this;
        }

        public Subtopology setRepartitionSourceTopics(List<TopicInfo> v) {
            this.repartitionSourceTopics = v;
            return this;
        }
    }

    public static class Topology
    implements Message {
        int epoch;
        List<Subtopology> subtopologies;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("epoch", Type.INT32, "The epoch of the currently initialized topology for this group."), new Field("subtopologies", CompactArrayOf.nullable(Subtopology.SCHEMA_0), "The subtopologies of the streams application. This contains the configured subtopologies, where the number of partitions are set and any regular expressions are resolved to actual topics. Null if the group is uninitialized, source topics are missing or incorrectly partitioned."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Topology(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Topology() {
            this.epoch = 0;
            this.subtopologies = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Topology");
            }
            this.epoch = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.subtopologies = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Subtopology> newCollection = new ArrayList<Subtopology>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(new Subtopology(_readable, _version));
                }
                this.subtopologies = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.epoch);
            if (this.subtopologies == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.subtopologies.size() + 1);
                for (Subtopology subtopologiesElement : this.subtopologies) {
                    subtopologiesElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Topology");
            }
            _size.addBytes(4);
            if (this.subtopologies == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.subtopologies.size() + 1));
                for (Subtopology subtopologiesElement : this.subtopologies) {
                    subtopologiesElement.addSize(_size, _cache, _version);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Topology)) {
                return false;
            }
            Topology other = (Topology)obj;
            if (this.epoch != other.epoch) {
                return false;
            }
            if (this.subtopologies == null ? other.subtopologies != null : !this.subtopologies.equals(other.subtopologies)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.epoch;
            hashCode = 31 * hashCode + (this.subtopologies == null ? 0 : this.subtopologies.hashCode());
            return hashCode;
        }

        @Override
        public Topology duplicate() {
            Topology _duplicate = new Topology();
            _duplicate.epoch = this.epoch;
            if (this.subtopologies == null) {
                _duplicate.subtopologies = null;
            } else {
                ArrayList<Subtopology> newSubtopologies = new ArrayList<Subtopology>(this.subtopologies.size());
                for (Subtopology _element : this.subtopologies) {
                    newSubtopologies.add(_element.duplicate());
                }
                _duplicate.subtopologies = newSubtopologies;
            }
            return _duplicate;
        }

        public String toString() {
            return "Topology(epoch=" + this.epoch + ", subtopologies=" + (this.subtopologies == null ? "null" : MessageUtil.deepToString(this.subtopologies.iterator())) + ")";
        }

        public int epoch() {
            return this.epoch;
        }

        public List<Subtopology> subtopologies() {
            return this.subtopologies;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Topology setEpoch(int v) {
            this.epoch = v;
            return this;
        }

        public Topology setSubtopologies(List<Subtopology> v) {
            this.subtopologies = v;
            return this;
        }
    }
}

