/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.Objects;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class CoordinatorRecord {
    private final ApiMessage key;
    private final ApiMessageAndVersion value;

    public static CoordinatorRecord record(ApiMessage key, ApiMessageAndVersion value) {
        return new CoordinatorRecord(key, value);
    }

    public static CoordinatorRecord tombstone(ApiMessage key) {
        return new CoordinatorRecord(key, null);
    }

    private CoordinatorRecord(ApiMessage key, ApiMessageAndVersion value) {
        this.key = Objects.requireNonNull(key);
        if (key.apiKey() < 0) {
            throw new IllegalArgumentException("The key must have a type.");
        }
        this.value = value;
        if (value != null) {
            if (value.message().apiKey() < 0) {
                throw new IllegalArgumentException("The value must have a type.");
            }
            if (value.message().apiKey() != key.apiKey()) {
                throw new IllegalArgumentException("The key and the value must have the same type.");
            }
        }
    }

    public ApiMessage key() {
        return this.key;
    }

    public ApiMessageAndVersion value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorRecord that = (CoordinatorRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "CoordinatorRecord(key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ")";
    }
}

