/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.UnalignedRecords;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.Snapshots;

public final class FileRawSnapshotReader
implements RawSnapshotReader,
AutoCloseable {
    private final FileRecords fileRecords;
    private final OffsetAndEpoch snapshotId;

    private FileRawSnapshotReader(FileRecords fileRecords, OffsetAndEpoch snapshotId) {
        this.fileRecords = fileRecords;
        this.snapshotId = snapshotId;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long sizeInBytes() {
        return this.fileRecords.sizeInBytes();
    }

    @Override
    public UnalignedRecords slice(long position, int size) {
        return this.fileRecords.sliceUnaligned(Math.toIntExact(position), size);
    }

    @Override
    public Records records() {
        return this.fileRecords;
    }

    @Override
    public void close() {
        try {
            this.fileRecords.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to close snapshot reader %s at %s", this.snapshotId, this.fileRecords), e);
        }
    }

    public static FileRawSnapshotReader open(Path logDir, OffsetAndEpoch snapshotId) {
        FileRecords fileRecords;
        Path filePath = Snapshots.snapshotPath(logDir, snapshotId);
        try {
            fileRecords = FileRecords.open((File)filePath.toFile(), (boolean)false, (boolean)true, (int)0, (boolean)false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Unable to Opens a snapshot file %s", filePath.toAbsolutePath()), e);
        }
        return new FileRawSnapshotReader(fileRecords, snapshotId);
    }
}

