/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterClosedException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotWriter;

public class RaftSnapshotWriter
implements ImageWriter {
    private final SnapshotWriter<ApiMessageAndVersion> snapshotWriter;
    private final int batchSize;
    private List<ApiMessageAndVersion> records;
    private OptionalLong frozenSize = OptionalLong.empty();

    public RaftSnapshotWriter(SnapshotWriter<ApiMessageAndVersion> snapshotWriter, int batchSize) {
        this.snapshotWriter = snapshotWriter;
        this.batchSize = batchSize;
        this.records = new ArrayList<ApiMessageAndVersion>();
    }

    @Override
    public void write(ApiMessageAndVersion record) {
        if (this.records == null) {
            throw new ImageWriterClosedException();
        }
        this.records.add(record);
        if (this.records.size() >= this.batchSize) {
            this.snapshotWriter.append(this.records);
            this.records = new ArrayList<ApiMessageAndVersion>();
        }
    }

    @Override
    public void close(boolean complete) {
        if (this.records == null) {
            return;
        }
        try {
            if (complete) {
                if (!this.records.isEmpty()) {
                    this.snapshotWriter.append(this.records);
                }
                this.frozenSize = OptionalLong.of(this.snapshotWriter.freeze());
            }
        }
        finally {
            this.records = null;
            this.snapshotWriter.close();
        }
    }

    public OptionalLong frozenSize() {
        return this.frozenSize;
    }
}

