/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractMergedSortedCacheStoreIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowKeySchema;

class MergedSortedCacheWindowStoreKeyValueIterator
extends AbstractMergedSortedCacheStoreIterator<Windowed<Bytes>, Windowed<Bytes>, byte[], byte[]> {
    private final StateSerdes<Bytes, byte[]> serdes;
    private final long windowSize;
    private final SegmentedCacheFunction cacheFunction;
    private final StoreKeyToWindowKey storeKeyToWindowKey;
    private final WindowKeyToBytes windowKeyToBytes;

    MergedSortedCacheWindowStoreKeyValueIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> filteredCacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, StateSerdes<Bytes, byte[]> serdes, long windowSize, SegmentedCacheFunction cacheFunction, boolean forward) {
        this(filteredCacheIterator, underlyingIterator, serdes, windowSize, cacheFunction, forward, WindowKeySchema::fromStoreKey, WindowKeySchema::toStoreKeyBinary);
    }

    MergedSortedCacheWindowStoreKeyValueIterator(PeekingKeyValueIterator<Bytes, LRUCacheEntry> filteredCacheIterator, KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator, StateSerdes<Bytes, byte[]> serdes, long windowSize, SegmentedCacheFunction cacheFunction, boolean forward, StoreKeyToWindowKey storeKeyToWindowKey, WindowKeyToBytes windowKeyToBytes) {
        super(filteredCacheIterator, underlyingIterator, forward);
        this.serdes = serdes;
        this.windowSize = windowSize;
        this.cacheFunction = cacheFunction;
        this.storeKeyToWindowKey = storeKeyToWindowKey;
        this.windowKeyToBytes = windowKeyToBytes;
    }

    @Override
    Windowed<Bytes> deserializeStoreKey(Windowed<Bytes> key) {
        return key;
    }

    @Override
    KeyValue<Windowed<Bytes>, byte[]> deserializeStorePair(KeyValue<Windowed<Bytes>, byte[]> pair) {
        return pair;
    }

    @Override
    Windowed<Bytes> deserializeCacheKey(Bytes cacheKey) {
        byte[] binaryKey = this.cacheFunction.key(cacheKey).get();
        return this.storeKeyToWindowKey.toWindowKey(binaryKey, this.windowSize, this.serdes.keyDeserializer(), this.serdes.topic());
    }

    @Override
    byte[] deserializeCacheValue(LRUCacheEntry cacheEntry) {
        return cacheEntry.value();
    }

    @Override
    int compare(Bytes cacheKey, Windowed<Bytes> storeKey) {
        Bytes storeKeyBytes = this.windowKeyToBytes.toBytes(storeKey.key(), storeKey.window().start(), 0);
        return this.cacheFunction.compareSegmentedKeys(cacheKey, storeKeyBytes);
    }

    @FunctionalInterface
    static interface StoreKeyToWindowKey {
        public Windowed<Bytes> toWindowKey(byte[] var1, long var2, Deserializer<Bytes> var4, String var5);
    }

    @FunctionalInterface
    static interface WindowKeyToBytes {
        public Bytes toBytes(Bytes var1, long var2, int var4);
    }
}

