/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.nio.fs.LinuxFileStore;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.LinuxUserDefinedFileAttributeView;
import sun.nio.fs.LinuxWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.Util;

class LinuxFileSystem
extends UnixFileSystem {
    LinuxFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return new LinuxWatchService(this);
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int n, int n2) {
        LinuxUserDefinedFileAttributeView.copyExtendedAttributes(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UnixMountEntry> getMountEntries(String string) {
        ArrayList<UnixMountEntry> arrayList = new ArrayList<UnixMountEntry>();
        try {
            long l = LinuxNativeDispatcher.setmntent(Util.toBytes(string), Util.toBytes("r"));
            int n = 1024;
            try {
                int n2;
                while ((n2 = LinuxNativeDispatcher.getlinelen(l)) != -1) {
                    if (n2 <= n) continue;
                    n = n2;
                }
            }
            catch (UnixException unixException) {
            }
            finally {
                LinuxNativeDispatcher.rewind(l);
            }
            try {
                UnixMountEntry unixMountEntry;
                int n3;
                while ((n3 = LinuxNativeDispatcher.getmntent(l, unixMountEntry = new UnixMountEntry(), n + 1)) >= 0) {
                    arrayList.add(unixMountEntry);
                }
            }
            finally {
                LinuxNativeDispatcher.endmntent(l);
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return arrayList;
    }

    List<UnixMountEntry> getMountEntries() {
        return this.getMountEntries("/etc/mtab");
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new LinuxFileStore(this, unixMountEntry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(UnixFileSystem.standardFileAttributeViews());
            hashSet.add("dos");
            hashSet.add("user");
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

