/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram.impl;

import ai.grazie.detector.ngram.profiles.LanguageProfile;
import ai.grazie.detector.utils.collections.array.OneOptimizedFloatArray;
import ai.grazie.detector.utils.collections.array.OptimizedFloatArray;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies;", "", "probabilities", "", "", "Lai/grazie/detector/utils/collections/array/OptimizedFloatArray;", "languages", "", "Lai/grazie/nlp/langs/Language;", "statistics", "Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "<init>", "(Ljava/util/Map;Ljava/util/List;Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;)V", "getStatistics", "()Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "getLanguages", "()Ljava/util/List;", "getLanguage", "pos", "", "getProbabilities", "ngram", "Statistics", "Companion", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nNgramFrequencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class NgramFrequencies {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, OptimizedFloatArray> probabilities;
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final List<Language> languages;

    public NgramFrequencies(@NotNull Map<String, ? extends OptimizedFloatArray> probabilities, @NotNull List<? extends Language> languages, @NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        this.probabilities = probabilities;
        this.statistics = statistics;
        this.languages = CollectionsKt.plus((Collection)languages, (Object)Language.UNKNOWN);
        if (!(!languages.contains(Language.UNKNOWN))) {
            boolean bl = false;
            String string = "UNKNOWN language should not be passed to NgramFrequencies";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    public final Language getLanguage(int pos) {
        return this.languages.get(pos);
    }

    @NotNull
    public final OptimizedFloatArray getProbabilities(@NotNull String ngram) {
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        OptimizedFloatArray optimizedFloatArray = this.probabilities.get(ngram);
        if (optimizedFloatArray == null || (optimizedFloatArray = optimizedFloatArray.set(this.languages.size() - 1, 0.0f, (byte)this.languages.size())) == null) {
            optimizedFloatArray = new OneOptimizedFloatArray().set(this.languages.size() - 1, (float)this.statistics.getAverage(), (byte)this.languages.size());
        }
        return optimizedFloatArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies$Companion;", "", "<init>", "()V", "create", "Lai/grazie/detector/ngram/impl/NgramFrequencies;", "profiles", "", "Lai/grazie/detector/ngram/profiles/LanguageProfile;", "gramLengths", "", "create$nlp_detect", "nlp-detect"})
    @SourceDebugExtension(value={"SMAP\nNgramFrequencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1557#3:103\n1628#3,3:104\n*S KotlinDebug\n*F\n+ 1 NgramFrequencies.kt\nai/grazie/detector/ngram/impl/NgramFrequencies$Companion\n*L\n97#1:103\n97#1:104,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NgramFrequencies create$nlp_detect(@NotNull Collection<LanguageProfile> profiles, @NotNull Collection<Integer> gramLengths) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(gramLengths, (String)"gramLengths");
            if (!(!profiles.isEmpty())) {
                boolean $i$a$-require-NgramFrequencies$Companion$create$32 = false;
                String $i$a$-require-NgramFrequencies$Companion$create$32 = "No language profiles provided!";
                throw new IllegalArgumentException($i$a$-require-NgramFrequencies$Companion$create$32.toString());
            }
            if (!(!gramLengths.isEmpty())) {
                boolean $i$a$-require-NgramFrequencies$Companion$create$42 = false;
                String $i$a$-require-NgramFrequencies$Companion$create$42 = "No gram lengths provided!";
                throw new IllegalArgumentException($i$a$-require-NgramFrequencies$Companion$create$42.toString());
            }
            Map probabilities = CollectionFactory.INSTANCE.smallMemoryFootprintMap();
            double sumOfAll = 0.0;
            int total = 0;
            Object object = ((Iterable)profiles).iterator();
            int n = 0;
            while (object.hasNext()) {
                int index = n++;
                LanguageProfile profile = (LanguageProfile)object.next();
                Iterator<Integer> iterator = gramLengths.iterator();
                while (iterator.hasNext()) {
                    int gramLength = ((Number)iterator.next()).intValue();
                    long totalForLen = profile.getNumOccurrences$nlp_detect()[gramLength];
                    Map<String, Integer> map = profile.getNgrams$nlp_detect().get(gramLength);
                    for (String ngram : map.keySet()) {
                        OptimizedFloatArray updated;
                        Integer n2 = map.get(ngram);
                        Intrinsics.checkNotNull((Object)n2);
                        float prob = (float)((Number)n2).intValue() / (float)totalForLen;
                        ++total;
                        sumOfAll += (double)prob;
                        OptimizedFloatArray arr = (OptimizedFloatArray)probabilities.get(ngram);
                        OptimizedFloatArray optimizedFloatArray = arr;
                        if (optimizedFloatArray == null || (optimizedFloatArray = optimizedFloatArray.set(index, prob, (byte)profiles.size())) == null) {
                            optimizedFloatArray = new OneOptimizedFloatArray(index, prob);
                        }
                        if (Intrinsics.areEqual((Object)(updated = optimizedFloatArray), (Object)arr)) continue;
                        probabilities.put(ngram, updated);
                    }
                }
            }
            object = profiles;
            Map map = probabilities;
            boolean $i$f$map = false;
            void index = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LanguageProfile languageProfile = (LanguageProfile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getLocale());
            }
            Statistics statistics = new Statistics(sumOfAll / (double)total);
            List list = (List)destination$iv$iv;
            Map map2 = map;
            return new NgramFrequencies(map2, list, statistics);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/grazie/detector/ngram/impl/NgramFrequencies$Statistics;", "", "average", "", "<init>", "(D)V", "getAverage", "()D", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "nlp-detect"})
    public static final class Statistics {
        private final double average;

        public Statistics(double average) {
            this.average = average;
        }

        public final double getAverage() {
            return this.average;
        }

        public final double component1() {
            return this.average;
        }

        @NotNull
        public final Statistics copy(double average) {
            return new Statistics(average);
        }

        public static /* synthetic */ Statistics copy$default(Statistics statistics, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = statistics.average;
            }
            return statistics.copy(d);
        }

        @NotNull
        public String toString() {
            return "Statistics(average=" + this.average + ")";
        }

        public int hashCode() {
            return Double.hashCode(this.average);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Statistics)) {
                return false;
            }
            Statistics statistics = (Statistics)other;
            return Double.compare(this.average, statistics.average) == 0;
        }
    }
}

