/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CommonVariableAsmNameManglingUtils;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final int NO_FLAG_LOCAL = 0;
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put((Object)Visibilities.Private.INSTANCE, (Object)2).put((Object)Visibilities.PrivateToThis.INSTANCE, (Object)2).put((Object)Visibilities.Protected.INSTANCE, (Object)4).put((Object)JavaVisibilities.ProtectedStaticVisibility.INSTANCE, (Object)4).put((Object)JavaVisibilities.ProtectedAndPackage.INSTANCE, (Object)4).put((Object)Visibilities.Public.INSTANCE, (Object)1).put((Object)Visibilities.Internal.INSTANCE, (Object)1).put((Object)Visibilities.Local.INSTANCE, (Object)0).put((Object)JavaVisibilities.PackageVisibility.INSTANCE, (Object)0).build();
    public static final String CAPTURED_PREFIX = "$";
    public static final String THIS = "this";
    public static final String THIS_IN_DEFAULT_IMPLS = "$this";
    public static final String LABELED_THIS_FIELD = "this_";
    public static final String CAPTURED_LABELED_THIS_FIELD = "$this_";
    public static final String INLINE_DECLARATION_SITE_THIS = "this_";
    public static final String LABELED_THIS_PARAMETER = "$this$";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    public static final String RECEIVER_PARAMETER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String LOCAL_FUNCTION_VARIABLE_PREFIX = "$fun$";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static String getCapturedFieldName(@NotNull String originalName) {
        if (originalName == null) {
            AsmUtil.$$$reportNull$$$0(0);
        }
        String string = CAPTURED_PREFIX + originalName;
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getLabeledThisName(@NotNull String callableName, @NotNull String prefix, @NotNull String defaultName) {
        if (callableName == null) {
            AsmUtil.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            AsmUtil.$$$reportNull$$$0(3);
        }
        if (defaultName == null) {
            AsmUtil.$$$reportNull$$$0(4);
        }
        if (!Name.isValidIdentifier(callableName)) {
            String string = defaultName;
            if (string == null) {
                AsmUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = prefix + CommonVariableAsmNameManglingUtils.mangleNameIfNeeded(callableName);
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static Type boxType(@NotNull Type type) {
        Type boxedType;
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(7);
        }
        Type type2 = (boxedType = AsmUtil.boxPrimitiveType(type)) != null ? boxedType : type;
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(8);
        }
        return type2;
    }

    @Nullable
    public static Type boxPrimitiveType(@NotNull Type type) {
        JvmPrimitiveType jvmPrimitiveType;
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(9);
        }
        return (jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type.getSort()))) != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : null;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType;
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(10);
        }
        if ((primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType)) == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type = primitiveType;
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(11);
        }
        return type;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(12);
        }
        return (Type)primitiveTypeByBoxedType.get((Object)boxedType);
    }

    public static boolean isBoxedPrimitiveType(@NotNull Type boxedType) {
        if (boxedType == null) {
            AsmUtil.$$$reportNull$$$0(13);
        }
        return primitiveTypeByBoxedType.get((Object)boxedType) != null;
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (boxedOrPrimitiveType == null) {
            AsmUtil.$$$reportNull$$$0(14);
        }
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            Type type = boxedOrPrimitiveType;
            if (type == null) {
                AsmUtil.$$$reportNull$$$0(15);
            }
            return type;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isIntPrimitive(Type type) {
        return type == Type.INT_TYPE || type == Type.SHORT_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type) {
        return AsmUtil.isIntPrimitive(type) || type == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() != 10 && type.getSort() != 9;
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type) {
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(16);
        }
        String internalName = type.getInternalName();
        assert (internalName.charAt(0) == '[');
        Type type2 = Type.getType((String)internalName.substring(1));
        if (type2 == null) {
            AsmUtil.$$$reportNull$$$0(17);
        }
        return type2;
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        if (componentType == null) {
            AsmUtil.$$$reportNull$$$0(18);
        }
        Type type = Type.getType((String)("[" + componentType.getDescriptor()));
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(19);
        }
        return type;
    }

    @NotNull
    public static Method method(@NotNull String name2, @NotNull Type returnType, Type ... parameterTypes) {
        if (name2 == null) {
            AsmUtil.$$$reportNull$$$0(20);
        }
        if (returnType == null) {
            AsmUtil.$$$reportNull$$$0(21);
        }
        if (parameterTypes == null) {
            AsmUtil.$$$reportNull$$$0(22);
        }
        return new Method(name2, Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes));
    }

    public static Type stringValueOfType(Type type) {
        int sort = type.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type);
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(23);
        }
        if (exception == null) {
            AsmUtil.$$$reportNull$$$0(24);
        }
        v.anew(Type.getObjectType((String)exception));
        v.dup();
        if (message != null) {
            v.aconst((Object)message);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    public static void numConst(int value2, Type type, InstructionAdapter v) {
        if (type == Type.FLOAT_TYPE) {
            v.fconst((float)value2);
        } else if (type == Type.DOUBLE_TYPE) {
            v.dconst((double)value2);
        } else if (type == Type.LONG_TYPE) {
            v.lconst((long)value2);
        } else if (type == Type.CHAR_TYPE || type == Type.BYTE_TYPE || type == Type.SHORT_TYPE || type == Type.INT_TYPE) {
            v.iconst(value2);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type);
        }
    }

    public static void pushDefaultValueOnStack(@NotNull Type type, @NotNull InstructionAdapter v) {
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(25);
        }
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(26);
        }
        v.visitInsn(AsmUtil.defaultValueOpcode(type));
    }

    public static int defaultValueOpcode(@NotNull Type type) {
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(27);
        }
        if (type.getSort() == 10 || type.getSort() == 9) {
            return 1;
        }
        if (type.getSort() == 6) {
            return 11;
        }
        if (type.getSort() == 8) {
            return 14;
        }
        if (type.getSort() == 7) {
            return 9;
        }
        return 3;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (!AsmUtil.isPrimitive(left) || !AsmUtil.isPrimitive(right)) {
            throw new IllegalArgumentException("Cannot compute comparison operand type: " + left + ", " + right);
        }
        if (left == Type.BOOLEAN_TYPE || right == Type.BOOLEAN_TYPE) {
            if (left != Type.BOOLEAN_TYPE || right != Type.BOOLEAN_TYPE) {
                throw new IllegalArgumentException("Cannot compare boolean with non-boolean: " + left + ", " + right);
            }
            return Type.BOOLEAN_TYPE;
        }
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            AsmUtil.$$$reportNull$$$0(28);
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            Type type = Type.INT_TYPE;
            if (type == null) {
                AsmUtil.$$$reportNull$$$0(29);
            }
            return type;
        }
        Type type = expectedType;
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(30);
        }
        return type;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(31);
        }
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(32);
        }
        if (type.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings2) {
        if (av == null) {
            AsmUtil.$$$reportNull$$$0(33);
        }
        if (data == null) {
            AsmUtil.$$$reportNull$$$0(34);
        }
        if (strings2 == null) {
            AsmUtil.$$$reportNull$$$0(35);
        }
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string : data) {
            dataVisitor.visit(null, (Object)string);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string : strings2) {
            stringsVisitor.visit(null, (Object)string);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        if (fqName == null) {
            AsmUtil.$$$reportNull$$$0(36);
        }
        Type type = Type.getObjectType((String)AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName));
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(37);
        }
        return type;
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        if (classId == null) {
            AsmUtil.$$$reportNull$$$0(38);
        }
        Type type = Type.getObjectType((String)classId.asString().replace('.', '$'));
        if (type == null) {
            AsmUtil.$$$reportNull$$$0(39);
        }
        return type;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        if (fqName == null) {
            AsmUtil.$$$reportNull$$$0(40);
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName).getInternalName();
        if (string == null) {
            AsmUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(42);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class)}), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        if (v == null) {
            AsmUtil.$$$reportNull$$$0(43);
        }
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_ARRAY_TYPE, (Type[])new Type[]{AsmTypes.getType(Class[].class)}), false);
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility) {
        return visibilityToAccessFlag.get(visibility);
    }

    static {
        ImmutableMap.Builder typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType((String)primitiveType.getDesc());
            typeBySortBuilder.put((Object)asmType.getSort(), (Object)primitiveType);
            typeByWrapperBuilder.put((Object)AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), (Object)asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 7: 
            case 9: 
            case 16: 
            case 25: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedOrPrimitiveType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 23: 
            case 26: 
            case 31: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "av";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AsmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapturedFieldName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabeledThisName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "boxType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxUnlessPrimitive";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "correctElementType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "numberFunctionOperandType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "asmTypeByClassId";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCapturedFieldName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 41: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLabeledThisName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "boxType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "boxPrimitiveType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unboxType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unboxPrimitiveTypeOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBoxedPrimitiveType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unboxUnlessPrimitive";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "correctElementType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "method";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "genThrow";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "pushDefaultValueOnStack";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "defaultValueOpcode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "numberFunctionOperandType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "pop";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeAnnotationData";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByFqNameWithoutInnerClasses";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "asmTypeByClassId";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "internalNameByFqNameWithoutInnerClasses";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassIntoKClass";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "wrapJavaClassesIntoKClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 29: 
            case 30: 
            case 37: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

