/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.ant.execution;

import com.intellij.rt.ant.execution.IdeaAntLogger2;
import com.intellij.rt.ant.execution.PacketFactory;
import com.intellij.rt.ant.execution.PacketWriter;
import com.intellij.rt.ant.execution.SegmentedOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;

public class IdeaInputHandler
implements InputHandler {
    public void handleInput(InputRequest request) throws BuildException {
        String prompt = request.getPrompt();
        if (prompt == null) {
            throw new BuildException("Prompt is null");
        }
        SegmentedOutputStream err = IdeaAntLogger2.ourErr;
        if (err == null) {
            throw new BuildException("Selected InputHandler should be used by Intellij IDEA");
        }
        PacketWriter packet = PacketFactory.ourInstance.createPacket('I');
        packet.appendLimitedString(prompt);
        packet.appendLimitedString(request.getDefaultValue());
        if (request instanceof MultipleChoiceInputRequest) {
            Vector choices = ((MultipleChoiceInputRequest)request).getChoices();
            if (choices != null && !choices.isEmpty()) {
                int count = choices.size();
                packet.appendLong(count);
                for (String choice : choices) {
                    packet.appendLimitedString(choice);
                }
            } else {
                packet.appendLong(0L);
            }
        } else {
            packet.appendLong(0L);
        }
        packet.sendThrough(err);
        try {
            byte[] lengthValue = IdeaInputHandler.readBytes(4);
            int length = IdeaInputHandler.toUnsignedInt(lengthValue[0]) << 24 | IdeaInputHandler.toUnsignedInt(lengthValue[1]) << 16 | IdeaInputHandler.toUnsignedInt(lengthValue[2]) << 8 | IdeaInputHandler.toUnsignedInt(lengthValue[3]);
            String input = new String(IdeaInputHandler.readBytes(length));
            request.setInput(input);
            if (!request.isInputValid()) {
                throw new BuildException("Invalid input: " + input);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static int toUnsignedInt(byte b) {
        return b & 0xFF;
    }

    private static byte[] readBytes(int count) throws IOException {
        byte[] data = new byte[count];
        int read = System.in.read(data);
        if (read != count) {
            throw new IOException("End of input stream");
        }
        return data;
    }
}

