/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class LocalTestDiscoveryProducer
implements TestDiscoveryProducer {
    LocalTestDiscoveryProducer() {
    }

    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project, @NotNull List<? extends Couple<String>> classesAndMethods, byte frameworkId) {
        if (project == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(0);
        }
        if (classesAndMethods == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(1);
        }
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance((Project)project);
        classesAndMethods.forEach(couple -> result.putAllValues(couple.second == null ? instance.getTestsByClassName((String)couple.first, frameworkId) : instance.getTestsByMethodName((String)couple.first, (String)couple.second, frameworkId)));
        MultiMap multiMap = result;
        if (multiMap == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project project, @NotNull List<String> paths, byte frameworkId) {
        if (project == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(3);
        }
        if (paths == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(4);
        }
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance((Project)project);
        for (String path : paths) {
            result.putAllValues(instance.getTestsByFile(path, frameworkId));
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project project, @NotNull List<? extends Couple<String>> testFqns, byte frameworkId) {
        if (project == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(6);
        }
        if (testFqns == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(7);
        }
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance((Project)project);
        HashSet result = new HashSet();
        for (Couple<String> couple : testFqns) {
            result.addAll(instance.getAffectedFiles(couple, frameworkId));
        }
        return new ArrayList<String>(result);
    }

    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project project, @NotNull String testClassName, byte frameworkId) {
        if (project == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(8);
        }
        if (testClassName == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(9);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project project, @NotNull Collection<String> paths) {
        if (project == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(11);
        }
        if (paths == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(12);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            LocalTestDiscoveryProducer.$$$reportNull$$$0(13);
        }
        return list;
    }

    public boolean isRemote() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesAndMethods";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/LocalTestDiscoveryProducer";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqns";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/LocalTestDiscoveryProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscoveredTests";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscoveredTestsForFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFilePathsByClassName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithoutTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDiscoveredTests";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDiscoveredTestsForFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFilePaths";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFilePathsByClassName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithoutTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 10, 13 -> new IllegalStateException(string);
        };
    }
}

