/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.impl.interpret;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.IntegerValue;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedArrayLengthException;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DistinctCallTraceInterpreter
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        if (call == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            Value peekTrace = ((ArrayReference)value).getValue(0);
            Value trace2 = ((ArrayReference)value).getValue(1);
            TraceInfo order = this.myPeekResolver.resolve(call, peekTrace);
            Map<TraceElement, List<TraceElement>> direct = DistinctCallTraceInterpreter.resolve(trace2, order, Direction.DIRECT);
            Map<TraceElement, List<TraceElement>> reverse = DistinctCallTraceInterpreter.resolve(trace2, order, Direction.REVERSE);
            return new ValuesOrderInfo(order.getCall(), order.getValuesOrderBefore(), order.getValuesOrderAfter(), direct, reverse);
        }
        throw new UnexpectedValueException("distinct trace must be an array value");
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolve(@NotNull Value value, @NotNull TraceInfo order, @NotNull Direction direction) {
        if (value == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(2);
        }
        if (order == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(4);
        }
        if (value instanceof ArrayReference) {
            ArrayReference convertedMap = (ArrayReference)value;
            Value keys = convertedMap.getValue(0);
            Value values = convertedMap.getValue(1);
            if (keys instanceof ArrayReference) {
                ArrayReference keysArray = (ArrayReference)keys;
                if (values instanceof ArrayReference) {
                    ArrayReference valuesArray = (ArrayReference)values;
                    return Direction.DIRECT.equals((Object)direction) ? DistinctCallTraceInterpreter.resolveDirectTrace(keysArray, valuesArray, order) : DistinctCallTraceInterpreter.resolveReverseTrace(keysArray, valuesArray, order);
                }
            }
            throw new UnexpectedValueException("keys and values arrays must be arrays");
        }
        throw new UnexpectedValueException("value must be an array reference");
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolveDirectTrace(@NotNull ArrayReference keys, @NotNull ArrayReference values, @NotNull TraceInfo order) {
        int size;
        if (keys == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(5);
        }
        if (values == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(6);
        }
        if (order == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(7);
        }
        if ((size = keys.length()) != values.length()) {
            throw new UnexpectedArrayLengthException("length of keys array should be same with values array");
        }
        HashMap<TraceElement, List<TraceElement>> result = new HashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = order.getValuesOrderBefore();
        Map<Integer, TraceElement> after = order.getValuesOrderAfter();
        for (int i = 0; i < size; ++i) {
            int fromTime = DistinctCallTraceInterpreter.extractIntValue(keys.getValue(i));
            int afterTime = DistinctCallTraceInterpreter.extractIntValue(values.getValue(i));
            TraceElement beforeElement = before.get(fromTime);
            TraceElement afterElement = after.get(afterTime);
            if (beforeElement == null || afterElement == null) continue;
            result.put(beforeElement, Collections.singletonList(afterElement));
        }
        HashMap<TraceElement, List<TraceElement>> hashMap = result;
        if (hashMap == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolveReverseTrace(@NotNull ArrayReference keys, @NotNull ArrayReference values, @NotNull TraceInfo order) {
        int size;
        if (keys == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(9);
        }
        if (values == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(10);
        }
        if (order == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(11);
        }
        if ((size = keys.length()) != values.length()) {
            throw new UnexpectedArrayLengthException("length of keys array should be same with values array");
        }
        HashMap<TraceElement, List<TraceElement>> result = new HashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = order.getValuesOrderBefore();
        Map<Integer, TraceElement> after = order.getValuesOrderAfter();
        for (int i = 0; i < size; ++i) {
            int fromTime = DistinctCallTraceInterpreter.extractIntValue(keys.getValue(i));
            int afterTime = DistinctCallTraceInterpreter.extractIntValue(values.getValue(i));
            TraceElement beforeElement = before.get(fromTime);
            TraceElement afterElement = after.get(afterTime);
            if (beforeElement == null || afterElement == null) continue;
            result.computeIfAbsent(afterElement, x -> new ArrayList()).add(beforeElement);
        }
        HashMap<TraceElement, List<TraceElement>> hashMap = result;
        if (hashMap == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    private static int extractIntValue(@NotNull Value value) {
        if (value == null) {
            DistinctCallTraceInterpreter.$$$reportNull$$$0(13);
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).value();
        }
        throw new UnexpectedValueTypeException("value should be IntegerValue, but actual is " + value.typeName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/core/trace/impl/interpret/DistinctCallTraceInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/core/trace/impl/interpret/DistinctCallTraceInterpreter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectTrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReverseTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectTrace";
                break;
            }
            case 8: 
            case 12: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveReverseTrace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractIntValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 12 -> new IllegalStateException(string);
        };
    }

    private static enum Direction {
        DIRECT,
        REVERSE;

    }
}

