/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.util.SdkHomeBean;

public abstract class SdkHomeSettings
implements PersistentStateComponentWithModificationTracker<SdkHomeBean> {
    private final PsiManager myManager;
    private SdkHomeBean mySdkHome;

    protected SdkHomeSettings(@NotNull Project project) {
        if (project == null) {
            SdkHomeSettings.$$$reportNull$$$0(0);
        }
        this.mySdkHome = null;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    public long getStateModificationCount() {
        SdkHomeBean sdkHome = this.mySdkHome;
        return sdkHome == null ? 0L : sdkHome.getModificationCount();
    }

    public SdkHomeBean getState() {
        return this.mySdkHome;
    }

    public void loadState(@NotNull SdkHomeBean state) {
        if (state == null) {
            SdkHomeSettings.$$$reportNull$$$0(1);
        }
        SdkHomeBean oldState = this.mySdkHome;
        this.mySdkHome = state;
        if (oldState != null && !StringUtil.equals((CharSequence)oldState.getSdkHome(), (CharSequence)state.getSdkHome())) {
            this.myManager.dropPsiCaches();
        }
    }

    @Nullable
    private static VirtualFile calcHome(@Nullable SdkHomeBean state) {
        if (state == null) {
            return null;
        }
        String sdk_home = state.getSdkHome();
        if (StringUtil.isEmpty((String)sdk_home)) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(sdk_home);
    }

    @Nullable
    public VirtualFile getSdkHome() {
        return SdkHomeSettings.calcHome(this.mySdkHome);
    }

    public List<VirtualFile> getClassRoots() {
        return SdkHomeSettings.calcRoots(this.getSdkHome());
    }

    private static List<VirtualFile> calcRoots(@Nullable VirtualFile home) {
        if (home == null) {
            return Collections.emptyList();
        }
        VirtualFile lib = home.findChild("lib");
        if (lib == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile file : lib.getChildren()) {
            if (!"jar".equals(file.getExtension())) continue;
            ContainerUtil.addIfNotNull(result2, (Object)JarFileSystem.getInstance().getRootByLocal(file));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/util/SdkHomeSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

