/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.RemoveArgumentNamesUtils;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention$SingleArgumentContext;", "<init>", "()V", "getFamilyName", "", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "element", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "SingleArgumentContext", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nRemoveSingleArgumentNameIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveSingleArgumentNameIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n249#2:91\n967#3,7:92\n1761#3,3:99\n1761#3,3:102\n1869#3,2:105\n*S KotlinDebug\n*F\n+ 1 RemoveSingleArgumentNameIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention\n*L\n53#1:91\n58#1:92,7\n62#1:99,3\n64#1:102,3\n85#1:105,2\n*E\n"})
public final class RemoveSingleArgumentNameIntention
extends KotlinApplicableModCommandAction<KtValueArgument, SingleArgumentContext> {
    public RemoveSingleArgumentNameIntention() {
        super(Reflection.getOrCreateKotlinClass(KtValueArgument.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.argument.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtValueArgument element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getArgumentExpression();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression argumentExpression = ktExpression;
        TextRange textRange = TextRangeUtilsKt.relativeTo(new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)element)), PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)argumentExpression))), (PsiElement)element);
        return CollectionsKt.listOf((Object)textRange);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtValueArgument element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isNamed() || element.getArgumentExpression() == null) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        KtValueArgumentList ktValueArgumentList = psiElement instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement : null;
        return (ktValueArgumentList != null ? ktValueArgumentList.getParent() : null) instanceof KtCallElement;
    }

    @Override
    @Nullable
    public SingleArgumentContext prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtValueArgument element) {
        boolean nameCannotBeRemoved;
        List sortedArgumentsBeforeCurrent;
        boolean varargIsArrayOfCall;
        KtValueArgument vararg;
        block14: {
            Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
            if (ktCallElement == null) {
                return null;
            }
            KtCallElement callElement = ktCallElement;
            RemoveArgumentNamesUtils.ArgumentsData argumentsData = RemoveArgumentNamesUtils.INSTANCE.collectSortedArgumentsThatCanBeUnnamed($this$prepareContext, callElement);
            if (argumentsData == null) {
                return null;
            }
            RemoveArgumentNamesUtils.ArgumentsData argumentsData2 = argumentsData;
            List<KtValueArgument> sortedArguments = argumentsData2.component1();
            vararg = argumentsData2.component2();
            varargIsArrayOfCall = argumentsData2.component3();
            if (!sortedArguments.contains(element)) {
                return null;
            }
            Object object = callElement.getValueArgumentList();
            if (object == null || (object = object.getArguments()) == null) {
                return null;
            }
            Object allArguments = object;
            Iterable $this$takeWhile$iv = sortedArguments;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                KtValueArgument it = (KtValueArgument)item$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)element))) break;
                list$iv.add(item$iv);
            }
            sortedArgumentsBeforeCurrent = list$iv;
            boolean supportsMixed = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element).supportsFeature(LanguageFeature.MixedNamedArgumentsInTheirOwnPosition);
            if (supportsMixed) {
                $this$any$iv = CollectionsKt.withIndex((Iterable)sortedArgumentsBeforeCurrent);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument argument2;
                        IndexedValue bl = (IndexedValue)element$iv;
                        boolean bl2 = false;
                        int parameterIndex = bl.component1();
                        if (!(parameterIndex != allArguments.indexOf(argument2 = (KtValueArgument)bl.component2()))) continue;
                        v3 = true;
                        break block14;
                    }
                    v3 = false;
                }
            } else {
                $this$any$iv = sortedArgumentsBeforeCurrent;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl = false;
                        if (!it.isNamed()) continue;
                        v3 = true;
                        break block14;
                    }
                    v3 = nameCannotBeRemoved = false;
                }
            }
        }
        if (nameCannotBeRemoved) {
            return null;
        }
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull((List)sortedArgumentsBeforeCurrent);
        return new SingleArgumentContext((SmartPsiElementPointer<KtValueArgument>)(ktValueArgument != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktValueArgument)) : null), Intrinsics.areEqual((Object)element, (Object)vararg), Intrinsics.areEqual((Object)element, (Object)vararg) && varargIsArrayOfCall);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtValueArgument element, @NotNull SingleArgumentContext elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        PsiElement psiElement = element.getParent();
        KtValueArgumentList ktValueArgumentList = psiElement instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement : null;
        if (ktValueArgumentList == null) {
            return;
        }
        KtValueArgumentList argumentList = ktValueArgumentList;
        List<KtValueArgument> newArguments = KotlinPsiUtilsKt.createArgumentWithoutName(element, elementContext.isVararg(), elementContext.isArrayOfCall());
        argumentList.removeArgument(element);
        Iterable $this$forEach$iv = CollectionsKt.asReversed(newArguments);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtValueArgument it = (KtValueArgument)element$iv;
            boolean bl = false;
            SmartPsiElementPointer<KtValueArgument> smartPsiElementPointer = elementContext.getAnchorArgumentPointer();
            argumentList.addArgumentAfter(it, (KtValueArgument)(smartPsiElementPointer != null ? (KtValueArgument)smartPsiElementPointer.getElement() : null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveSingleArgumentNameIntention$SingleArgumentContext;", "", "anchorArgumentPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "isVararg", "", "isArrayOfCall", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;ZZ)V", "getAnchorArgumentPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.kotlin.codeInsight.intentions"})
    public static final class SingleArgumentContext {
        @Nullable
        private final SmartPsiElementPointer<KtValueArgument> anchorArgumentPointer;
        private final boolean isVararg;
        private final boolean isArrayOfCall;

        public SingleArgumentContext(@Nullable SmartPsiElementPointer<KtValueArgument> anchorArgumentPointer, boolean isVararg, boolean isArrayOfCall) {
            this.anchorArgumentPointer = anchorArgumentPointer;
            this.isVararg = isVararg;
            this.isArrayOfCall = isArrayOfCall;
        }

        @Nullable
        public final SmartPsiElementPointer<KtValueArgument> getAnchorArgumentPointer() {
            return this.anchorArgumentPointer;
        }

        public final boolean isVararg() {
            return this.isVararg;
        }

        public final boolean isArrayOfCall() {
            return this.isArrayOfCall;
        }

        @Nullable
        public final SmartPsiElementPointer<KtValueArgument> component1() {
            return this.anchorArgumentPointer;
        }

        public final boolean component2() {
            return this.isVararg;
        }

        public final boolean component3() {
            return this.isArrayOfCall;
        }

        @NotNull
        public final SingleArgumentContext copy(@Nullable SmartPsiElementPointer<KtValueArgument> anchorArgumentPointer, boolean isVararg, boolean isArrayOfCall) {
            return new SingleArgumentContext(anchorArgumentPointer, isVararg, isArrayOfCall);
        }

        public static /* synthetic */ SingleArgumentContext copy$default(SingleArgumentContext singleArgumentContext, SmartPsiElementPointer smartPsiElementPointer, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                smartPsiElementPointer = singleArgumentContext.anchorArgumentPointer;
            }
            if ((n & 2) != 0) {
                bl = singleArgumentContext.isVararg;
            }
            if ((n & 4) != 0) {
                bl2 = singleArgumentContext.isArrayOfCall;
            }
            return singleArgumentContext.copy(smartPsiElementPointer, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "SingleArgumentContext(anchorArgumentPointer=" + this.anchorArgumentPointer + ", isVararg=" + this.isVararg + ", isArrayOfCall=" + this.isArrayOfCall + ")";
        }

        public int hashCode() {
            int result2 = this.anchorArgumentPointer == null ? 0 : this.anchorArgumentPointer.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isVararg);
            result2 = result2 * 31 + Boolean.hashCode(this.isArrayOfCall);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleArgumentContext)) {
                return false;
            }
            SingleArgumentContext singleArgumentContext = (SingleArgumentContext)other;
            if (!Intrinsics.areEqual(this.anchorArgumentPointer, singleArgumentContext.anchorArgumentPointer)) {
                return false;
            }
            if (this.isVararg != singleArgumentContext.isVararg) {
                return false;
            }
            return this.isArrayOfCall == singleArgumentContext.isArrayOfCall;
        }
    }
}

