/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.imports;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.PsiUtilsKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.ReferencedSymbol;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.SymbolInfo;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.UsedReference;
import org.jetbrains.kotlin.idea.k2.codeinsight.imports.UsedReferencesCollectorKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0016\u001a\u00020\u0017R\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r0\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0007j\b\u0012\u0004\u0012\u00020\u0010`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0007j\b\u0012\u0004\u0012\u00020\u0012`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "unresolvedNames", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/collections/HashSet;", "usedDeclarations", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lkotlin/collections/HashMap;", "importableSymbols", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/SymbolInfo;", "references", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "aliases", "", "", "collectUsedReferences", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector$Result;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector$Result;", "collectReferencesFrom", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtElement;)V", "Result", "intellij.kotlin.codeInsight"})
@SourceDebugExtension(value={"SMAP\nUsedReferencesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsedReferencesCollector.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,108:1\n4225#2,11:109\n1617#3,9:120\n1869#3:129\n1870#3:131\n1626#3:132\n1#4:130\n382#5,7:133\n*S KotlinDebug\n*F\n+ 1 UsedReferencesCollector.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector\n*L\n60#1:109,11\n61#1:120,9\n61#1:129\n61#1:131\n61#1:132\n61#1:130\n91#1:133,7\n*E\n"})
public final class UsedReferencesCollector {
    @NotNull
    private final KtFile file;
    @NotNull
    private final HashSet<Name> unresolvedNames;
    @NotNull
    private final HashMap<FqName, Set<Name>> usedDeclarations;
    @NotNull
    private final HashSet<SymbolInfo> importableSymbols;
    @NotNull
    private final HashSet<KtReference> references;
    @NotNull
    private final Map<FqName, List<Name>> aliases;

    public UsedReferencesCollector(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.unresolvedNames = new HashSet();
        this.usedDeclarations = new HashMap();
        this.importableSymbols = new HashSet();
        this.references = new HashSet();
        this.aliases = UsedReferencesCollectorKt.access$collectImportAliases(this.file);
    }

    @NotNull
    public final Result collectUsedReferences(@NotNull KaSession kaSession) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        this.file.accept((PsiElementVisitor)new PsiRecursiveVisitor(this, kaSession){
            final /* synthetic */ UsedReferencesCollector this$0;
            final /* synthetic */ KaSession $$context-KaSession;
            {
                this.this$0 = $receiver;
                this.$$context-KaSession = kaSession;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressIndicatorProvider.checkCanceled();
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitImportList(KtImportList importList) {
                Intrinsics.checkNotNullParameter((Object)importList, (String)"importList");
            }

            public void visitPackageDirective(KtPackageDirective directive) {
                Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitKtElement(element);
                UsedReferencesCollector.access$collectReferencesFrom(this.this$0, this.$$context-KaSession, element);
            }
        });
        Set importableSymbolPointers = CollectionsKt.toSet((Iterable)this.importableSymbols);
        return new Result((Map<FqName, ? extends Set<Name>>)this.usedDeclarations, (Set<Name>)this.unresolvedNames, importableSymbolPointers, (Collection<? extends KtReference>)this.references);
    }

    /*
     * WARNING - void declaration
     */
    private final void collectReferencesFrom(KaSession kaSession, KtElement element) {
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterator element$iv$iv22;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        if (PsiUtilsKt.getIgnoreReferencesDuringImportOptimization((PsiElement)element)) {
            return;
        }
        if (element instanceof KtLabelReferenceExpression) {
            return;
        }
        PsiReference[] psiReferenceArray = element.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] objectArray = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Iterator element$iv$iv22 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv22 instanceof KtReference)) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv22 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv22.hasNext()) {
            UsedReference it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = element$iv$iv22.next();
            boolean bl = false;
            KtReference it = (KtReference)element$iv$iv;
            boolean bl2 = false;
            if (UsedReference.Companion.createFrom(kaSession, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List usedReferences = (List)destination$iv$iv;
        if (usedReferences.isEmpty()) {
            return;
        }
        for (UsedReference usedReference : usedReferences) {
            ProgressIndicatorProvider.checkCanceled();
            ((Collection)this.references).add(usedReference.getReference());
            boolean isResolved = usedReference.isResolved(kaSession);
            Collection<Name> names = usedReference.resolvesByNames(kaSession);
            if (!isResolved) {
                CollectionsKt.addAll((Collection)this.unresolvedNames, (Iterable)names);
                continue;
            }
            Collection<ReferencedSymbol> symbols = usedReference.resolveToReferencedSymbols(kaSession);
            for (ReferencedSymbol symbol : symbols) {
                Object object;
                void $this$getOrPut$iv;
                FqName importableName;
                if (!symbol.isResolvedWithImport(kaSession) || symbol.computeImportableName(kaSession) == null || Intrinsics.areEqual((Object)importableName.parent(), (Object)this.file.getPackageFqName()) && !this.aliases.containsKey(importableName)) continue;
                ProgressIndicatorProvider.checkCanceled();
                List list2 = this.aliases.get(importableName);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Set newNames = CollectionsKt.intersect((Iterable)CollectionsKt.plus((Collection)list2, (Object)importableName.shortName()), (Iterable)names);
                element$iv$iv = this.usedDeclarations;
                FqName key$iv = importableName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                CollectionsKt.addAll((Collection)((Collection)object), (Iterable)newNames);
                ((Collection)this.importableSymbols).add(symbol.toSymbolInfo(kaSession));
            }
        }
    }

    public static final /* synthetic */ void access$collectReferencesFrom(UsedReferencesCollector $this, KaSession kaSession, KtElement element) {
        $this.collectReferencesFrom(kaSession, element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JU\u0010\u001a\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/UsedReferencesCollector$Result;", "", "usedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "unresolvedNames", "usedSymbols", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/imports/SymbolInfo;", "references", "", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "<init>", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Collection;)V", "getUsedDeclarations", "()Ljava/util/Map;", "getUnresolvedNames", "()Ljava/util/Set;", "getUsedSymbols", "getReferences", "()Ljava/util/Collection;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.codeInsight"})
    public static final class Result {
        @NotNull
        private final Map<FqName, Set<Name>> usedDeclarations;
        @NotNull
        private final Set<Name> unresolvedNames;
        @NotNull
        private final Set<SymbolInfo> usedSymbols;
        @NotNull
        private final Collection<KtReference> references;

        public Result(@NotNull Map<FqName, ? extends Set<Name>> usedDeclarations, @NotNull Set<Name> unresolvedNames, @NotNull Set<? extends SymbolInfo> usedSymbols, @NotNull Collection<? extends KtReference> references) {
            Intrinsics.checkNotNullParameter(usedDeclarations, (String)"usedDeclarations");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            Intrinsics.checkNotNullParameter(usedSymbols, (String)"usedSymbols");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            this.usedDeclarations = usedDeclarations;
            this.unresolvedNames = unresolvedNames;
            this.usedSymbols = usedSymbols;
            this.references = references;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getUsedDeclarations() {
            return this.usedDeclarations;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Set<SymbolInfo> getUsedSymbols() {
            return this.usedSymbols;
        }

        @NotNull
        public final Collection<KtReference> getReferences() {
            return this.references;
        }

        @NotNull
        public final Map<FqName, Set<Name>> component1() {
            return this.usedDeclarations;
        }

        @NotNull
        public final Set<Name> component2() {
            return this.unresolvedNames;
        }

        @NotNull
        public final Set<SymbolInfo> component3() {
            return this.usedSymbols;
        }

        @NotNull
        public final Collection<KtReference> component4() {
            return this.references;
        }

        @NotNull
        public final Result copy(@NotNull Map<FqName, ? extends Set<Name>> usedDeclarations, @NotNull Set<Name> unresolvedNames, @NotNull Set<? extends SymbolInfo> usedSymbols, @NotNull Collection<? extends KtReference> references) {
            Intrinsics.checkNotNullParameter(usedDeclarations, (String)"usedDeclarations");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            Intrinsics.checkNotNullParameter(usedSymbols, (String)"usedSymbols");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            return new Result(usedDeclarations, unresolvedNames, usedSymbols, references);
        }

        public static /* synthetic */ Result copy$default(Result result2, Map map2, Set set, Set set2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = result2.usedDeclarations;
            }
            if ((n & 2) != 0) {
                set = result2.unresolvedNames;
            }
            if ((n & 4) != 0) {
                set2 = result2.usedSymbols;
            }
            if ((n & 8) != 0) {
                collection = result2.references;
            }
            return result2.copy(map2, set, set2, collection);
        }

        @NotNull
        public String toString() {
            return "Result(usedDeclarations=" + this.usedDeclarations + ", unresolvedNames=" + this.unresolvedNames + ", usedSymbols=" + this.usedSymbols + ", references=" + this.references + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.usedDeclarations).hashCode();
            result2 = result2 * 31 + ((Object)this.unresolvedNames).hashCode();
            result2 = result2 * 31 + ((Object)this.usedSymbols).hashCode();
            result2 = result2 * 31 + ((Object)this.references).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.usedDeclarations, result2.usedDeclarations)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.unresolvedNames, result2.unresolvedNames)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.usedSymbols, result2.usedSymbols)) {
                return false;
            }
            return Intrinsics.areEqual(this.references, result2.references);
        }
    }
}

