/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.connection;

import com.jetbrains.fus.reporting.connection.JavaHttpClient;
import com.jetbrains.fus.reporting.connection.ProxyInfo;
import com.jetbrains.fus.reporting.connection.ProxyProvider;
import com.jetbrains.fus.reporting.model.http.HttpClientBuilder;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.http.HttpClient;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/fus/reporting/connection/JavaHttpClientBuilder;", "Lcom/jetbrains/fus/reporting/model/http/HttpClientBuilder;", "()V", "builder", "Ljava/net/http/HttpClient$Builder;", "proxyProvider", "Lcom/jetbrains/fus/reporting/connection/ProxyProvider;", "configureProxy", "proxyInfo", "Lcom/jetbrains/fus/reporting/connection/ProxyInfo;", "newClient", "Lcom/jetbrains/fus/reporting/model/http/HttpClient;", "url", "", "setBuilder", "setProxyProvider", "setSSLContext", "sslContext", "Ljavax/net/ssl/SSLContext;", "connection-client"})
public final class JavaHttpClientBuilder
implements HttpClientBuilder {
    @NotNull
    private HttpClient.Builder builder;
    @Nullable
    private ProxyProvider proxyProvider;

    public JavaHttpClientBuilder() {
        HttpClient.Builder builder = HttpClient.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        this.builder = builder;
    }

    @NotNull
    public final JavaHttpClientBuilder setBuilder(@NotNull HttpClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        return this;
    }

    @NotNull
    public final JavaHttpClientBuilder setSSLContext(@Nullable SSLContext sslContext) {
        this.builder.followRedirects(HttpClient.Redirect.NORMAL);
        if (sslContext != null) {
            this.builder.sslContext(sslContext);
        }
        return this;
    }

    @NotNull
    public final JavaHttpClientBuilder setProxyProvider(@NotNull ProxyProvider proxyProvider) {
        Intrinsics.checkNotNullParameter((Object)proxyProvider, (String)"proxyProvider");
        this.proxyProvider = proxyProvider;
        return this;
    }

    private final JavaHttpClientBuilder configureProxy(ProxyInfo proxyInfo) {
        SocketAddress proxyAddress;
        if (proxyInfo.isNoProxy()) {
            return this;
        }
        Proxy proxy2 = proxyInfo.getProxy();
        if ((proxy2.type() == Proxy.Type.HTTP || proxy2.type() == Proxy.Type.SOCKS) && (proxyAddress = proxy2.address()) instanceof InetSocketAddress) {
            this.builder.proxy(ProxySelector.of(new InetSocketAddress(((InetSocketAddress)proxyAddress).getHostString(), ((InetSocketAddress)proxyAddress).getPort())));
            if (proxyInfo.getProxyAuth() != null && proxyInfo.getProxyAuth().getProxyLogin() != null) {
                this.builder.authenticator(new Authenticator(proxyInfo){
                    final /* synthetic */ ProxyInfo $proxyInfo;
                    {
                        this.$proxyInfo = $proxyInfo;
                    }

                    @NotNull
                    protected PasswordAuthentication getPasswordAuthentication() {
                        Object object;
                        String string2;
                        block3: {
                            block2: {
                                string2 = this.$proxyInfo.getProxyAuth().getProxyLogin();
                                object = this.$proxyInfo.getProxyAuth().getProxyPassword();
                                if (object == null) break block2;
                                char[] cArray = ((String)object).toCharArray();
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                                object = cArray;
                                if (cArray != null) break block3;
                            }
                            char[] cArray = "".toCharArray();
                            object = cArray;
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                        }
                        return new PasswordAuthentication(string2, (char[])object);
                    }
                });
            }
        }
        return this;
    }

    @Override
    @NotNull
    public com.jetbrains.fus.reporting.model.http.HttpClient newClient(@NotNull String url) {
        ProxyInfo proxyInfo;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ProxyProvider proxyProvider = this.proxyProvider;
        ProxyInfo proxyInfo2 = proxyInfo = proxyProvider != null ? proxyProvider.getProxy(url) : null;
        if (proxyInfo != null) {
            this.configureProxy(proxyInfo);
        }
        return new JavaHttpClient(this.builder);
    }
}

