/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FormsParsing {
    private static final Logger LOG = Logger.getInstance(FormsParsing.class);
    private static final String FORM_TAG = "form";

    private FormsParsing() {
    }

    public static String readBoundClassName(@NotNull Path formFile) throws IOException, AlienFormFileException {
        if (formFile == null) {
            FormsParsing.$$$reportNull$$$0(0);
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(formFile, new OpenOption[0]));){
            final Ref result = new Ref(null);
            final Ref isAlien = new Ref((Object)Boolean.FALSE);
            FormsParsing.parse(in, (IXMLBuilder)new IXMLBuilderAdapter(){

                @Override
                public void startElement(String elemName, String nsPrefix, String nsURI, String systemID, int lineNr) {
                    boolean alien;
                    if (!FormsParsing.FORM_TAG.equalsIgnoreCase(elemName)) {
                        1.stop();
                    }
                    boolean bl = alien = !"http://www.intellij.com/uidesigner/form/".equalsIgnoreCase(nsURI);
                    if (alien) {
                        isAlien.set((Object)Boolean.TRUE);
                        1.stop();
                    }
                }

                @Override
                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                    if ("bind-to-class".equals(key)) {
                        result.set((Object)value);
                        1.stop();
                    }
                }

                @Override
                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
                    1.stop();
                }
            });
            if (((Boolean)isAlien.get()).booleanValue()) {
                throw new AlienFormFileException();
            }
            String string = (String)result.get();
            return string;
        }
    }

    public static void parse(InputStream is, IXMLBuilder builder) {
        try (InputStream inputStream = is;){
            FormsParsing.parse(new MyXMLReader(is), builder);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static void parse(StdXMLReader r, IXMLBuilder builder) {
        StdXMLParser parser = new StdXMLParser(r, builder, (IXMLValidator)new EmptyValidator(), (IXMLEntityResolver)new EmptyEntityResolver());
        try {
            parser.parse();
        }
        catch (XMLException e) {
            if (e.getException() instanceof ParserStoppedException) {
                return;
            }
            LOG.debug((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFile", "org/jetbrains/jps/incremental/java/FormsParsing", "readBoundClassName"));
    }

    private static final class MyXMLReader
    extends StdXMLReader {
        MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicId, String systemId) {
            return new StringReader(" ");
        }
    }

    private static final class EmptyValidator
    extends NonValidator {
        private EmptyValidator() {
        }

        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }
    }

    private static final class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(StdXMLReader xmlReader, String name) {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    @ApiStatus.Internal
    public static final class ParserStoppedException
    extends RuntimeException {
        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    @ApiStatus.Internal
    public static class IXMLBuilderAdapter
    implements IXMLBuilder {
        public void startBuilding(String systemID, int lineNr) {
        }

        public void newProcessingInstruction(String target, Reader reader) {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) {
        }

        @Nullable
        public Object getResult() {
            return null;
        }

        protected static void stop() {
            throw new ParserStoppedException();
        }
    }
}

