---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Insecure authentication over HTTP (Digest Authentication)
---

## Description

The target application was found to authenticate users using the Digest Authentication scheme over HTTP.
Digest Authentication uses an insecure hashing algorithm (MD5) to hash the username and password and sends
it in the `Authentication` header. Attackers who are in between the communication path (or on the same
local network) of the client and server could use packet sniffers to modify the server's response parameters
to downgrade the security of the digest access authentication mode. Additionally, the server stores the
hashed credentials, usually in a file called `.htpasswd`. Tools are readily available to crack these passwords.

## Remediation

If possible, switch to a more robust method to authenticate users such as OAuth 2.0, or storing usernames
and passwords in a data store protected by the Argon2id algorithm. If Digest Authentication must be used,
ensure credentials are only transmitted over secure channels such as HTTPS/TLS.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 287.2 | false | 287 | Passive | Low |

## Links

- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Password_Storage_Cheat_Sheet.html)
- [OAuth 2.0](https://oauth.net/2/)
- [CWE-287](https://cwe.mitre.org/data/definitions/287.html)
- [RFC](https://datatracker.ietf.org/doc/html/rfc2069)
