---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "GitLabの作業アイテム間の関係を接続し、追跡します。依存関係を管理し、戦略的な目標と実行を結び付け、部門間のイニシアチブを調整します。"
title: リンクされたアイテム
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

リンクされたアイテムは、作業アイテム間に双方向の関係を作成し、ワークフロー全体の依存関係を視覚化および管理するのに役立ちます。

リンクされたアイテムを使用すると、イシュー、エピック、タスク、目標などのさまざまな作業アイテムを接続して、それらの間の関係を示すことができます。

これらの接続により、個々の作業が互いに、またより大きな戦略的イニシアチブとどのように関連しているかを誰もが理解できるようになります。

## リンクされたアイテムの使用方法 {#ways-to-use-linked-items}

リンクされたアイテムを使用して、計画と調整に関するいくつかの課題を解決できます。

次の例は、リンクされたアイテムがチームの連携をどのように支援するかを示しています。

### 依存関係の追跡 {#track-dependencies}

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

他のアイテムをブロックする、または他のアイテムによってブロックされる作業を明確に識別します。

ブロック関係にあるアイテムをリンクすると、次のようになります:

- チームは、他にどのような作業に依存しているかをすぐに確認できます。
- ステータスの更新は、リンクされたアイテム間で自動的に同期されます。
- 未解決のブロッカーがあるアイテムを閉じると、警告が表示されます。
- チームは、依存関係に積極的に対処することで、遅延を回避できます。

この表示レベルにより、チーム間の作業の調整が容易になり、ボトルネックが削減されます。

### 戦略的な目標と実装の詳細を結び付ける {#connect-strategic-goals-with-implementation-details}

リンクされたアイテムを使用して、高レベルの計画と日々の実行を結び付けます。

戦略的な目標を戦術的なタスクにリンクすると、次のようになります:

- チームは、自分たちの仕事がより大きな目標にどのように貢献するかを理解できます。
- ステークホルダーは、戦略から実装までの進捗状況を追跡できます。
- 誰もが、個々の取り組みがより広範なビジョンをどのようにサポートしているかを表示レベルで把握できます。
- 戦略の変更は、影響を受ける実装作業に迅速に追跡できます。

レベル間のこの接続により、組織全体の連携と目的が生まれます。

### 部門横断的なイニシアチブの編成 {#organize-cross-functional-initiatives}

さまざまなチームやプロジェクトにわたる関連作業をリンクさせて、複雑なイニシアチブを調整します。

部門横断的な作業にリンクされたアイテムを使用すると、次のようになります:

- 各チームは、関連作業への接続を維持しながら、独自の領域で作業できます。
- 専門チーム間の依存関係が表示レベル化されます。
- ステータスの更新は、関連アイテム間で自動的に同期されます。
- チームは、絶え間ない会議なしに、自分たちの取り組みを調整できます。

この調整は、サイロを解消し、イニシアチブのすべての側面が同期した状態を維持するのに役立ちます。

## リンクされたアイテムのタイプ {#types-of-linked-items}

GitLabは、さまざまなタイプの作業アイテムのリンクをサポートしています:

- [イシュー](../project/issues/related_issues.md)は、タスク、バグ、および機能を追跡するのに役立ち、個別の作業間の依存関係を示すためにリンクできます。
- [エピック](../group/epics/linked_epics.md)を使用すると、部門横断的なイニシアチブを管理したり、依存関係を表示したり、戦略的計画を複数のチームまたはプロジェクトにわたる実行に接続したりできます。Ultimateプランで利用できます。
- [タスク](../tasks.md#linked-items-in-tasks)は、より小さな作業単位に対する軽量な追跡を提供し、プロジェクト内の関係または依存関係を示すために他のアイテムにリンクできます。
- [目標と主な成果](../okrs.md#linked-items-in-okrs)は、戦略的目標を実行の詳細と結びつけ、日々の作業がより高レベルの組織の優先事項と一致するようにします。
- [インシデント](../../operations/incident_management/incidents.md)は、緊急の復旧を必要とするサービスの中断または停止を表し、運用上の問題と計画された作業への影響をより適切に追跡するために、関連する作業アイテムにリンクできます。
- [テストケース](../../ci/test_cases/_index.md)は、テスト計画をGitLabワークフローに直接統合し、チームがテストシナリオを文書化し、コードを管理する同じプラットフォームで要件を追跡できるようにします。Ultimateプランで利用できます。

## 関係のタイプ {#relationship-types}

アイテムをリンクするときに、関係のタイプを指定できます:

- **以下に関係する**: アイテム間の一般的な関係を示します。
- **ブロック**: アイテムが別のアイテムの進行を妨げていることを示します。
- **は次の人によってブロックされています:**: 別のアイテムが解決されるまで、アイテムが続行できないことを示します。

## リンクされたアイテムの一般的なタスク {#common-tasks-with-linked-items}

これらの一般的な手順で、作業アイテム間の関係を作成および管理する方法について説明します。

### リンクされたアイテムを追加する {#add-a-linked-item}

前提要件:

- 両方のアイテムのプロジェクトまたはグループに対して、少なくともゲストロールが必要です。

リンクされたアイテムを追加するための一般的なプロセスは、すべての作業アイテムタイプで似ています:

1. 変更する作業アイテムに移動します。
1. 説明の下部にある作業アイテムの**リンクされたアイテム**セクションを見つけます。
1. **追加**を選択します。
1. 関係のタイプを選択します: **次のアイテムに関連している**、**次のアイテムをブロックしている**、または**次のアイテムにブロックされている**。
1. リンクするアイテムの参照を入力します。次のことができます: 
   - アイテムのタイプに応じて、`#`または`&`を入力し、その後にアイテムの番号を入力します。
   - タイトルでアイテムを検索するテキストを入力します。
   - アイテムの完全なURLを貼り付けます。
1. **追加**を選択して確定します。

または、[クイックアクション](../project/quick_actions.md)を使用してリンクされたアイテムを追加することもできます:

- `/relate`
- `/blocks`
- `/blocked_by`

各作業アイテムタイプに固有の詳細については、関連するドキュメントを参照してください:

- [リンクされたイシュー](../project/issues/related_issues.md#add-a-linked-issue)
- [リンクされたエピック](../group/epics/linked_epics.md#add-a-linked-item)
- [リンクされたタスク](../tasks.md#linked-items-in-tasks)
- [リンクされたOKR](../okrs.md#linked-items-in-okrs)

### リンクされたアイテムを削除する {#remove-a-linked-item}

前提要件:

- 両方のアイテムのプロジェクトまたはグループに対して、少なくともゲストロールが必要です。

リンクされたアイテムを削除するには:

1. 変更する作業アイテムに移動します。
1. 説明の下部にある作業アイテムの**リンクされたアイテム**セクションを見つけます。
1. リンクされた各アイテムについて、**削除**（{{< icon name="close" >}}）を選択します。

双方向の関係は両方のアイテムから削除されます。

または、`/unlink` [クイックアクション](../project/quick_actions.md)を使用して、リンクされたアイテムを削除することもできます。

## 関連トピック {#related-topics}

- [作業アイテム](_index.md)
- [イシュー](../project/issues/_index.md)
- [エピック](../group/epics/_index.md)
- [タスク](../tasks.md)
- [目標と主な成果](../okrs.md)
