---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Contentful配信APIトークンの機密シークレットまたはトークンの公開'
---

## 説明 {#description}

応答本文には、Contentful配信APIトークンのパターンに一致するコンテンツが含まれていることが確認されました。Contentful Delivery API（CDA）は、Contentfulからアプリ、ウェブサイト、その他のメディアにコンテンツを配信するための読み取り専用APIです。コンテンツはJSONデータとして、画像、ビデオ、その他のメディアはファイルとして配信されます。このトークンへのアクセス権を持つ悪意のある攻撃者は、エントリへの読み取り専用アクセス権を持っています。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

キーの漏洩に関するセキュリティインシデントの処理に関する一般的なガイダンスについては、GitLabドキュメントの[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

配信APIトークンを失効するには:

- サインインして<https://app.contentful.com/>にアクセスしてください。
- 右上隅にある歯車アイコンを選択し、「API Keys」を選択します。
- 検出されたAPIキーを見つけ、APIキーのテーブルで名前を選択します
- 右上隅にある「Delete」を選択します
- プロンプトが表示されたら、「Delete」を選択します。これにより、プレビューAPIトークンも削除されることに注意してください。新しいAPIキーのセットを生成する必要があります。

詳細については、Developerの[認証に関するドキュメント](https://www.contentful.com/developers/docs/references/authentication/#the-content-delivery-and-preview-api)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.23 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
