# frozen_string_literal: true

class FinalizeHkBackfillOccurrenceIdToVulnerabilityRepresentationInform < Gitlab::Database::Migration[2.3]
  milestone '18.9'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillOccurrenceIdToVulnerabilityRepresentationInformation',
      table_name: :vulnerability_representation_information,
      column_name: :vulnerability_id,
      job_arguments: [],
      finalize: true
    )
  end

  def down; end
end
