# frozen_string_literal: true

class AddConstraintsForReadinessVulnerabilityMr < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.6'

  TABLE = :vulnerability_merge_request_links

  def constraint_name
    check_constraint_name TABLE, :readiness_score, "between_0_and_1"
  end

  def up
    add_check_constraint TABLE, 'readiness_score >= 0 AND readiness_score <= 1', constraint_name
  end

  def down
    remove_check_constraint TABLE, constraint_name
  end
end
