/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.widgets.label.GDHtmlLabel;
import generic.theme.GAttributes;
import generic.theme.GColor;
import generic.theme.Gui;
import generic.theme.ThemeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractDetailsPanel
extends JPanel {
    protected static final String FONT_DEFAULT = "font.panel.details";
    protected static final String FONT_MONOSPACED = "font.panel.details.monospaced";
    private static final int MIN_WIDTH = 700;
    protected static final int LEFT_COLUMN_WIDTH = 150;
    protected static final int RIGHT_MARGIN = 30;
    protected static GAttributes titleAttrs;
    protected JLabel textLabel;
    protected JScrollPane sp;
    private ThemeListener themeListener = e -> {
        if (e.isFontChanged(FONT_DEFAULT) || e.isFontChanged(FONT_MONOSPACED)) {
            this.updateFieldAttributes();
        }
    };

    protected AbstractDetailsPanel() {
        this.createFieldAttributes();
        Gui.addThemeListener((ThemeListener)this.themeListener);
    }

    private void updateFieldAttributes() {
        this.createFieldAttributes();
        this.refresh();
        this.repaint();
    }

    protected abstract void createFieldAttributes();

    protected abstract void refresh();

    protected void clear() {
        this.textLabel.setText("");
    }

    protected void createMainPanel() {
        this.setLayout(new BorderLayout());
        this.textLabel = new GDHtmlLabel(){

            public Dimension getPreferredSize() {
                Dimension mySize = super.getPreferredSize();
                int rightColumnWidth = AbstractDetailsPanel.this.getWidth() - 150;
                mySize.width = Math.max(700, rightColumnWidth);
                return mySize;
            }
        };
        this.textLabel.setVerticalAlignment(1);
        this.textLabel.setOpaque(true);
        this.textLabel.setBackground((Color)new GColor("color.bg.panel.details"));
        this.sp = new JScrollPane(this.textLabel);
        this.sp.getVerticalScrollBar().setUnitIncrement(10);
        this.sp.setPreferredSize(new Dimension(700, 200));
        this.add((Component)this.sp, "Center");
    }

    protected void insertRowTitle(StringBuilder buffer, String rowName) {
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(buffer, rowName + ":", titleAttrs);
        buffer.append("</TD>");
    }

    protected void insertRowValue(StringBuilder buffer, String value, GAttributes attributes) {
        buffer.append("<TD VALIGN=\"TOP\" WIDTH=\"80%\">");
        this.insertHTMLLine(buffer, value, attributes);
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    protected void insertHTMLString(StringBuilder buffer, String string, GAttributes attributes) {
        if (string == null) {
            return;
        }
        buffer.append(attributes.toStyledHtml(string));
    }

    protected void insertHTMLLine(StringBuilder buffer, String string, GAttributes attributes) {
        if (string == null) {
            return;
        }
        this.insertHTMLString(buffer, string, attributes);
        buffer.append("<br>");
    }
}

