/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GColor;
import java.awt.Color;
import java.awt.Component;
import org.apache.logging.log4j.Level;

public class LogLevelTableCellRenderer
extends GTableCellRenderer {
    private static final Color TRACE_COLOR = new GColor("color.bg.logviwer.table.trace");
    private static final Color DEBUG_COLOR = new GColor("color.bg.logviwer.table.debug");
    private static final Color INFO_COLOR = new GColor("color.bg.logviwer.table.info");
    private static final Color WARN_COLOR = new GColor("color.bg.logviwer.table.warn");
    private static final Color ERROR_COLOR = new GColor("color.bg.logviwer.table.error");
    private static final Color FATAL_COLOR = new GColor("color.bg.logviwer.table.fatal");
    private static final Color FG = new GColor("color.fg.logviewer.table");
    private static final Color FG_SELECTED = new GColor("color.fg.logviewer.table.selected");

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        this.setForeground(data.isSelected() ? FG_SELECTED : FG);
        if (value.toString().equalsIgnoreCase(Level.DEBUG.toString())) {
            this.setBackground(DEBUG_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.TRACE.toString())) {
            this.setBackground(TRACE_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.WARN.toString())) {
            this.setBackground(WARN_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.INFO.toString())) {
            this.setBackground(INFO_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.ERROR.toString())) {
            this.setBackground(ERROR_COLOR);
        } else if (value.toString().equalsIgnoreCase(Level.FATAL.toString())) {
            this.setBackground(FATAL_COLOR);
        }
        return this;
    }
}

