/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.attributes.AnnotationJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationElementValue
implements StructConverter {
    private byte tag;
    private short constantValueIndex;
    private short typeNameIndex;
    private short constantNameIndex;
    private short classInfoIndex;
    private AnnotationJava annotation;
    private short numberOfValues;
    private AnnotationElementValue[] values;

    public AnnotationElementValue(BinaryReader reader) throws IOException {
        this.tag = reader.readNextByte();
        if (this.tag == 66 || this.tag == 67 || this.tag == 73 || this.tag == 83 || this.tag == 74 || this.tag == 70 || this.tag == 68 || this.tag == 90 || this.tag == 115) {
            this.constantValueIndex = reader.readNextShort();
        } else if (this.tag == 101) {
            this.typeNameIndex = reader.readNextShort();
            this.constantNameIndex = reader.readNextShort();
        } else if (this.tag == 99) {
            this.classInfoIndex = reader.readNextShort();
        } else if (this.tag == 64) {
            this.annotation = new AnnotationJava(reader);
        } else if (this.tag == 91) {
            this.numberOfValues = reader.readNextShort();
            this.values = new AnnotationElementValue[this.numberOfValues & 0xFFFF];
            for (int i = 0; i < (this.numberOfValues & 0xFFFF); ++i) {
                this.values[i] = new AnnotationElementValue(reader);
            }
        }
    }

    public byte getTag() {
        return this.tag;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex & 0xFFFF;
    }

    public int getTypeNameIndex() {
        if (this.tag != 101) {
            throw new IllegalArgumentException();
        }
        return this.typeNameIndex & 0xFFFF;
    }

    public int getConstantNameIndex() {
        if (this.tag != 101) {
            throw new IllegalArgumentException();
        }
        return this.constantNameIndex & 0xFFFF;
    }

    public int getClassInfoIndex() {
        return this.classInfoIndex & 0xFFFF;
    }

    public AnnotationJava getAnnotation() {
        return this.annotation;
    }

    public AnnotationElementValue[] getValues() {
        return this.values;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "element_value|" + this.tag + "|";
        StructureDataType structure = new StructureDataType(name, 0);
        if (this.tag == 66 || this.tag == 67 || this.tag == 73 || this.tag == 83 || this.tag == 74 || this.tag == 70 || this.tag == 68 || this.tag == 90 || this.tag == 115 || this.tag == 101 || this.tag == 99 || this.tag == 64 || this.tag == 91) {
            // empty if block
        }
        return structure;
    }
}

