/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.util.job;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.util.job.AbstractGroupingFunctionGraphJob;
import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.viewer.layout.LayoutPositions;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UngroupVertexFunctionGraphJob
extends AbstractGroupingFunctionGraphJob {
    public UngroupVertexFunctionGraphJob(FGController controller, GroupedFunctionGraphVertex groupVertex, boolean useAnimation, boolean isPartOfUngroupAll) {
        super(controller, groupVertex, groupVertex.getVertices(), UngroupVertexFunctionGraphJob.asSet(groupVertex), false, useAnimation);
        this.duration = isPartOfUngroupAll ? 700 : 1500;
    }

    @Override
    protected void notifyGroupChange() {
        this.getFunctionGraph().groupRemoved(this.groupVertex);
    }

    @Override
    protected Map<FGVertex, Point2D> getGroupingDestinationLocations(boolean isRelayout, Point2D groupVertexDestinationLocation) {
        if (isRelayout) {
            return Collections.emptyMap();
        }
        return this.groupVertex.getPreGroupLocations();
    }

    protected void initializeVertexLocations() {
        LayoutPositions<FGVertex, FGEdge> positions = this.updateDestinationLocations();
        Map vertexDestinationLocations = positions.getVertexLocations();
        this.finalEdgeArticulations = positions.getEdgeArticulations();
        Point2D oldLocation = this.toLocation(this.groupVertex);
        Point2D groupVertexPoint = (Point2D)oldLocation.clone();
        Collection<FGVertex> vertices = this.getVerticesToMove();
        for (FGVertex vertex : vertices) {
            Point2D currentPoint = this.newVertices.contains(vertex) ? (Point2D)groupVertexPoint.clone() : this.toLocation(vertex);
            Point2D startPoint = (Point2D)currentPoint.clone();
            Point2D destinationPoint = (Point2D)((Point2D)vertexDestinationLocations.get(vertex)).clone();
            AbstractGraphTransitionJob.TransitionPoints transitionPoints = new AbstractGraphTransitionJob.TransitionPoints((AbstractGraphTransitionJob)this, startPoint, destinationPoint);
            this.vertexLocations.put(vertex, transitionPoints);
        }
        for (FGVertex vertex : this.newVertices) {
            Point2D startPoint = (Point2D)groupVertexPoint.clone();
            AbstractGraphTransitionJob.TransitionPoints xPoint = (AbstractGraphTransitionJob.TransitionPoints)this.vertexLocations.get(vertex);
            xPoint.startPoint = startPoint;
        }
        Map edgeArticulations = positions.getEdgeArticulations();
        Collection edgesToMove = this.graph.getEdges();
        for (FGEdge edge : edgesToMove) {
            List currentArticulations = edge.getArticulationPoints();
            List<Point2D> newArticulations = (List<Point2D>)edgeArticulations.get(edge);
            if (newArticulations == null) {
                newArticulations = Collections.emptyList();
            }
            List<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = this.getArticulationTransitionPoints(currentArticulations, newArticulations, vertexDestinationLocations, edge);
            this.edgeArticulationLocations.put(edge, transitionPoints);
        }
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        if (currentArticulations.size() > newArticulations.size()) {
            return this.getArticulationTransitionPointsWhenStartingWithMorePoints(currentArticulations, newArticulations, destinationLocations, edge);
        }
        return this.getArticulationTransitionPointsWhenStartingWithLessPoints(currentArticulations, newArticulations, destinationLocations, edge);
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithMorePoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        for (int i = 0; i < currentArticulations.size(); ++i) {
            Point2D startPoint = currentArticulations.get(i);
            Point2D endPoint = (Point2D)startPoint.clone();
            if (i < newArticulations.size()) {
                endPoint = newArticulations.get(i);
            } else {
                FGVertex destinationVertex = (FGVertex)edge.getEnd();
                AbstractGraphTransitionJob.TransitionPoints destionationTranstionPoint = this.getTransitionPoint(this.vertexLocations, destinationLocations, destinationVertex);
                endPoint = destionationTranstionPoint.destinationPoint;
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints((AbstractGraphTransitionJob)this, startPoint, endPoint));
        }
        return transitionPoints;
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithLessPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<FGVertex, Point2D> destinationLocations, FGEdge edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        ArrayList<Point2D> newStartArticulationsPoints = new ArrayList<Point2D>();
        Point2D lastValidStartPoint = this.toLocation((FGVertex)edge.getStart());
        for (int i = 0; i < newArticulations.size(); ++i) {
            Point2D endPoint = newArticulations.get(i);
            Point2D startPoint = (Point2D)lastValidStartPoint.clone();
            if (i < currentArticulations.size()) {
                lastValidStartPoint = startPoint = currentArticulations.get(i);
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints((AbstractGraphTransitionJob)this, startPoint, endPoint));
            newStartArticulationsPoints.add(startPoint);
        }
        edge.setArticulationPoints(newStartArticulationsPoints);
        return transitionPoints;
    }

    private AbstractGraphTransitionJob.TransitionPoints getTransitionPoint(Map<FGVertex, AbstractGraphTransitionJob.TransitionPoints> transitionPoints, Map<FGVertex, Point2D> destinationLocations, FGVertex vertex) {
        FunctionGraph fg = this.getFunctionGraph();
        List<FGVertex> ignore = Arrays.asList(this.groupVertex);
        AbstractGraphTransitionJob.TransitionPoints transtionPoint = transitionPoints.get(vertex = fg.findMatchingVertex(vertex, ignore));
        if (transtionPoint != null) {
            return transtionPoint;
        }
        return this.createTransitionPoint(destinationLocations, vertex);
    }

    private AbstractGraphTransitionJob.TransitionPoints createTransitionPoint(Map<FGVertex, Point2D> destinationLocations, FGVertex vertex) {
        Point2D currentPoint = this.toLocation(vertex);
        Point2D startPoint = (Point2D)currentPoint.clone();
        Point2D endPoint = destinationLocations.get(vertex);
        if (endPoint == null) {
            endPoint = startPoint;
        }
        Point2D destinationPoint = (Point2D)endPoint.clone();
        return new AbstractGraphTransitionJob.TransitionPoints((AbstractGraphTransitionJob)this, startPoint, destinationPoint);
    }
}

