/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.NSNumberTypes;
import ghidra.file.formats.bplist.NSObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class NSNumber
extends NSObject {
    private NSNumberTypes type;
    private double value;

    public NSNumber(boolean value) {
        this.type = NSNumberTypes.BOOLEAN;
        this.value = value ? 1.0 : 0.0;
    }

    public NSNumber(byte value) {
        this.type = NSNumberTypes.BYTE;
        this.value = value;
    }

    public NSNumber(short value) {
        this.type = NSNumberTypes.SHORT;
        this.value = value;
    }

    public NSNumber(int value) {
        this.type = NSNumberTypes.INTEGER;
        this.value = value;
    }

    public NSNumber(long value) {
        this.type = NSNumberTypes.LONG;
        this.value = value;
    }

    public NSNumber(double value) {
        this.type = NSNumberTypes.REAL;
        this.value = value;
    }

    @Override
    public String getType() {
        return "NSNumber";
    }

    public NSNumberTypes getNumberType() {
        return this.type;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean booleanValue() {
        return this.value != 0.0;
    }

    public long longValue() {
        return (long)this.value;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSNumber_" + this.type.name(), 0);
        structure.add(BYTE, "objectDescriptor", null);
        if (this.type == NSNumberTypes.BYTE) {
            structure.add(BYTE, "value", null);
        } else if (this.type == NSNumberTypes.SHORT) {
            structure.add(WORD, "value", null);
        } else if (this.type == NSNumberTypes.INTEGER) {
            structure.add(DWORD, "value", null);
        } else if (this.type == NSNumberTypes.LONG) {
            structure.add(QWORD, "value", null);
        } else if (this.type == NSNumberTypes.REAL) {
            structure.add((DataType)new DoubleDataType(), "value", null);
        } else if (this.type == NSNumberTypes.BOOLEAN) {
            // empty if block
        }
        return structure;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case BOOLEAN: {
                return "" + this.booleanValue();
            }
            case REAL: {
                return "" + this.doubleValue();
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return "" + this.longValue();
            }
        }
        throw new RuntimeException();
    }
}

